/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.repackaged.com.google.common.collect;

import com.google.api.gax.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.api.gax.repackaged.com.google.common.collect.AbstractMapBasedMultiset;
import com.google.api.gax.repackaged.com.google.common.collect.Iterables;
import com.google.api.gax.repackaged.com.google.common.collect.Multisets;
import com.google.api.gax.repackaged.com.google.common.collect.ObjectCountLinkedHashMap;

@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    public static <E> LinkedHashMultiset<E> create() {
        return LinkedHashMultiset.create(3);
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        return new LinkedHashMultiset<E>(distinctElements);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    LinkedHashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    void init(int distinctElements) {
        this.backingMap = new ObjectCountLinkedHashMap(distinctElements);
    }
}

