/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiClock;
import com.google.api.gax.repackaged.com.google.common.base.Preconditions;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithmWithContext;
import java.util.concurrent.ThreadLocalRandom;
import org.threeten.bp.Duration;

public class ExponentialRetryAlgorithm
implements TimedRetryAlgorithmWithContext {
    private final RetrySettings globalSettings;
    private final ApiClock clock;

    public ExponentialRetryAlgorithm(RetrySettings globalSettings, ApiClock clock) {
        this.globalSettings = Preconditions.checkNotNull(globalSettings);
        this.clock = Preconditions.checkNotNull(clock);
    }

    @Override
    public TimedAttemptSettings createFirstAttempt() {
        return TimedAttemptSettings.newBuilder().setGlobalSettings(this.globalSettings).setRetryDelay(Duration.ZERO).setRpcTimeout(this.globalSettings.getInitialRpcTimeout()).setRandomizedRetryDelay(Duration.ZERO).setAttemptCount(0).setOverallAttemptCount(0).setFirstAttemptStartTimeNanos(this.clock.nanoTime()).build();
    }

    @Override
    public TimedAttemptSettings createFirstAttempt(RetryingContext context) {
        if (context.getRetrySettings() == null) {
            return this.createFirstAttempt();
        }
        RetrySettings retrySettings = context.getRetrySettings();
        return TimedAttemptSettings.newBuilder().setGlobalSettings(retrySettings).setRpcTimeout(retrySettings.getInitialRpcTimeout()).setRetryDelay(Duration.ZERO).setRandomizedRetryDelay(Duration.ZERO).setAttemptCount(0).setOverallAttemptCount(0).setFirstAttemptStartTimeNanos(this.clock.nanoTime()).build();
    }

    @Override
    public TimedAttemptSettings createNextAttempt(TimedAttemptSettings previousSettings) {
        RetrySettings settings = previousSettings.getGlobalSettings();
        long newRetryDelay = settings.getInitialRetryDelay().toMillis();
        if (previousSettings.getAttemptCount() > 0) {
            newRetryDelay = (long)(settings.getRetryDelayMultiplier() * (double)previousSettings.getRetryDelay().toMillis());
            newRetryDelay = Math.min(newRetryDelay, settings.getMaxRetryDelay().toMillis());
        }
        Duration randomDelay = Duration.ofMillis((long)this.nextRandomLong(newRetryDelay));
        long newRpcTimeout = (long)(settings.getRpcTimeoutMultiplier() * (double)previousSettings.getRpcTimeout().toMillis());
        newRpcTimeout = Math.min(newRpcTimeout, settings.getMaxRpcTimeout().toMillis());
        if (!settings.getTotalTimeout().isZero()) {
            Duration timeElapsed = Duration.ofNanos((long)this.clock.nanoTime()).minus(Duration.ofNanos((long)previousSettings.getFirstAttemptStartTimeNanos()));
            Duration timeLeft = settings.getTotalTimeout().minus(timeElapsed).minus(randomDelay);
            newRpcTimeout = Math.min(newRpcTimeout, timeLeft.toMillis());
        }
        return TimedAttemptSettings.newBuilder().setGlobalSettings(previousSettings.getGlobalSettings()).setRetryDelay(Duration.ofMillis((long)newRetryDelay)).setRpcTimeout(Duration.ofMillis((long)newRpcTimeout)).setRandomizedRetryDelay(randomDelay).setAttemptCount(previousSettings.getAttemptCount() + 1).setOverallAttemptCount(previousSettings.getOverallAttemptCount() + 1).setFirstAttemptStartTimeNanos(previousSettings.getFirstAttemptStartTimeNanos()).build();
    }

    @Override
    public TimedAttemptSettings createNextAttempt(RetryingContext context, TimedAttemptSettings previousSettings) {
        return this.createNextAttempt(previousSettings);
    }

    @Override
    public boolean shouldRetry(TimedAttemptSettings nextAttemptSettings) {
        RetrySettings globalSettings = nextAttemptSettings.getGlobalSettings();
        int maxAttempts = globalSettings.getMaxAttempts();
        long totalTimeout = globalSettings.getTotalTimeout().toNanos();
        if (totalTimeout == 0L && maxAttempts == 0) {
            return false;
        }
        long totalTimeSpentNanos = this.clock.nanoTime() - nextAttemptSettings.getFirstAttemptStartTimeNanos() + nextAttemptSettings.getRandomizedRetryDelay().toNanos();
        if (totalTimeout > 0L && totalTimeSpentNanos > totalTimeout) {
            return false;
        }
        return maxAttempts <= 0 || nextAttemptSettings.getAttemptCount() < maxAttempts;
    }

    @Override
    public boolean shouldRetry(RetryingContext context, TimedAttemptSettings nextAttemptSettings) {
        return this.shouldRetry(nextAttemptSettings);
    }

    protected long nextRandomLong(long bound) {
        return bound > 0L && this.globalSettings.isJittered() ? ThreadLocalRandom.current().nextLong(bound) : bound;
    }
}

