/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.labs.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.appstats.RpcOperationCostManager;
import com.google.appengine.tools.appstats.StatsProtos;
import java.util.Map;

class StaticRpcOperationCostManager
implements RpcOperationCostManager {
    private static final long MILLION = 1000000L;
    private static final long PER_HUNDRED_THOUSAND = 10L;
    private static final long PER_THOUSAND = 1000L;
    private static final long PER_HUNDRED = 10000L;
    static final Map<StatsProtos.BilledOpProto.BilledOp, Long> COST_MAP = Maps.newHashMap();

    StaticRpcOperationCostManager() {
    }

    private static long perHundredThousand(long centsPerHundredThousand) {
        return centsPerHundredThousand * 10L;
    }

    private static long perThousand(long centsPerThousand) {
        return centsPerThousand * 1000L;
    }

    private static long perHundred(long centsPerHundred) {
        return centsPerHundred * 10000L;
    }

    @Override
    public long costOf(StatsProtos.BilledOpProto.BilledOp op) {
        return COST_MAP.get((Object)op);
    }

    static {
        COST_MAP.put(StatsProtos.BilledOpProto.BilledOp.DATASTORE_READ, StaticRpcOperationCostManager.perHundredThousand(7L));
        COST_MAP.put(StatsProtos.BilledOpProto.BilledOp.DATASTORE_WRITE, StaticRpcOperationCostManager.perHundredThousand(10L));
        COST_MAP.put(StatsProtos.BilledOpProto.BilledOp.DATASTORE_SMALL, StaticRpcOperationCostManager.perHundredThousand(1L));
        COST_MAP.put(StatsProtos.BilledOpProto.BilledOp.MAIL_RECIPIENT, StaticRpcOperationCostManager.perThousand(1L));
        COST_MAP.put(StatsProtos.BilledOpProto.BilledOp.CHANNEL_OPEN, StaticRpcOperationCostManager.perHundred(1L));
        COST_MAP.put(StatsProtos.BilledOpProto.BilledOp.XMPP_STANZA, StaticRpcOperationCostManager.perHundredThousand(10L));
    }
}

