/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class FileBlobStorage
implements BlobStorage {
    private final File rootDirectory;
    private final BlobInfoStorage blobInfoStorage;

    FileBlobStorage(File rootDirectory, BlobInfoStorage blobInfoStorage) {
        this.rootDirectory = rootDirectory;
        this.blobInfoStorage = blobInfoStorage;
    }

    @Override
    public boolean hasBlob(final BlobKey blobKey) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileBlobStorage.this.getFileForBlob(blobKey).exists();
            }
        });
    }

    @Override
    public OutputStream storeBlob(BlobKey blobKey) throws IOException {
        return new FileOutputStream(this.getFileForBlob(blobKey));
    }

    @Override
    public InputStream fetchBlob(final BlobKey blobKey) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(FileBlobStorage.this.getFileForBlob(blobKey));
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    @Override
    public void deleteBlob(BlobKey blobKey) throws IOException {
        if (this.blobInfoStorage.loadBlobInfo(blobKey) == null) {
            throw new RuntimeException("Unknown blobkey: " + blobKey);
        }
        File file = this.getFileForBlob(blobKey);
        if (!file.delete()) {
            throw new IOException("Could not delete: " + file);
        }
        this.blobInfoStorage.deleteBlobInfo(blobKey);
    }

    private File getFileForBlob(BlobKey blobKey) {
        if (blobKey.getKeyString().contains(File.separator)) {
            throw new RuntimeException("illegal blobKey: " + blobKey.getKeyString());
        }
        File file = new File(this.rootDirectory, blobKey.getKeyString());
        if (!file.getAbsoluteFile().getParent().equals(this.rootDirectory.getPath())) {
            throw new RuntimeException("illegal blobKey: " + blobKey.getKeyString());
        }
        return file;
    }
}

