/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Map;

public class EndpointMethod {
    private final Class<?> endpointClass;
    private final Method method;
    private final Map<Type, Type> resolvedTypes;
    private final ResolvedSignature resolvedMethodSignature;

    private EndpointMethod(Class<?> endpointClass, Method method, Map<Type, Type> resolvedTypes) {
        this.endpointClass = endpointClass;
        this.method = method;
        this.resolvedTypes = resolvedTypes;
        this.resolvedMethodSignature = new ResolvedSignature();
    }

    private Type resolve(Type type) {
        Type t = this.resolvedTypes.get(type);
        if (t != null) {
            return t;
        }
        if (type instanceof ParameterizedType) {
            t = new ResolvedParameterizedType((ParameterizedType)type);
            this.resolvedTypes.put(type, t);
            return t;
        }
        if (type instanceof GenericArrayType) {
            t = new ResolvedGenericArrayType((GenericArrayType)type);
            this.resolvedTypes.put(type, t);
            return t;
        }
        if (type instanceof WildcardType) {
            throw new IllegalArgumentException(String.format("Wildcard type %s not supported", type));
        }
        return type;
    }

    private Type[] resolve(Type[] types) {
        Type[] resolved = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = this.resolve(types[i]);
        }
        return resolved;
    }

    private static Class<?>[] resolveClasses(Type[] types) {
        Class[] resolved = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = EndpointMethod.getClassFromType(types[i]);
        }
        return resolved;
    }

    public static Class<?> getClassFromType(Type type) {
        Type componentType;
        Class<?> componentClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return EndpointMethod.getClassFromType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (componentClass = EndpointMethod.getClassFromType(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public Type getReturnType() {
        return this.resolve(this.method.getGenericReturnType());
    }

    public Type[] getParameterTypes() {
        return this.resolve(this.method.getGenericParameterTypes());
    }

    public Class<?>[] getParameterClasses() {
        return EndpointMethod.resolveClasses(this.getParameterTypes());
    }

    public static EndpointMethod create(Class<?> endpointClass, Method method, Map<Type, Type> resolvedTypes) {
        Preconditions.checkNotNull(endpointClass, (Object)"endpointClass");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull(resolvedTypes, (Object)"resolvedTypes");
        if (!method.getDeclaringClass().isAssignableFrom(endpointClass)) {
            throw new IllegalArgumentException(String.format("Method '%s' does belong to interface of class '%s'", method, endpointClass));
        }
        EndpointMethod endpointMethod = new EndpointMethod(endpointClass, method, resolvedTypes);
        endpointMethod.getReturnType();
        endpointMethod.getParameterTypes();
        return endpointMethod;
    }

    public ResolvedSignature getResolvedMethodSignature() {
        return this.resolvedMethodSignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointMethod)) {
            return false;
        }
        EndpointMethod m = (EndpointMethod)o;
        return this.getMethod().equals(m.getMethod());
    }

    public String toString() {
        return "Method: " + this.getMethod().toString() + ", Resolved Return Type: " + this.getReturnType() + ", Resolved Parameter Types: " + Arrays.toString(this.getParameterTypes());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMethod()});
    }

    public class ResolvedSignature {
        public String getSignatureName() {
            return EndpointMethod.this.getMethod().getName();
        }

        public Class<?>[] getSignatureParameterClasses() {
            return EndpointMethod.this.getParameterClasses();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolvedSignature)) {
                return false;
            }
            ResolvedSignature signature = (ResolvedSignature)o;
            return this.getSignatureName().equals(signature.getSignatureName()) && Arrays.equals(this.getSignatureParameterClasses(), signature.getSignatureParameterClasses());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSignatureName(), Arrays.hashCode(this.getSignatureParameterClasses())});
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getSignatureName()).append("(");
            for (Class<?> clazz : this.getSignatureParameterClasses()) {
                builder.append(clazz.toString()).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            builder.append(")");
            return builder.toString();
        }
    }

    private class ResolvedGenericArrayType
    implements GenericArrayType {
        private final Type genericComponentType;

        public ResolvedGenericArrayType(GenericArrayType genericArrayType) {
            this.genericComponentType = EndpointMethod.this.resolve((Type)Preconditions.checkNotNull((Object)genericArrayType.getGenericComponentType(), (Object)"genericComponentType"));
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public String toString() {
            return Array.newInstance(EndpointMethod.getClassFromType(this.genericComponentType), 0).toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType that = (GenericArrayType)o;
            return this.genericComponentType.equals(that.getGenericComponentType());
        }

        public int hashCode() {
            return this.genericComponentType.hashCode();
        }
    }

    private class ResolvedParameterizedType
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] actualTypeArguments;
        private final Type ownerType;

        public ResolvedParameterizedType(ParameterizedType parameterizedType) {
            this.rawType = (Type)Preconditions.checkNotNull((Object)parameterizedType.getRawType(), (Object)"rawType");
            this.actualTypeArguments = EndpointMethod.this.resolve((Type[])Preconditions.checkNotNull((Object)parameterizedType.getActualTypeArguments(), (Object)"actualTypeArguments"));
            this.ownerType = parameterizedType.getOwnerType();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getRawType().toString());
            Type[] resolvedTypeArguments = this.getActualTypeArguments();
            if (resolvedTypeArguments.length != 0) {
                builder.append('<').append(resolvedTypeArguments[0]);
                for (int i = 1; i < resolvedTypeArguments.length; ++i) {
                    builder.append(", ").append(resolvedTypeArguments[i]);
                }
                builder.append('>');
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)o;
            Type thatOwner = that.getOwnerType();
            Type thatRawType = that.getRawType();
            return Objects.equal((Object)this.ownerType, (Object)thatOwner) && this.rawType.equals(thatRawType) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.actualTypeArguments), this.ownerType, this.rawType});
        }
    }
}

