/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EndpointMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodHierarchyReader {
    private final Class<?> endpointClass;
    private Map<EndpointMethod.ResolvedSignature, List<EndpointMethod>> endpointMethods;

    public MethodHierarchyReader(Class<?> endpointClass) {
        if (Modifier.isAbstract(endpointClass.getModifiers()) || Modifier.isInterface(endpointClass.getModifiers())) {
            throw new IllegalArgumentException(String.format("A concrete class is expected, but got %s.", endpointClass.getName()));
        }
        this.endpointClass = endpointClass;
        this.endpointMethods = null;
    }

    private void readMethodHierarchyIfNecessary() {
        if (this.endpointMethods == null) {
            this.endpointMethods = new HashMap<EndpointMethod.ResolvedSignature, List<EndpointMethod>>();
            this.addServiceMethods(this.endpointClass, this.endpointClass, new HashMap<Type, Type>());
        }
    }

    public Collection<Method> getLeafMethods() {
        this.readMethodHierarchyIfNecessary();
        ArrayList<Method> methods = new ArrayList<Method>(this.endpointMethods.size());
        for (List<EndpointMethod> endpointMethod : this.endpointMethods.values()) {
            methods.add(endpointMethod.get(0).getMethod());
        }
        return methods;
    }

    public Collection<EndpointMethod> getLeafEndpointMethods() {
        this.readMethodHierarchyIfNecessary();
        ArrayList<EndpointMethod> methods = new ArrayList<EndpointMethod>(this.endpointMethods.size());
        for (List<EndpointMethod> endpointMethod : this.endpointMethods.values()) {
            methods.add(endpointMethod.get(0));
        }
        return methods;
    }

    public Collection<List<Method>> getMethodOverrides() {
        this.readMethodHierarchyIfNecessary();
        ArrayList<List<Method>> methods = new ArrayList<List<Method>>(this.endpointMethods.size());
        for (List<EndpointMethod> overrides : this.endpointMethods.values()) {
            ArrayList<Method> list = new ArrayList<Method>(overrides.size());
            for (EndpointMethod method : overrides) {
                list.add(method.getMethod());
            }
            methods.add(list);
        }
        return methods;
    }

    public Collection<List<EndpointMethod>> getEndpointOverrides() {
        this.readMethodHierarchyIfNecessary();
        ArrayList<List<EndpointMethod>> methods = new ArrayList<List<EndpointMethod>>(this.endpointMethods.size());
        for (List<EndpointMethod> endpointMethod : this.endpointMethods.values()) {
            ArrayList<EndpointMethod> listCopy = new ArrayList<EndpointMethod>(endpointMethod);
            methods.add(listCopy);
        }
        return methods;
    }

    public Map<String, Method> getNameToLeafMethodMap() {
        this.readMethodHierarchyIfNecessary();
        HashMap<String, Method> methods = new HashMap<String, Method>(this.endpointMethods.size());
        for (List<EndpointMethod> overrides : this.endpointMethods.values()) {
            methods.put(overrides.get(0).getMethod().getName(), overrides.get(0).getMethod());
        }
        return methods;
    }

    public Map<String, List<EndpointMethod>> getNameToEndpointOverridesMap() {
        this.readMethodHierarchyIfNecessary();
        HashMap<String, List<EndpointMethod>> methods = new HashMap<String, List<EndpointMethod>>(this.endpointMethods.size());
        for (List<EndpointMethod> overrides : this.endpointMethods.values()) {
            ArrayList<EndpointMethod> listCopy = new ArrayList<EndpointMethod>(overrides);
            methods.put(overrides.get(0).getMethod().getName(), listCopy);
        }
        return methods;
    }

    private void addServiceMethods(Class<?> serviceClass, Type serviceType, Map<Type, Type> resolvedTypes) {
        if (Object.class.equals(serviceClass)) {
            return;
        }
        if (serviceType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)serviceType;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParameters = serviceClass.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type resolved = resolvedTypes.get(actualTypeArguments[i]);
                resolvedTypes.put(typeParameters[i], resolved != null ? resolved : actualTypeArguments[i]);
            }
        }
        for (Method method : serviceClass.getDeclaredMethods()) {
            if (!MethodHierarchyReader.isServiceMethod(method)) continue;
            EndpointMethod currentMethod = EndpointMethod.create(this.endpointClass, method, resolvedTypes);
            List<EndpointMethod> overrides = this.endpointMethods.get(currentMethod.getResolvedMethodSignature());
            if (overrides == null) {
                overrides = new ArrayList<EndpointMethod>();
                this.endpointMethods.put(currentMethod.getResolvedMethodSignature(), overrides);
            }
            overrides.add(currentMethod);
        }
        this.addServiceMethods(serviceClass.getSuperclass(), serviceClass.getGenericSuperclass(), resolvedTypes);
    }

    static boolean isServiceMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !method.isBridge();
    }
}

