/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApiFrontendLimitsConfig {
    private int unregisteredUserQps;
    private int unregisteredQps;
    private int unregisteredDaily;
    private final Map<String, FrontendLimitsRule> rules;

    public ApiFrontendLimitsConfig() {
        this.rules = new LinkedHashMap<String, FrontendLimitsRule>();
        this.setDefaults();
    }

    public ApiFrontendLimitsConfig(ApiFrontendLimitsConfig original) {
        this.unregisteredUserQps = original.unregisteredUserQps;
        this.unregisteredQps = original.unregisteredQps;
        this.unregisteredDaily = original.unregisteredDaily;
        this.rules = new LinkedHashMap<String, FrontendLimitsRule>(original.rules);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiFrontendLimitsConfig) {
            ApiFrontendLimitsConfig config = (ApiFrontendLimitsConfig)o;
            return this.unregisteredUserQps == config.unregisteredUserQps && this.unregisteredQps == config.unregisteredQps && this.unregisteredDaily == config.unregisteredDaily && this.rules.equals(config.rules);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.unregisteredUserQps, this.unregisteredQps, this.unregisteredDaily, this.rules});
    }

    protected void setDefaults() {
        this.unregisteredUserQps = -1;
        this.unregisteredQps = -1;
        this.unregisteredDaily = -1;
    }

    public void setUnregisteredUserQps(int unregisteredUserQps) {
        this.unregisteredUserQps = unregisteredUserQps;
    }

    public int getUnregisteredUserQps() {
        return this.unregisteredUserQps;
    }

    public void setUnregisteredQps(int unregisteredQps) {
        this.unregisteredQps = unregisteredQps;
    }

    public int getUnregisteredQps() {
        return this.unregisteredQps;
    }

    public void setUnregisteredDaily(int unregisteredDaily) {
        this.unregisteredDaily = unregisteredDaily;
    }

    public int getUnregisteredDaily() {
        return this.unregisteredDaily;
    }

    public void addRule(String match, int qps, int userQps, int daily, String analyticsId) {
        this.rules.put(match, new FrontendLimitsRule(match, qps, userQps, daily, analyticsId));
    }

    public List<FrontendLimitsRule> getRules() {
        return new ArrayList<FrontendLimitsRule>(this.rules.values());
    }

    public static class FrontendLimitsRule {
        private final String match;
        private final int qps;
        private final int userQps;
        private final int daily;
        private final String analyticsId;

        public FrontendLimitsRule(String match, int qps, int userQps, int daily, String analyticsId) {
            this.match = match;
            this.qps = qps;
            this.userQps = userQps;
            this.daily = daily;
            this.analyticsId = analyticsId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FrontendLimitsRule) {
                FrontendLimitsRule rule = (FrontendLimitsRule)o;
                return Objects.equal((Object)this.match, (Object)rule.match) && this.qps == rule.qps && this.userQps == rule.userQps && this.daily == rule.daily && Objects.equal((Object)this.analyticsId, (Object)rule.analyticsId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.match, this.qps, this.userQps, this.daily, this.analyticsId});
        }

        public String getMatch() {
            return this.match;
        }

        public int getQps() {
            return this.qps;
        }

        public int getUserQps() {
            return this.userQps;
        }

        public int getDaily() {
            return this.daily;
        }

        public String getAnalyticsId() {
            return this.analyticsId;
        }
    }
}

