/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ResourceSerializer;
import com.google.api.server.spi.config.Serializer;
import com.google.api.server.spi.config.Serializers;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ApiParameterConfig {
    private final ApiMethodConfig apiMethodConfig;
    private final String name;
    private final boolean nullable;
    private final String defaultValue;
    private final Type type;
    private Class<? extends Serializer<?, ?>> serializer;
    private Class<? extends Serializer<?, ?>> repeatedItemSerializer;
    private final TypeLoader typeLoader;

    public ApiParameterConfig(ApiMethodConfig apiMethodConfig, String name, boolean nullable, String defaultValue, Type type, TypeLoader typeLoader) {
        this.apiMethodConfig = apiMethodConfig;
        this.name = name;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.type = type;
        this.serializer = null;
        this.repeatedItemSerializer = null;
        this.typeLoader = typeLoader;
    }

    public ApiParameterConfig(ApiParameterConfig original, ApiMethodConfig apiMethodConfig) {
        this.apiMethodConfig = apiMethodConfig;
        this.name = original.name;
        this.nullable = original.nullable;
        this.defaultValue = original.defaultValue;
        this.type = original.type;
        this.serializer = original.serializer;
        this.repeatedItemSerializer = original.repeatedItemSerializer;
        this.typeLoader = original.typeLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiParameterConfig) {
            ApiParameterConfig parameter = (ApiParameterConfig)o;
            return Objects.equal((Object)this.name, (Object)parameter.name) && this.nullable == parameter.nullable && Objects.equal((Object)this.defaultValue, (Object)parameter.defaultValue) && Objects.equal((Object)this.type, (Object)parameter.type) && Objects.equal(this.serializer, parameter.serializer) && Objects.equal(this.repeatedItemSerializer, parameter.repeatedItemSerializer) && Objects.equal((Object)this.typeLoader, (Object)parameter.typeLoader);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.nullable, this.defaultValue, this.type, this.serializer, this.repeatedItemSerializer, this.typeLoader});
    }

    public ApiMethodConfig getApiMethodConfig() {
        return this.apiMethodConfig;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Type getType() {
        return this.type;
    }

    public Type getRepeatedItemType() {
        return TypeLoader.getArrayItemType(this.getSchemaBaseType());
    }

    public boolean isRepeated() {
        if (this.typeLoader.isInjectedType(this.getType())) {
            return false;
        }
        return TypeLoader.isArrayType(this.getSchemaBaseType());
    }

    public boolean isEnum() {
        if (this.typeLoader.isInjectedType(this.getType())) {
            return false;
        }
        Type type = this.isRepeated() ? this.getRepeatedItemSerializedType() : this.getSchemaBaseType();
        return TypeLoader.isEnumType(type);
    }

    private List<Class<? extends Serializer<?, ?>>> tryFindDefaultSerializers(@Nullable Type type) {
        ApiSerializationConfig serializerConfig = this.apiMethodConfig.getApiClassConfig().getApiConfig().getSerializationConfig();
        return Serializers.getSerializerClasses(type, serializerConfig);
    }

    public List<Class<? extends Serializer<?, ?>>> getSerializers() {
        if (this.serializer != null) {
            return Collections.singletonList(this.serializer);
        }
        return this.tryFindDefaultSerializers(this.getType());
    }

    public void setSerializer(Class<? extends Serializer<?, ?>> serializer) {
        this.serializer = serializer;
    }

    public List<Class<? extends Serializer<?, ?>>> getRepeatedItemSerializers() {
        if (this.repeatedItemSerializer != null) {
            return Collections.singletonList(this.repeatedItemSerializer);
        }
        return this.tryFindDefaultSerializers(TypeLoader.getArrayItemType(this.getSchemaBaseType()));
    }

    public void setRepeatedItemSerializer(Class<? extends Serializer<?, ?>> repeatedItemSerializer) {
        this.repeatedItemSerializer = repeatedItemSerializer;
    }

    public Type getSchemaBaseType() {
        List<Class<Serializer<?, ?>>> serializers = this.getSerializers();
        if (serializers.isEmpty()) {
            return this.getType();
        }
        if (ResourceSerializer.class.isAssignableFrom(serializers.get(0))) {
            return this.getType();
        }
        return Serializers.getTargetType(serializers.get(0));
    }

    public Type getRepeatedItemSerializedType() {
        List<Class<Serializer<?, ?>>> serializers = this.getRepeatedItemSerializers();
        if (serializers.isEmpty()) {
            return this.getRepeatedItemType();
        }
        return Serializers.getTargetType(serializers.get(0));
    }

    public Classification getClassification() {
        if (this.typeLoader.isInjectedType(this.type)) {
            return Classification.INJECTED;
        }
        Type type = this.isRepeated() ? this.getRepeatedItemSerializedType() : this.getSchemaBaseType();
        if (this.typeLoader.isParameterType(type) || TypeLoader.isEnumType(type)) {
            return Classification.API_PARAMETER;
        }
        if (TypeLoader.isGenericType(type)) {
            return Classification.UNKNOWN;
        }
        return Classification.RESOURCE;
    }

    public static enum Classification {
        INJECTED,
        API_PARAMETER,
        RESOURCE,
        UNKNOWN;

    }
}

