/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.reflect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.common.primitives.Primitives;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;

@Beta
public final class Reflection {
    public static String getPackageName(Class<?> clazz) {
        return Reflection.getPackageName(clazz.getName());
    }

    public static String getPackageName(String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        return lastDot < 0 ? "" : classFullName.substring(0, lastDot);
    }

    public static void initialize(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Preconditions.checkNotNull((Object)handler);
        Preconditions.checkArgument((boolean)interfaceType.isInterface(), (String)"%s is not an interface", (Object[])new Object[]{interfaceType});
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    @GoogleInternal
    public static <T, R> Function<T, R> invoker(Class<T> declaringClass, String methodName, Class<R> returnType) {
        Method method;
        Preconditions.checkNotNull(declaringClass);
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull(returnType);
        try {
            method = declaringClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(declaringClass + "#" + methodName, e);
        }
        Preconditions.checkArgument((boolean)Modifier.isPublic(method.getDeclaringClass().getModifiers()), (String)"%s is declared in a non-public class", (Object[])new Object[]{method});
        Preconditions.checkArgument((!Modifier.isStatic(method.getModifiers()) ? 1 : 0) != 0, (String)"%s is static", (Object[])new Object[]{method});
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            Preconditions.checkArgument((RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType) ? 1 : 0) != 0, (String)"%s throws checked exceptions", (Object[])new Object[]{method});
        }
        Preconditions.checkArgument((Void.TYPE != method.getReturnType() ? 1 : 0) != 0, (String)"%s returns void", (Object[])new Object[]{method});
        Preconditions.checkArgument((boolean)returnType.isAssignableFrom(Primitives.wrap(method.getReturnType())), (String)"%s does not return a subtype of %s", (Object[])new Object[]{method, returnType});
        return new Invoker(method, returnType);
    }

    private Reflection() {
    }

    @GoogleInternal
    private static final class Invoker<T, R>
    implements Function<T, R> {
        private final Method method;
        private final Class<R> returnType;

        public Invoker(Method method, Class<R> returnType) {
            this.method = method;
            this.returnType = returnType;
        }

        public R apply(T from) {
            try {
                return this.returnType.cast(this.method.invoke(from, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)(this.method + " inaccessible")))).initCause(e));
            }
            catch (InvocationTargetException e) {
                Throwables.propagateIfPossible((Throwable)e.getTargetException());
                throw new AssertionError((Object)e);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Invoker && this.method.equals(((Invoker)obj).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "Reflection.invoker(" + this.method + ")";
        }
    }
}

