/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;

public final class LocalDatastoreServiceTestConfig
implements LocalServiceTestConfig {
    private Boolean noStorage = true;
    private Integer maxQueryLifetimeMs;
    private Integer maxTxnLifetimeMs;
    private Integer storeDelayMs;
    private String backingStoreLocation;
    private Boolean noIndexAutoGen = true;
    private Long defaultHighRepJobPolicyRandomSeed;
    private Float defaultHighRepJobPolicyUnappliedJobPercentage;
    private Class<? extends HighRepJobPolicy> alternateHighRepJobPolicyClass;

    public boolean isNoStorage() {
        return this.noStorage;
    }

    public LocalDatastoreServiceTestConfig setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
        return this;
    }

    public Integer getMaxQueryLifetimeMs() {
        return this.maxQueryLifetimeMs;
    }

    public LocalDatastoreServiceTestConfig setMaxQueryLifetimeMs(int maxQueryLifetimeMs) {
        this.maxQueryLifetimeMs = maxQueryLifetimeMs;
        return this;
    }

    public Integer getMaxTxnLifetimeMs() {
        return this.maxTxnLifetimeMs;
    }

    public LocalDatastoreServiceTestConfig setMaxTxnLifetimeMs(int maxTxnLifetimeMs) {
        this.maxTxnLifetimeMs = maxTxnLifetimeMs;
        return this;
    }

    public Integer getStoreDelayMs() {
        return this.storeDelayMs;
    }

    public LocalDatastoreServiceTestConfig setStoreDelayMs(int storeDelayMs) {
        this.storeDelayMs = storeDelayMs;
        return this;
    }

    public String getBackingStoreLocation() {
        return this.backingStoreLocation;
    }

    public LocalDatastoreServiceTestConfig setBackingStoreLocation(String backingStoreLocation) {
        this.backingStoreLocation = backingStoreLocation;
        return this;
    }

    public boolean isNoIndexAutoGen() {
        return this.noIndexAutoGen;
    }

    public LocalDatastoreServiceTestConfig setNoIndexAutoGen(boolean noIndexAutoGen) {
        this.noIndexAutoGen = noIndexAutoGen;
        return this;
    }

    public Long getDefaultHighRepJobPolicyRandomSeed() {
        return this.defaultHighRepJobPolicyRandomSeed;
    }

    public LocalDatastoreServiceTestConfig setDefaultHighRepJobPolicyRandomSeed(long defaultHighRepJobPolicyRandomSeed) {
        if (this.alternateHighRepJobPolicyClass != null) {
            throw new IllegalArgumentException("setAlternateHighRepJobPolicyClass() has already been called.");
        }
        this.defaultHighRepJobPolicyRandomSeed = defaultHighRepJobPolicyRandomSeed;
        return this;
    }

    public Float getDefaultHighRepJobPolicyUnappliedJobPercentage() {
        return this.defaultHighRepJobPolicyUnappliedJobPercentage;
    }

    public LocalDatastoreServiceTestConfig setDefaultHighRepJobPolicyUnappliedJobPercentage(float defaultHighRepJobPolicyUnappliedJobPercentage) {
        if (this.alternateHighRepJobPolicyClass != null) {
            throw new IllegalArgumentException("setAlternateHighRepJobPolicyClass() has already been called.");
        }
        this.defaultHighRepJobPolicyUnappliedJobPercentage = Float.valueOf(defaultHighRepJobPolicyUnappliedJobPercentage);
        return this;
    }

    public Class<? extends HighRepJobPolicy> getAlternateHighRepJobPolicyClass() {
        return this.alternateHighRepJobPolicyClass;
    }

    public LocalDatastoreServiceTestConfig setAlternateHighRepJobPolicyClass(Class<? extends HighRepJobPolicy> alternateHighRepJobPolicyClass) {
        if (this.defaultHighRepJobPolicyRandomSeed != null) {
            throw new IllegalArgumentException("setDefaultHighRepJobPolicyRandomSeed() has already been called.");
        }
        if (this.defaultHighRepJobPolicyUnappliedJobPercentage != null) {
            throw new IllegalArgumentException("defaultHighRepJobPolicyUnappliedJobPercentage() has already been called.");
        }
        this.alternateHighRepJobPolicyClass = alternateHighRepJobPolicyClass;
        return this;
    }

    public LocalDatastoreServiceTestConfig setApplyAllHighRepJobPolicy() {
        return this.setAlternateHighRepJobPolicyClass(ApplyAll.class);
    }

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("datastore.no_storage", this.noStorage.toString());
        if (this.maxQueryLifetimeMs != null) {
            proxy.setProperty("datastore.max_query_lifetime", Integer.valueOf(this.maxQueryLifetimeMs).toString());
        }
        if (this.maxTxnLifetimeMs != null) {
            proxy.setProperty("datastore.max_txn_lifetime", Integer.valueOf(this.maxTxnLifetimeMs).toString());
        }
        if (this.storeDelayMs != null) {
            proxy.setProperty("datastore.store_delay", Integer.valueOf(this.storeDelayMs).toString());
        }
        if (this.backingStoreLocation != null) {
            proxy.setProperty("datastore.backing_store", this.backingStoreLocation);
        }
        proxy.setProperty("datastore.no_index_auto_gen", this.noIndexAutoGen.toString());
        if (this.defaultHighRepJobPolicyRandomSeed != null) {
            proxy.setProperty("datastore.default_high_rep_job_policy_random_seed", Long.valueOf(this.defaultHighRepJobPolicyRandomSeed).toString());
        }
        if (this.defaultHighRepJobPolicyUnappliedJobPercentage != null) {
            proxy.setProperty("datastore.default_high_rep_job_policy_unapplied_job_pct", Float.valueOf(this.defaultHighRepJobPolicyUnappliedJobPercentage.floatValue()).toString());
        }
        if (this.alternateHighRepJobPolicyClass != null) {
            proxy.setProperty("datastore.high_replication_job_policy_class", this.alternateHighRepJobPolicyClass.getName());
        }
    }

    @Override
    public void tearDown() {
        LocalDatastoreService datastoreService = LocalDatastoreServiceTestConfig.getLocalDatastoreService();
        datastoreService.clearProfiles();
        datastoreService.clearQueryHistory();
    }

    public static LocalDatastoreService getLocalDatastoreService() {
        return (LocalDatastoreService)LocalServiceTestHelper.getLocalService("datastore_v3");
    }

    static class ApplyAll
    implements HighRepJobPolicy {
        ApplyAll() {
        }

        public boolean shouldApplyNewJob(Key entityGroup) {
            return true;
        }

        public boolean shouldRollForwardExistingJob(Key entityGroup) {
            return true;
        }
    }
}

