/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.io.base.CoreMarshallers;
import com.google.appengine.repackaged.com.google.io.base.MarshalledBy;
import com.google.appengine.repackaged.com.google.io.base.Marshaller;
import com.google.appengine.repackaged.com.google.io.base.VarInt;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Marshallers
extends CoreMarshallers {
    public static final Marshaller<String> UTF8_MARSHALLER = CoreMarshallers.UTF8_MARSHALLER;
    public static final Marshaller<String> ISO_8859_1_MARSHALLER = CoreMarshallers.ISO_8859_1_MARSHALLER;
    public static final Marshaller<String> US_ASCII_MARSHALLER = CoreMarshallers.US_ASCII_MARSHALLER;
    public static final Marshaller<Integer> STRING_INTEGER_MARSHALLER = CoreMarshallers.STRING_INTEGER_MARSHALLER;
    public static final Marshaller<Long> STRING_LONG_MARSHALLER = CoreMarshallers.STRING_LONG_MARSHALLER;
    public static final Marshaller<Float> FLOAT_MARSHALLER = CoreMarshallers.FLOAT_MARSHALLER;
    public static final Marshaller<Float> BIG_ENDIAN_FLOAT_MARSHALLER = CoreMarshallers.BIG_ENDIAN_FLOAT_MARSHALLER;
    public static final Marshaller<Double> DOUBLE_MARSHALLER = CoreMarshallers.DOUBLE_MARSHALLER;
    public static final Marshaller<Double> BIG_ENDIAN_DOUBLE_MARSHALLER = CoreMarshallers.BIG_ENDIAN_DOUBLE_MARSHALLER;
    public static final Marshaller<Integer> INTEGER_MARSHALLER = CoreMarshallers.INTEGER_MARSHALLER;
    public static final Marshaller<Integer> BIG_ENDIAN_INTEGER_MARSHALLER = CoreMarshallers.BIG_ENDIAN_INTEGER_MARSHALLER;
    public static final Marshaller<Short> SHORT_MARSHALLER = CoreMarshallers.SHORT_MARSHALLER;
    public static final Marshaller<Short> BIG_ENDIAN_SHORT_MARSHALLER = CoreMarshallers.BIG_ENDIAN_SHORT_MARSHALLER;
    public static final Marshaller<Long> LONG_MARSHALLER = CoreMarshallers.LONG_MARSHALLER;
    public static final Marshaller<Long> BIG_ENDIAN_LONG_MARSHALLER = CoreMarshallers.BIG_ENDIAN_LONG_MARSHALLER;
    public static final Marshaller<Double> STRING_DOUBLE_MARSHALLER = CoreMarshallers.STRING_DOUBLE_MARSHALLER;
    public static final Marshaller<Long> VAR_LONG_MARSHALLER = new VarLongMarshaller();
    public static final Marshaller<byte[]> BYTE_ARRAY_MARSHALLER = CoreMarshallers.BYTE_ARRAY_MARSHALLER;
    public static final Marshaller<byte[]> ALIASING_BYTE_ARRAY_MARSHALLER = CoreMarshallers.ALIASING_BYTE_ARRAY_MARSHALLER;
    public static final Marshaller<ByteBuffer> BYTE_BUFFER_MARSHALLER = CoreMarshallers.BYTE_BUFFER_MARSHALLER;
    public static final Marshaller<ByteBuffer> ALIASING_BYTE_BUFFER_MARSHALLER = CoreMarshallers.ALIASING_BYTE_BUFFER_MARSHALLER;

    private Marshallers() {
    }

    public static Marshaller<String> stringMarshaller(String encoding) {
        return CoreMarshallers.stringMarshaller(encoding);
    }

    public static <T extends ProtocolMessage<T>> Marshaller<T> protocolMessageMarshaller(T template) {
        return new SafeProtocolMessageMarshaller<T>(template);
    }

    public static <T extends ProtocolMessage<T>> Marshaller<T> recyclingProtocolMessageMarshaller(T template) {
        return new RecyclingProtocolMessageMarshaller<T>(template);
    }

    public static <T extends Serializable> Marshaller<T> serializationMarshaller() {
        return CoreMarshallers.serializationMarshaller();
    }

    public static <T> Marshaller<T> nullMarshaller() {
        return CoreMarshallers.nullMarshaller();
    }

    public static <A, B> Marshaller<A> compose(Marshaller<B> marshaller, Converter<A, B> converter) {
        return new CompositionMarshaller<A, B>(marshaller, converter);
    }

    public static <T> byte[] toByteArray(Marshaller<T> marshaller, ByteOrder order, T object) {
        return CoreMarshallers.toByteArray(marshaller, order, object);
    }

    public static <T> byte[] toByteArray(Marshaller<T> marshaller, T object) {
        return CoreMarshallers.toByteArray(marshaller, object);
    }

    public static boolean hasDefault(Class<?> cls) {
        return cls.isAnnotationPresent(MarshalledBy.class);
    }

    public static <T> Marshaller<T> of(Class<T> dataClass) {
        Object[] args;
        MarshalledBy defaultMarshaller = dataClass.getAnnotation(MarshalledBy.class);
        if (defaultMarshaller == null) {
            String string = String.valueOf(dataClass);
            throw new IllegalArgumentException(new StringBuilder(31 + String.valueOf(string).length()).append("No @MarshalledBy annotation on ").append(string).toString());
        }
        Class<? extends Marshaller> marshallerClass = defaultMarshaller.value();
        Constructor<?>[] ctors = marshallerClass.getConstructors();
        if (ctors.length != 1) {
            String string = String.valueOf(marshallerClass);
            throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(string).length()).append("Expected exactly one public constructor for ").append(string).toString());
        }
        Constructor<?> ctor = ctors[0];
        Class<?>[] params = ctor.getParameterTypes();
        if (params.length == 0) {
            args = new Object[]{};
        } else if (params.length == 1 && params[0] == Class.class) {
            args = new Object[]{dataClass};
        } else {
            String string = String.valueOf(marshallerClass);
            throw new IllegalArgumentException(new StringBuilder(60 + String.valueOf(string).length()).append("Constructor for ").append(string).append(" must take either no arguments, or one Class").toString());
        }
        try {
            return (Marshaller)ctor.newInstance(args);
        }
        catch (Exception ex) {
            String string = String.valueOf(marshallerClass);
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Error instantiating ").append(string).toString(), ex);
        }
    }

    private static class VarLongMarshaller
    extends VariableSizeMarshaller<Long> {
        private VarLongMarshaller() {
        }

        @Override
        public void marshal(Long object, ByteBuffer sink) {
            VarInt.putVarLong(object, sink);
        }

        @Override
        public Long unmarshal(ByteBuffer source) {
            return VarInt.getVarLong(source);
        }

        @Override
        public int maxEncodingSize(Long object) {
            return 10;
        }
    }

    private static class CompositionMarshaller<A, B>
    implements Marshaller<A>,
    Serializable {
        final Marshaller<B> marshaller;
        final Converter<A, B> converter;
        private static final long serialVersionUID = 0L;

        CompositionMarshaller(Marshaller<B> marshaller, Converter<A, B> converter) {
            this.marshaller = Preconditions.checkNotNull(marshaller);
            this.converter = Preconditions.checkNotNull(converter);
        }

        @Override
        public void marshal(A object, ByteBuffer sink) {
            B converted = this.converter.convert(object);
            this.marshaller.marshal(converted, sink);
        }

        @Override
        public A unmarshal(ByteBuffer source) {
            B unmarshalled = this.marshaller.unmarshal(source);
            return this.converter.reverse().convert(unmarshalled);
        }

        @Override
        public int maxEncodingSize(A object) {
            B converted = this.converter.convert(object);
            return this.marshaller.maxEncodingSize(converted);
        }

        @Override
        public boolean isUnmarshalRestrained() {
            return this.marshaller.isUnmarshalRestrained();
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return this.marshaller.isMaxEncodingSizeTight();
        }

        @Override
        public boolean isEncodingSizeConstant() {
            return this.marshaller.isEncodingSizeConstant();
        }
    }

    private static class RecyclingProtocolMessageMarshaller<T extends ProtocolMessage<T>>
    extends AbstractProtocolMessageMarshaller<T> {
        private static final long serialVersionUID = 1027309L;

        RecyclingProtocolMessageMarshaller(T template) {
            super(((ProtocolMessage)template).newInstance());
        }

        @Override
        public T unmarshal(ByteBuffer source) {
            this.template.parseFrom(source);
            return (T)this.template;
        }
    }

    private static class SafeProtocolMessageMarshaller<T extends ProtocolMessage<T>>
    extends AbstractProtocolMessageMarshaller<T> {
        private static final long serialVersionUID = 16435934L;

        SafeProtocolMessageMarshaller(T template) {
            super(template);
        }

        @Override
        public T unmarshal(ByteBuffer source) {
            Object result = this.template.newInstance();
            if (((ProtocolMessage)result).mergeFrom(source)) {
                return result;
            }
            String string = String.valueOf(this.template.getClass().getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Failed to unmarshal protocol message of type ".concat(string) : new String("Failed to unmarshal protocol message of type "));
        }
    }

    private static abstract class AbstractProtocolMessageMarshaller<T extends ProtocolMessage<T>>
    extends VariableSizeMarshaller<T> {
        final T template;
        private static final long serialVersionUID = 233811181L;

        AbstractProtocolMessageMarshaller(T template) {
            this.template = template;
        }

        @Override
        public void marshal(T message, ByteBuffer sink) {
            ((ProtocolMessage)message).outputTo(sink);
        }

        @Override
        public int maxEncodingSize(T message) {
            return ((ProtocolMessage)message).maxEncodingSize();
        }
    }

    public static abstract class DelegatingMarshaller<T>
    extends CoreMarshallers.DelegatingMarshaller<T> {
        protected DelegatingMarshaller(Marshaller<T> delegate) {
            super(delegate);
        }
    }

    public static abstract class VariableSizeMarshaller<T>
    extends CoreMarshallers.VariableSizeMarshaller<T> {
    }

    public static abstract class VariableSizeLocalMarshaller<T>
    extends CoreMarshallers.VariableSizeLocalMarshaller<T> {
    }

    public static abstract class ConstantSizeMarshaller<T>
    extends CoreMarshallers.ConstantSizeMarshaller<T> {
    }

    public static abstract class ConstantSizeLocalMarshaller<T>
    extends CoreMarshallers.ConstantSizeLocalMarshaller<T> {
    }
}

