/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base.shell;

public final class TerminationStatus {
    private final int waitResult;
    private static final String[] SIGNAL_STRINGS = new String[]{null, "Hangup", "Interrupt", "Quit", "Illegal instruction", "Trace/breakpoint trap", "Aborted", "Bus error", "Floating point exception", "Killed", "User defined signal 1", "Segmentation fault", "User defined signal 2", "Broken pipe", "Alarm clock", "Terminated", "Stack fault", "Child exited", "Continued", "Stopped (signal)", "Stopped", "Stopped (tty input)", "Stopped (tty output)", "Urgent I/O condition", "CPU time limit exceeded", "File size limit exceeded", "Virtual timer expired", "Profiling timer expired", "Window changed", "I/O possible", "Power failure", "Bad system call"};
    private static final int SIGNAL_1 = 129;
    private static final int SIGNAL_63 = 191;

    private static String getSignalString(int signum) {
        return signum > 0 && signum < SIGNAL_STRINGS.length ? SIGNAL_STRINGS[signum] : new StringBuilder(18).append("Signal ").append(signum).toString();
    }

    public TerminationStatus(int waitResult) {
        this.waitResult = waitResult;
    }

    int getRawResult() {
        return this.waitResult;
    }

    public boolean success() {
        return this.exited() && this.getExitCode() == 0;
    }

    public boolean exited() {
        return this.waitResult < 129 || this.waitResult > 191;
    }

    public int getExitCode() {
        if (!this.exited()) {
            throw new IllegalStateException("getExitCode() not defined");
        }
        return this.waitResult;
    }

    public int getTerminatingSignal() {
        if (this.exited()) {
            throw new IllegalStateException("getTerminatingSignal() not defined");
        }
        return this.waitResult - 129 + 1;
    }

    public String toShortString() {
        String string;
        if (this.exited()) {
            int n = this.getExitCode();
            string = new StringBuilder(16).append("Exit ").append(n).toString();
        } else {
            string = TerminationStatus.getSignalString(this.getTerminatingSignal());
        }
        return string;
    }

    public String toString() {
        String string;
        if (this.exited()) {
            int n = this.getExitCode();
            string = new StringBuilder(38).append("Process exited with status ").append(n).toString();
        } else {
            int n = this.getTerminatingSignal();
            string = new StringBuilder(40).append("Process terminated by signal ").append(n).toString();
        }
        return string;
    }

    public int hashCode() {
        return this.waitResult;
    }

    public boolean equals(Object other) {
        return other instanceof TerminationStatus && ((TerminationStatus)other).waitResult == this.waitResult;
    }
}

