/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.AbstractMutableMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.AbstractParser;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.FieldSet;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MapEntryLite;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.io.IOException;

public class MutableMapEntryLite<K, V>
extends AbstractMutableMessageLite {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private K key;
    private V value;

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public MutableMapEntryLite<K, V> setKey(K key) {
        this.key = key;
        return this;
    }

    public MutableMapEntryLite<K, V> setValue(V value) {
        this.value = value;
        return this;
    }

    public MutableMapEntryLite<K, V> clearKey() {
        this.key = this.metadata.defaultInstance.key;
        return this;
    }

    public MutableMapEntryLite<K, V> clearValue() {
        this.value = this.metadata.defaultInstance.value;
        return this;
    }

    private MutableMapEntryLite(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        this.metadata = new Metadata(this, keyType, valueType);
        this.key = defaultKey;
        this.value = defaultValue;
    }

    private MutableMapEntryLite(Metadata<K, V> metadata) {
        this.metadata = metadata;
        this.key = metadata.defaultInstance.key;
        this.value = metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE ? ((MutableMessageLite)metadata.defaultInstance.value).newMessageForType() : metadata.defaultInstance.value;
    }

    public static <K, V> MutableMapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        return new MutableMapEntryLite<K, V>(keyType, defaultKey, valueType, defaultValue);
    }

    @Override
    public MutableMapEntryLite<K, V> getDefaultInstanceForType() {
        return this.metadata.defaultInstance;
    }

    @Override
    public MutableMapEntryLite<K, V> newMessageForType() {
        return new MutableMapEntryLite<K, V>(this.metadata);
    }

    @Override
    public MapEntryLite<K, V> immutableCopy() {
        throw new UnsupportedOperationException("immutableCopy is not supported for map entry messages.");
    }

    private void writeField(int number, WireFormat.FieldType type, Object value, CodedOutputStream output) throws IOException {
        output.writeTag(number, type.getWireType());
        FieldSet.writeElementNoTag(output, type, value);
    }

    @Override
    public void writeToWithCachedSizes(CodedOutputStream output) throws IOException {
        this.writeField(1, this.metadata.keyType, this.key, output);
        if (this.metadata.valueType == WireFormat.FieldType.MESSAGE) {
            output.writeTag(2, this.metadata.valueType.getWireType());
            output.writeMessageNoTagWithCachedSizes((MutableMessageLite)this.value);
        } else {
            this.writeField(2, this.metadata.valueType, this.value, output);
        }
    }

    @Override
    public MutableMapEntryLite<K, V> clear() {
        this.key = this.metadata.defaultInstance.key;
        this.value = this.metadata.defaultInstance.value;
        return this;
    }

    @Override
    public boolean mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
        try {
            int tag;
            while ((tag = input.readTag()) != 0) {
                if (tag == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                    this.key = this.mergeField(input, extensionRegistry, this.metadata.keyType, this.key);
                    continue;
                }
                if (tag == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                    this.value = this.mergeField(input, extensionRegistry, this.metadata.valueType, this.value);
                    continue;
                }
                if (input.skipField(tag)) continue;
                break;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private <T> T mergeField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        switch (type) {
            case MESSAGE: {
                MutableMessageLite message = (MutableMessageLite)value;
                input.readMessage(message, extensionRegistry);
                return (T)message;
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveFieldForMutable(input, type, true);
    }

    private int getFieldSize(int number, WireFormat.FieldType type, Object value) {
        return CodedOutputStream.computeTagSize(number) + FieldSet.computeElementSizeNoTag(type, value);
    }

    @Override
    public int getSerializedSize() {
        int size = 0;
        size += this.getFieldSize(1, this.metadata.keyType, this.key);
        this.cachedSize = size += this.getFieldSize(2, this.metadata.valueType, this.value);
        return size;
    }

    public Parser<MutableMapEntryLite<K, V>> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public boolean isInitialized() {
        if (this.metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE) {
            return ((MutableMessageLite)this.value).isInitialized();
        }
        return true;
    }

    private static class Metadata<K, V> {
        public final MutableMapEntryLite<K, V> defaultInstance;
        public final WireFormat.FieldType keyType;
        public final WireFormat.FieldType valueType;
        public final Parser<MutableMapEntryLite<K, V>> parser;

        public Metadata(final MutableMapEntryLite<K, V> defaultInstance, WireFormat.FieldType keyType, WireFormat.FieldType valueType) {
            this.defaultInstance = defaultInstance;
            this.keyType = keyType;
            this.valueType = valueType;
            this.parser = new AbstractParser<MutableMapEntryLite<K, V>>(){

                @Override
                public MutableMapEntryLite<K, V> parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    MutableMessageLite result = defaultInstance.newMessageForType();
                    if (!((AbstractMutableMessageLite)result).mergePartialFrom(input, extensionRegistry)) {
                        throw InvalidProtocolBufferException.parseFailure().setUnfinishedMessage(result);
                    }
                    return result;
                }
            };
        }
    }
}

