/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.contrib.MessageComparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MessageSorter {
    private static final Comparator<? extends Comparable<?>> NATURAL_COMPARATOR = Ordering.natural();
    private static final ImmutableMap<Descriptors.FieldDescriptor.JavaType, SortType> SORT_TYPE_MAP;
    private final ImmutableMap<Descriptors.FieldDescriptor, Comparator<?>> sorters;
    private final ImmutableSet<Descriptors.FieldDescriptor> fieldsToSkip;
    private final boolean sortAllComparables;
    private final boolean sortAllEnumsByNumber;
    private final boolean sortAllEnumsByName;
    private final boolean strictSorting;

    public static Builder newBuilder() {
        return new Builder();
    }

    private MessageSorter(Builder builder) {
        this.sortAllComparables = builder.sortAllComparables;
        this.sortAllEnumsByNumber = builder.sortAllEnumsByNumber;
        this.sortAllEnumsByName = builder.sortAllEnumsByName;
        this.strictSorting = builder.strictSorting;
        this.sorters = ImmutableMap.copyOf(builder.sorters);
        this.fieldsToSkip = ImmutableSet.copyOf(builder.fieldsToSkip);
    }

    public <T extends Message> T sort(T message) {
        Message.Builder builder = message.toBuilder();
        this.sort(builder);
        Message result = builder.build();
        return (T)result;
    }

    public void sort(Message.Builder builder) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : builder.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            SortType sortType = MessageSorter.getSortType(fieldDescriptor);
            Object value = entry.getValue();
            if (this.fieldsToSkip.contains(fieldDescriptor)) continue;
            if (!fieldDescriptor.isRepeated()) {
                if (sortType != SortType.MESSAGE) continue;
                builder.setField(fieldDescriptor, this.sort((Message)value));
                continue;
            }
            Comparator<?> comparator = this.getComparator(fieldDescriptor);
            if (comparator == null) {
                if (this.strictSorting) {
                    String string = String.valueOf(fieldDescriptor.getFullName());
                    throw new IllegalArgumentException(string.length() != 0 ? "No comparator found for ".concat(string) : new String("No comparator found for "));
                }
                if (sortType != SortType.MESSAGE) continue;
            }
            ArrayList items = Lists.newArrayList((List)value);
            if (comparator != null) {
                Collections.sort(items, comparator);
            }
            builder.clearField(fieldDescriptor);
            for (Object item : items) {
                if (sortType == SortType.MESSAGE) {
                    item = this.sort((Message)item);
                }
                builder.addRepeatedField(fieldDescriptor, item);
            }
        }
    }

    private static SortType getSortType(Descriptors.FieldDescriptor fieldDescriptor) {
        SortType sortType = SORT_TYPE_MAP.get((Object)fieldDescriptor.getJavaType());
        return sortType != null ? sortType : SortType.UNKNOWN;
    }

    private Comparator<?> getComparator(Descriptors.FieldDescriptor fieldDescriptor) {
        Comparator<?> comparator = this.sorters.get(fieldDescriptor);
        if (comparator != null) {
            return comparator;
        }
        SortType sortType = MessageSorter.getSortType(fieldDescriptor);
        if (this.sortAllComparables && sortType == SortType.COMPARABLE) {
            return NATURAL_COMPARATOR;
        }
        if (sortType == SortType.ENUM) {
            if (this.sortAllEnumsByName) {
                return MessageComparators.ENUM_NAME_COMPARATOR;
            }
            if (this.sortAllEnumsByNumber) {
                return MessageComparators.ENUM_NUMBER_COMPARATOR;
            }
        }
        return null;
    }

    static {
        ImmutableMap.Builder<Descriptors.FieldDescriptor.JavaType, SortType> builder = ImmutableMap.builder();
        builder.put(Descriptors.FieldDescriptor.JavaType.DOUBLE, SortType.COMPARABLE);
        builder.put(Descriptors.FieldDescriptor.JavaType.FLOAT, SortType.COMPARABLE);
        builder.put(Descriptors.FieldDescriptor.JavaType.INT, SortType.COMPARABLE);
        builder.put(Descriptors.FieldDescriptor.JavaType.LONG, SortType.COMPARABLE);
        builder.put(Descriptors.FieldDescriptor.JavaType.STRING, SortType.COMPARABLE);
        builder.put(Descriptors.FieldDescriptor.JavaType.ENUM, SortType.ENUM);
        builder.put(Descriptors.FieldDescriptor.JavaType.MESSAGE, SortType.MESSAGE);
        SORT_TYPE_MAP = builder.build();
    }

    private static enum SortType {
        UNKNOWN,
        COMPARABLE,
        ENUM,
        MESSAGE;

    }

    public static final class Builder {
        private static final Joiner COMMA_JOINER = Joiner.on(", ");
        private final Map<Descriptors.FieldDescriptor, Comparator<?>> sorters = Maps.newHashMap();
        private final Set<Descriptors.FieldDescriptor> fieldsToSkip = Sets.newHashSet();
        private boolean sortAllComparables = false;
        private boolean sortAllEnumsByNumber = false;
        private boolean sortAllEnumsByName = false;
        private boolean strictSorting = false;

        private static void validateType(Descriptors.FieldDescriptor fieldDescriptor, final SortType expectedType) {
            if (MessageSorter.getSortType(fieldDescriptor) != expectedType) {
                Map filteredTypes = Maps.filterValues(SORT_TYPE_MAP, new Predicate<SortType>(){

                    @Override
                    public boolean apply(SortType sortType) {
                        return sortType == expectedType;
                    }
                });
                Preconditions.checkArgument(!filteredTypes.isEmpty(), "Missing map from %s to %s.", new Object[]{fieldDescriptor.getJavaType(), expectedType});
                throw new IllegalArgumentException(String.format("Received type %s. Expected type(s) %s.", new Object[]{fieldDescriptor.getJavaType(), COMMA_JOINER.join(filteredTypes.keySet())}));
            }
        }

        public MessageSorter build() {
            return new MessageSorter(this);
        }

        public Builder strictSorting() {
            this.strictSorting = true;
            return this;
        }

        public Builder sortMessage(Descriptors.Descriptor descriptor, int fieldNumber, int keyNumber) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(fieldNumber);
            Builder.validateType(fieldDescriptor, SortType.MESSAGE);
            Comparator fieldComparator = MessageComparators.newMessageComparator(fieldDescriptor.getMessageType(), keyNumber);
            return this.sort(fieldDescriptor, fieldComparator);
        }

        public Builder sortComparable(Descriptors.Descriptor descriptor, int fieldNumber) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(fieldNumber);
            Builder.validateType(fieldDescriptor, SortType.COMPARABLE);
            return this.sort(fieldDescriptor, NATURAL_COMPARATOR);
        }

        public Builder sortAllComparables() {
            this.sortAllComparables = true;
            return this;
        }

        public Builder sortEnumByName(Descriptors.Descriptor descriptor, int fieldNumber) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(fieldNumber);
            Builder.validateType(fieldDescriptor, SortType.ENUM);
            return this.sort(fieldDescriptor, MessageComparators.ENUM_NAME_COMPARATOR);
        }

        public Builder sortEnumByNumber(Descriptors.Descriptor descriptor, int fieldNumber) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(fieldNumber);
            Builder.validateType(fieldDescriptor, SortType.ENUM);
            return this.sort(fieldDescriptor, MessageComparators.ENUM_NUMBER_COMPARATOR);
        }

        public Builder sortAllEnumsByNumber() {
            this.sortAllEnumsByNumber = true;
            return this;
        }

        public Builder sortAllEnumsByName() {
            this.sortAllEnumsByName = true;
            return this;
        }

        public Builder sort(Descriptors.FieldDescriptor fieldDescriptor, Comparator<?> fieldComparator) {
            Preconditions.checkArgument(fieldDescriptor.isRepeated(), "Field %s is not a repeated field.", fieldDescriptor.getName());
            this.sorters.put(fieldDescriptor, fieldComparator);
            return this;
        }

        public Builder skip(Descriptors.Descriptor descriptor, int fieldNumber) {
            return this.skip(descriptor.findFieldByNumber(fieldNumber));
        }

        public Builder skip(Descriptors.FieldDescriptor fieldDescriptor) {
            this.fieldsToSkip.add(fieldDescriptor);
            return this;
        }
    }
}

