/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.appengine.tools.development.ServicesFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.google.appengine.tools.development.ServiceProvider"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedOptions(value={"debug", "verify"})
public class ServiceProviderProcessor
extends AbstractProcessor {
    private static final String SERVICE_DIR;
    private Multimap<String, String> providers = HashMultimap.create();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ServiceProvider.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            TypeElement providerImplementer = (TypeElement)element;
            AnnotationMirror providerAnnotation = this.getAnnotationMirror(element, ServiceProvider.class);
            DeclaredType providerInterface = this.getProviderInterface(providerAnnotation);
            TypeElement providerType = (TypeElement)providerInterface.asElement();
            String string = String.valueOf(providerType.getQualifiedName());
            this.log(new StringBuilder(20 + String.valueOf(string).length()).append("provider interface: ").append(string).toString());
            string = String.valueOf(providerImplementer.getQualifiedName());
            this.log(new StringBuilder(22 + String.valueOf(string).length()).append("provider implementer: ").append(string).toString());
            try {
                this.verifyImplementer(providerImplementer, providerType);
            }
            catch (VerifyException ex) {
                this.error(ex.getMessage(), element, providerAnnotation);
            }
            String providerTypeName = this.getBinaryName(providerType);
            String providerImplementerName = this.getBinaryName(providerImplementer);
            String string2 = String.valueOf(providerTypeName);
            this.log(string2.length() != 0 ? "provider interface binary name: ".concat(string2) : new String("provider interface binary name: "));
            String string3 = String.valueOf(providerImplementerName);
            this.log(string3.length() != 0 ? "provider implementer binary name: ".concat(string3) : new String("provider implementer binary name: "));
            this.providers.put(providerTypeName, providerImplementerName);
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String string = String.valueOf(SERVICE_DIR);
            String string2 = String.valueOf(providerInterface);
            String resourceFile = string2.length() != 0 ? string.concat(string2) : new String(string);
            String string3 = String.valueOf(resourceFile);
            this.log(string3.length() != 0 ? "Working on resource file: ".concat(string3) : new String("Working on resource file: "));
            try {
                Object oldServices;
                HashSet<String> allServices = new HashSet<String>();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    String string4 = String.valueOf(existingFile.toUri());
                    this.log(new StringBuilder(38 + String.valueOf(string4).length()).append("Looking for existing resource file at ").append(string4).toString());
                    oldServices = ServicesFile.readServiceFile((InputStream)existingFile.openInputStream());
                    String string5 = String.valueOf(oldServices);
                    this.log(new StringBuilder(26 + String.valueOf(string5).length()).append("Existing service entries: ").append(string5).toString());
                    allServices.addAll((Collection<String>)oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet<String> newServices = new HashSet<String>(this.providers.get(providerInterface));
                if (allServices.containsAll(newServices)) {
                    this.log("No new service entries being added.");
                    return;
                }
                allServices.addAll(newServices);
                oldServices = String.valueOf(allServices);
                this.log(new StringBuilder(27 + String.valueOf(oldServices).length()).append("New service file contents: ").append((String)oldServices).toString());
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                ServicesFile.writeServiceFile(allServices, (OutputStream)out);
                out.close();
                String string6 = String.valueOf(fileObject.toUri());
                this.log(new StringBuilder(10 + String.valueOf(string6).length()).append("Wrote to: ").append(string6).toString());
            }
            catch (IOException e) {
                String string7 = String.valueOf(e);
                this.fatalError(new StringBuilder(19 + String.valueOf(resourceFile).length() + String.valueOf(string7).length()).append("Unable to create ").append(resourceFile).append(", ").append(string7).toString());
                return;
            }
        }
    }

    private void verifyImplementer(TypeElement providerImplementer, TypeElement providerType) throws VerifyException {
        String verify = this.processingEnv.getOptions().get("verify");
        if (verify == null || !Boolean.valueOf(verify).booleanValue()) {
            return;
        }
        Types types = this.processingEnv.getTypeUtils();
        if (!types.isSubtype(providerImplementer.asType(), providerType.asType())) {
            String string = String.valueOf(providerImplementer.getQualifiedName());
            String string2 = String.valueOf(providerType.getQualifiedName());
            throw new VerifyException(new StringBuilder(86 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ServiceProviders must implement their service provider interface. ").append(string).append(" does not implement ").append(string2).toString());
        }
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = (PackageElement)enclosingElement;
            if (pkg.isUnnamed()) {
                return className;
            }
            String string = String.valueOf(pkg.getQualifiedName());
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(className).length()).append(string).append(".").append(className).toString();
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        String string = String.valueOf(typeElement.getSimpleName());
        return this.getBinaryNameImpl(typeElement, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(className).length()).append(string).append("$").append(className).toString());
    }

    private DeclaredType getProviderInterface(AnnotationMirror providerAnnotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = providerAnnotation.getElementValues();
        String string = String.valueOf(values);
        this.log(new StringBuilder(19 + String.valueOf(string).length()).append("annotation values: ").append(string).toString());
        AnnotationValue value = values.values().iterator().next();
        return (DeclaredType)value.getValue();
    }

    private AnnotationMirror getAnnotationMirror(Element e, Class<? extends Annotation> klass) {
        List<? extends AnnotationMirror> annotationMirrors = e.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String string = String.valueOf(annotationMirror);
            this.log(new StringBuilder(8 + String.valueOf(string).length()).append("mirror: ").append(string).toString());
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)type.asElement();
            if (typeElement.getQualifiedName().contentEquals(klass.getName())) {
                return annotationMirror;
            }
            String string2 = String.valueOf(klass.getName());
            this.log(new StringBuilder(14 + String.valueOf(string2).length()).append("klass name: [").append(string2).append("]").toString());
            string2 = String.valueOf(typeElement.getQualifiedName());
            this.log(new StringBuilder(13 + String.valueOf(string2).length()).append("type name: [").append(string2).append("]").toString());
        }
        return null;
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        String string = String.valueOf(msg);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string.length() != 0 ? "FATAL ERROR: ".concat(string) : new String("FATAL ERROR: "));
    }

    static {
        String string = String.valueOf(File.separator);
        String string2 = String.valueOf(File.separator);
        SERVICE_DIR = new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length()).append("META-INF").append(string).append("services").append(string2).toString();
    }

    private static class VerifyException
    extends Exception {
        VerifyException(String message) {
            super(message);
        }
    }
}

