/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ApiProxy {
    private static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    private static final ThreadLocal<Environment> environmentThreadLocal = new ThreadLocal();
    private static EnvironmentFactory environmentFactory = null;
    private static Delegate delegate;
    private static List<LogRecord> outOfBandLogs;

    private ApiProxy() {
    }

    public static byte[] makeSyncCall(String packageName, String methodName, byte[] request) throws ApiProxyException {
        return ApiProxy.makeSyncCall(packageName, methodName, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] makeSyncCall(String packageName, String methodName, byte[] request, ApiConfig apiConfig) throws ApiProxyException {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null || env == null) {
            throw new CallNotFoundException(packageName, methodName);
        }
        if (apiConfig == null || apiConfig.getDeadlineInSeconds() == null) {
            return delegate.makeSyncCall(env, packageName, methodName, request);
        }
        Object oldValue = env.getAttributes().put(API_DEADLINE_KEY, apiConfig.getDeadlineInSeconds());
        try {
            byte[] byArray = delegate.makeSyncCall(env, packageName, methodName, request);
            return byArray;
        }
        finally {
            if (oldValue == null) {
                env.getAttributes().remove(API_DEADLINE_KEY);
            } else {
                env.getAttributes().put(API_DEADLINE_KEY, oldValue);
            }
        }
    }

    public static Future<byte[]> makeAsyncCall(String packageName, String methodName, byte[] request) {
        return ApiProxy.makeAsyncCall(packageName, methodName, request, new ApiConfig());
    }

    public static Future<byte[]> makeAsyncCall(final String packageName, final String methodName, byte[] request, ApiConfig apiConfig) {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null || env == null) {
            return new Future<byte[]>(){

                @Override
                public byte[] get() {
                    throw new CallNotFoundException(packageName, methodName);
                }

                @Override
                public byte[] get(long deadline, TimeUnit unit) {
                    throw new CallNotFoundException(packageName, methodName);
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean cancel(boolean shouldInterrupt) {
                    return false;
                }
            };
        }
        return delegate.makeAsyncCall(env, packageName, methodName, request, apiConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(LogRecord record) {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate != null && env != null) {
            delegate.log(env, record);
            return;
        }
        List<LogRecord> list = outOfBandLogs;
        synchronized (list) {
            outOfBandLogs.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void possiblyFlushOutOfBandLogs() {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate != null && env != null) {
            ArrayList<LogRecord> logsToWrite;
            List<LogRecord> list = outOfBandLogs;
            synchronized (list) {
                logsToWrite = new ArrayList<LogRecord>(outOfBandLogs);
                outOfBandLogs.clear();
            }
            for (LogRecord record : logsToWrite) {
                delegate.log(env, record);
            }
        }
    }

    public static void flushLogs() {
        if (delegate != null) {
            delegate.flushLogs(ApiProxy.getCurrentEnvironment());
        }
    }

    public static Environment getCurrentEnvironment() {
        Environment threadLocalEnvironment = environmentThreadLocal.get();
        if (threadLocalEnvironment != null) {
            return threadLocalEnvironment;
        }
        EnvironmentFactory envFactory = ApiProxy.getEnvironmentFactory();
        if (envFactory != null) {
            Environment environment = envFactory.newEnvironment();
            environmentThreadLocal.set(environment);
            return environment;
        }
        return null;
    }

    public static void setDelegate(Delegate aDelegate) {
        delegate = aDelegate;
        ApiProxy.possiblyFlushOutOfBandLogs();
    }

    public static Delegate getDelegate() {
        return delegate;
    }

    public static void setEnvironmentForCurrentThread(Environment environment) {
        environmentThreadLocal.set(environment);
        ApiProxy.possiblyFlushOutOfBandLogs();
    }

    public static void clearEnvironmentForCurrentThread() {
        environmentThreadLocal.set(null);
    }

    public static synchronized EnvironmentFactory getEnvironmentFactory() {
        return environmentFactory;
    }

    public static synchronized void setEnvironmentFactory(EnvironmentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory cannot be null.");
        }
        if (environmentFactory != null) {
            throw new IllegalStateException("EnvironmentFactory has already been set.");
        }
        environmentFactory = factory;
    }

    public static List<Thread> getRequestThreads() {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null) {
            return Collections.emptyList();
        }
        return delegate.getRequestThreads(env);
    }

    static {
        outOfBandLogs = new ArrayList<LogRecord>();
    }

    public static class UnknownException
    extends ApiProxyException {
        public UnknownException(String packageName, String methodName, Throwable nestedException) {
            super("An error occurred for the API request %s.%s().", packageName, methodName, nestedException);
        }

        public UnknownException(String packageName, String methodName) {
            super("An error occurred for the API request %s.%s().", packageName, methodName);
        }

        public UnknownException(String message) {
            super(message);
        }

        @Override
        public UnknownException cloneWithoutStackTrace() {
            return new UnknownException(this.getMessage());
        }
    }

    public static class ResponseTooLargeException
    extends ApiProxyException {
        public ResponseTooLargeException(String packageName, String methodName) {
            super("The response from API call %s.%s() was too large.", packageName, methodName);
        }

        private ResponseTooLargeException(String message) {
            super(message);
        }

        @Override
        public ResponseTooLargeException cloneWithoutStackTrace() {
            return new ResponseTooLargeException(this.getMessage());
        }
    }

    public static class RequestTooLargeException
    extends ApiProxyException {
        public RequestTooLargeException(String packageName, String methodName) {
            super("The request to API call %s.%s() was too large.", packageName, methodName);
        }

        private RequestTooLargeException(String message) {
            super(message);
        }

        @Override
        public RequestTooLargeException cloneWithoutStackTrace() {
            return new RequestTooLargeException(this.getMessage());
        }
    }

    public static class OverQuotaException
    extends ApiProxyException {
        public OverQuotaException(String packageName, String methodName) {
            super("The API call %s.%s() required more quota than is available.", packageName, methodName);
        }

        private OverQuotaException(String message) {
            super(message);
        }

        @Override
        public OverQuotaException cloneWithoutStackTrace() {
            return new OverQuotaException(this.getMessage());
        }
    }

    public static class FeatureNotEnabledException
    extends ApiProxyException {
        public FeatureNotEnabledException(String message, String packageName, String methodName) {
            super(message, packageName, methodName);
        }

        public FeatureNotEnabledException(String message) {
            super(message);
        }

        @Override
        public FeatureNotEnabledException cloneWithoutStackTrace() {
            return new FeatureNotEnabledException(this.getMessage());
        }
    }

    public static class CapabilityDisabledException
    extends ApiProxyException {
        public CapabilityDisabledException(String message, String packageName, String methodName) {
            String string = String.valueOf(message);
            super(string.length() != 0 ? "The API call %s.%s() is temporarily unavailable: ".concat(string) : new String("The API call %s.%s() is temporarily unavailable: "), packageName, methodName);
        }

        private CapabilityDisabledException(String message) {
            super(message);
        }

        @Override
        public CapabilityDisabledException cloneWithoutStackTrace() {
            return new CapabilityDisabledException(this.getMessage());
        }
    }

    public static class CancelledException
    extends ApiProxyException {
        public CancelledException(String packageName, String methodName) {
            super("The API call %s.%s() was explicitly cancelled.", packageName, methodName);
        }

        private CancelledException(String message) {
            super(message);
        }

        @Override
        public CancelledException cloneWithoutStackTrace() {
            return new CancelledException(this.getMessage());
        }
    }

    public static class ApiDeadlineExceededException
    extends ApiProxyException {
        public ApiDeadlineExceededException(String packageName, String methodName) {
            super("The API call %s.%s() took too long to respond and was cancelled.", packageName, methodName);
        }

        private ApiDeadlineExceededException(String message) {
            super(message);
        }

        @Override
        public ApiDeadlineExceededException cloneWithoutStackTrace() {
            return new ApiDeadlineExceededException(this.getMessage());
        }
    }

    public static class ArgumentException
    extends ApiProxyException {
        public ArgumentException(String packageName, String methodName) {
            super("An error occurred parsing (locally or remotely) the arguments to %S.%s().", packageName, methodName);
        }

        private ArgumentException(String message) {
            super(message);
        }

        @Override
        public ArgumentException cloneWithoutStackTrace() {
            return new ArgumentException(this.getMessage());
        }
    }

    public static class CallNotFoundException
    extends ApiProxyException {
        public CallNotFoundException(String packageName, String methodName) {
            super("The API package '%s' or call '%s()' was not found.", packageName, methodName);
        }

        private CallNotFoundException(String message) {
            super(message);
        }

        @Override
        public CallNotFoundException cloneWithoutStackTrace() {
            return new CallNotFoundException(this.getMessage());
        }
    }

    public static class RPCFailedException
    extends ApiProxyException {
        public RPCFailedException(String packageName, String methodName) {
            super("The remote RPC to the application server failed for the call %s.%s().", packageName, methodName);
        }

        private RPCFailedException(String message) {
            super(message);
        }

        @Override
        protected RPCFailedException cloneWithoutStackTrace() {
            return new RPCFailedException(this.getMessage());
        }
    }

    public static class ApplicationException
    extends ApiProxyException {
        private final int applicationError;
        private final String errorDetail;

        public ApplicationException(int applicationError) {
            this(applicationError, "");
        }

        public ApplicationException(int applicationError, String errorDetail) {
            super(new StringBuilder(31 + String.valueOf(errorDetail).length()).append("ApplicationError: ").append(applicationError).append(": ").append(errorDetail).toString());
            this.applicationError = applicationError;
            this.errorDetail = errorDetail;
        }

        public int getApplicationError() {
            return this.applicationError;
        }

        public String getErrorDetail() {
            return this.errorDetail;
        }

        @Override
        protected ApplicationException cloneWithoutStackTrace() {
            return new ApplicationException(this.applicationError, this.errorDetail);
        }
    }

    public static class ApiProxyException
    extends RuntimeException {
        public ApiProxyException(String message, String packageName, String methodName) {
            this(String.format(message, packageName, methodName));
        }

        private ApiProxyException(String message, String packageName, String methodName, Throwable nestedException) {
            super(String.format(message, packageName, methodName), nestedException);
        }

        public ApiProxyException(String message) {
            super(message);
        }

        public ApiProxyException copy(StackTraceElement[] stackTrace) {
            ApiProxyException theCopy = this.cloneWithoutStackTrace();
            theCopy.setStackTrace(stackTrace);
            theCopy.initCause(this);
            return theCopy;
        }

        protected ApiProxyException cloneWithoutStackTrace() {
            return new ApiProxyException(this.getMessage());
        }
    }

    public static interface ApiResultFuture<T>
    extends Future<T> {
        public long getCpuTimeInMegaCycles();

        public long getWallclockTimeInMillis();
    }

    public static final class ApiConfig {
        private Double deadlineInSeconds;

        public Double getDeadlineInSeconds() {
            return this.deadlineInSeconds;
        }

        public void setDeadlineInSeconds(Double deadlineInSeconds) {
            this.deadlineInSeconds = deadlineInSeconds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApiConfig apiConfig = (ApiConfig)o;
            return !(this.deadlineInSeconds != null ? !this.deadlineInSeconds.equals(apiConfig.deadlineInSeconds) : apiConfig.deadlineInSeconds != null);
        }

        public int hashCode() {
            return this.deadlineInSeconds != null ? this.deadlineInSeconds.hashCode() : 0;
        }
    }

    public static final class LogRecord {
        private final Level level;
        private final long timestamp;
        private final String message;
        @Nullable
        private final Throwable sourceLocation;

        public LogRecord(Level level, long timestamp, String message) {
            this(level, timestamp, message, null);
        }

        public LogRecord(Level level, long timestamp, String message, Throwable sourceLocation) {
            this.level = level;
            this.timestamp = timestamp;
            this.message = message;
            this.sourceLocation = sourceLocation;
        }

        public LogRecord(LogRecord other, String message) {
            this(other.level, other.timestamp, message);
        }

        public Level getLevel() {
            return this.level;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        @Nullable
        public Throwable getSourceLocation() {
            return this.sourceLocation;
        }

        public static enum Level {
            debug,
            info,
            warn,
            error,
            fatal;

        }
    }

    public static interface Delegate<E extends Environment> {
        public byte[] makeSyncCall(E var1, String var2, String var3, byte[] var4) throws ApiProxyException;

        public Future<byte[]> makeAsyncCall(E var1, String var2, String var3, byte[] var4, ApiConfig var5);

        public void log(E var1, LogRecord var2);

        public void flushLogs(E var1);

        public List<Thread> getRequestThreads(E var1);
    }

    public static interface EnvironmentFactory {
        public Environment newEnvironment();
    }

    public static interface Environment {
        public String getAppId();

        public String getModuleId();

        public String getVersionId();

        public String getEmail();

        public boolean isLoggedIn();

        public boolean isAdmin();

        public String getAuthDomain();

        @Deprecated
        public String getRequestNamespace();

        public Map<String, Object> getAttributes();

        public long getRemainingMillis();
    }
}

