/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

class AppEngineWebXmlProcessor {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlProcessor.class.getName());

    AppEngineWebXmlProcessor() {
    }

    public AppEngineWebXml processXml(InputStream is) {
        XmlParser.Node config = this.getTopLevelNode(is);
        AppEngineWebXml appEngineWebXml = new AppEngineWebXml();
        appEngineWebXml.setWarmupRequestsEnabled(true);
        for (Object o : config) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node node = (XmlParser.Node)o;
            this.processSecondLevelNode(node, appEngineWebXml);
        }
        AppEngineWebXmlProcessor.checkScalingConstraints(appEngineWebXml);
        return appEngineWebXml;
    }

    private static void checkScalingConstraints(AppEngineWebXml appEngineWebXml) {
        int count = appEngineWebXml.getManualScaling().isEmpty() ? 0 : 1;
        count += appEngineWebXml.getBasicScaling().isEmpty() ? 0 : 1;
        if ((count += appEngineWebXml.getAutomaticScaling().isEmpty() ? 0 : 1) > 1) {
            throw new AppEngineConfigException("There may be only one of 'automatic-scaling', 'manual-scaling' or 'basic-scaling' elements.");
        }
    }

    XmlParser.Node getTopLevelNode(InputStream is) {
        XmlParser xmlParser = new XmlParser();
        try {
            return xmlParser.parse(is);
        }
        catch (IOException e) {
            String msg = "Received IOException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
    }

    private void processSecondLevelNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        String elementName = node.getTag();
        if (elementName.equals("system-properties")) {
            this.processSystemPropertiesNode(node, appEngineWebXml);
        } else if (elementName.equals("vm-settings") || elementName.equals("beta-settings")) {
            this.processBetaSettingsNode(node, appEngineWebXml);
        } else if (elementName.equals("vm-health-check") || elementName.equals("health-check")) {
            this.processHealthCheckNode(node, appEngineWebXml);
        } else if (elementName.equals("resources")) {
            this.processResourcesNode(node, appEngineWebXml);
        } else if (elementName.equals("network")) {
            this.processNetworkNode(node, appEngineWebXml);
        } else if (elementName.equals("env-variables")) {
            this.processEnvironmentVariablesNode(node, appEngineWebXml);
        } else if (elementName.equals("application")) {
            this.processApplicationNode(node, appEngineWebXml);
        } else if (elementName.equals("version")) {
            this.processVersionNode(node, appEngineWebXml);
        } else if (elementName.equals("source-language")) {
            this.processSourceLanguageNode(node, appEngineWebXml);
        } else if (elementName.equals("module")) {
            this.processModuleNode(node, appEngineWebXml);
        } else if (elementName.equals("instance-class")) {
            this.processInstanceClassNode(node, appEngineWebXml);
        } else if (elementName.equals("automatic-scaling")) {
            this.processAutomaticScalingNode(node, appEngineWebXml);
        } else if (elementName.equals("manual-scaling")) {
            this.processManualScalingNode(node, appEngineWebXml);
        } else if (elementName.equals("basic-scaling")) {
            this.processBasicScalingNode(node, appEngineWebXml);
        } else if (elementName.equals("static-files")) {
            this.processFilesetNode(node, appEngineWebXml, FileType.STATIC);
        } else if (elementName.equals("resource-files")) {
            this.processFilesetNode(node, appEngineWebXml, FileType.RESOURCE);
        } else if (elementName.equals("ssl-enabled")) {
            this.processSslEnabledNode(node, appEngineWebXml);
        } else if (elementName.equals("sessions-enabled")) {
            this.processSessionsEnabledNode(node, appEngineWebXml);
        } else if (elementName.equals("async-session-persistence")) {
            this.processAsyncSessionPersistenceNode(node, appEngineWebXml);
        } else if (elementName.equals("user-permissions")) {
            this.processPermissionsNode(node, appEngineWebXml);
        } else if (elementName.equals("public-root")) {
            this.processPublicRootNode(node, appEngineWebXml);
        } else if (elementName.equals("inbound-services")) {
            this.processInboundServicesNode(node, appEngineWebXml);
        } else if (elementName.equals("precompilation-enabled")) {
            this.processPrecompilationEnabledNode(node, appEngineWebXml);
        } else if (elementName.equals("admin-console")) {
            this.processAdminConsoleNode(node, appEngineWebXml);
        } else if (elementName.equals("static-error-handlers")) {
            this.processErrorHandlerNode(node, appEngineWebXml);
        } else if (elementName.equals("warmup-requests-enabled")) {
            this.processWarmupRequestsEnabledNode(node, appEngineWebXml);
        } else if (elementName.equals("threadsafe")) {
            this.processThreadsafeNode(node, appEngineWebXml);
        } else if (elementName.equals("auto-id-policy")) {
            this.processAutoIdPolicyNode(node, appEngineWebXml);
        } else if (elementName.equals("code-lock")) {
            this.processCodeLockNode(node, appEngineWebXml);
        } else if (elementName.equals("vm")) {
            this.processVmNode(node, appEngineWebXml);
        } else if (elementName.equals("api-config")) {
            this.processApiConfigNode(node, appEngineWebXml);
        } else if (elementName.equals("pagespeed")) {
            this.processPagespeedNode(node, appEngineWebXml);
        } else if (elementName.equals("class-loader-config")) {
            this.processClassLoaderConfig(node, appEngineWebXml);
        } else if (elementName.equals("url-stream-handler")) {
            this.processUrlStreamHandler(node, appEngineWebXml);
        } else if (elementName.equals("use-google-connector-j")) {
            this.processUseGoogleConnectorJNode(node, appEngineWebXml);
        } else {
            throw new AppEngineConfigException(new StringBuilder(23 + String.valueOf(elementName).length()).append("Unrecognized element <").append(elementName).append(">").toString());
        }
    }

    private void processApplicationNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAppId(this.getTextNode(node));
    }

    private void processPublicRootNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setPublicRoot(this.getTextNode(node));
    }

    private void processVersionNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setMajorVersionId(this.getTextNode(node));
    }

    private void processSourceLanguageNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSourceLanguage(this.getTextNode(node));
    }

    private void processModuleNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setModule(this.getTextNode(node));
    }

    private void processInstanceClassNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setInstanceClass(this.getTextNode(node));
    }

    private String getChildNodeText(XmlParser.Node parentNode, String childTag) {
        String result = null;
        XmlParser.Node node = parentNode.get(childTag);
        if (node != null) {
            result = (String)node.get(0);
        }
        return result;
    }

    private Integer getChildNodePositiveInteger(XmlParser.Node parentNode, String childTag) {
        String trimmedText;
        Integer result = null;
        XmlParser.Node node = parentNode.get(childTag);
        if (node != null && node.get(0) != null && !(trimmedText = ((String)node.get(0)).trim()).isEmpty()) {
            try {
                result = Integer.parseInt(trimmedText);
            }
            catch (NumberFormatException ex) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain integers."));
            }
            if (result <= 0) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain positive integers."));
            }
        }
        return result;
    }

    private Double getChildNodeDouble(XmlParser.Node parentNode, String childTag) {
        String trimmedText;
        Double result = null;
        XmlParser.Node node = parentNode.get(childTag);
        if (node != null && node.get(0) != null && !(trimmedText = ((String)node.get(0)).trim()).isEmpty()) {
            try {
                result = Double.parseDouble(trimmedText);
            }
            catch (NumberFormatException ex) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain doubles."));
            }
            catch (NullPointerException ex) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should NOT be empty."));
            }
        }
        return result;
    }

    private void processAutomaticScalingNode(XmlParser.Node settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.AutomaticScaling automaticScaling = appEngineWebXml.getAutomaticScaling();
        automaticScaling.setMinPendingLatency(this.getChildNodeText(settingsNode, "min-pending-latency"));
        automaticScaling.setMaxPendingLatency(this.getChildNodeText(settingsNode, "max-pending-latency"));
        automaticScaling.setMinIdleInstances(this.getChildNodeText(settingsNode, "min-idle-instances"));
        automaticScaling.setMaxIdleInstances(this.getChildNodeText(settingsNode, "max-idle-instances"));
        automaticScaling.setMaxConcurrentRequests(this.getChildNodeText(settingsNode, "max-concurrent-requests"));
        automaticScaling.setMinNumInstances(this.getChildNodePositiveInteger(settingsNode, "min-num-instances"));
        automaticScaling.setMaxNumInstances(this.getChildNodePositiveInteger(settingsNode, "max-num-instances"));
        automaticScaling.setCoolDownPeriodSec(this.getChildNodePositiveInteger(settingsNode, "cool-down-period-sec"));
        this.processCpuUtilizationNode(settingsNode, automaticScaling);
        automaticScaling.setTargetNetworkSentBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-sent-bytes-per-sec"));
        automaticScaling.setTargetNetworkSentPacketsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-sent-packets-per-sec"));
        automaticScaling.setTargetNetworkReceivedBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-received-bytes-per-sec"));
        automaticScaling.setTargetNetworkReceivedPacketsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-received-packets-per-sec"));
        automaticScaling.setTargetDiskWriteBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-write-bytes-per-sec"));
        automaticScaling.setTargetDiskWriteOpsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-write-ops-per-sec"));
        automaticScaling.setTargetDiskReadBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-read-bytes-per-sec"));
        automaticScaling.setTargetDiskReadOpsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-read-ops-per-sec"));
        automaticScaling.setTargetRequestCountPerSec(this.getChildNodePositiveInteger(settingsNode, "target-request-count-per-sec"));
        automaticScaling.setTargetConcurrentRequests(this.getChildNodePositiveInteger(settingsNode, "target-concurrent-requests"));
    }

    private void processCpuUtilizationNode(XmlParser.Node settingsNode, AppEngineWebXml.AutomaticScaling automaticScaling) {
        XmlParser.Node childNode = settingsNode.get("cpu-utilization");
        if (childNode != null) {
            AppEngineWebXml.CpuUtilization cpuUtilization = new AppEngineWebXml.CpuUtilization();
            Double targetUtilization = this.getChildNodeDouble(childNode, "target-utilization");
            if (targetUtilization != null) {
                if (targetUtilization <= 0.0 || targetUtilization > 1.0) {
                    throw new AppEngineConfigException("target-utilization should be in range (0, 1].");
                }
                cpuUtilization.setTargetUtilization(targetUtilization);
            }
            cpuUtilization.setAggregationWindowLengthSec(this.getChildNodePositiveInteger(childNode, "aggregation-window-length-sec"));
            if (!cpuUtilization.isEmpty()) {
                automaticScaling.setCpuUtilization(cpuUtilization);
            }
        }
    }

    private void processManualScalingNode(XmlParser.Node settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.ManualScaling manualScaling = appEngineWebXml.getManualScaling();
        manualScaling.setInstances(this.getChildNodeText(settingsNode, "instances"));
    }

    private void processBasicScalingNode(XmlParser.Node settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.BasicScaling basicScaling = appEngineWebXml.getBasicScaling();
        basicScaling.setMaxInstances(this.getChildNodeText(settingsNode, "max-instances"));
        basicScaling.setIdleTimeout(this.getChildNodeText(settingsNode, "idle-timeout"));
    }

    private void processSslEnabledNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSslEnabled(this.getBooleanValue(node));
    }

    private void processSessionsEnabledNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSessionsEnabled(this.getBooleanValue(node));
    }

    private void processAsyncSessionPersistenceNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        boolean enabled = this.getBooleanAttributeValue(node, "enabled");
        appEngineWebXml.setAsyncSessionPersistence(enabled);
        String queueName = this.trim(node.getAttribute("queue-name"));
        appEngineWebXml.setAsyncSessionPersistenceQueueName(queueName);
    }

    private void processPrecompilationEnabledNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setPrecompilationEnabled(this.getBooleanValue(node));
    }

    private void processWarmupRequestsEnabledNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setWarmupRequestsEnabled(this.getBooleanValue(node));
    }

    private void processThreadsafeNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setThreadsafe(this.getBooleanValue(node));
    }

    private void processAutoIdPolicyNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAutoIdPolicy(this.getTextNode(node));
    }

    private void processCodeLockNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setCodeLock(this.getBooleanValue(node));
    }

    private void processVmNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUseVm(this.getBooleanValue(node));
    }

    private void processFilesetNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml, FileType type) {
        String path;
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "include");
        while (nodeIter.hasNext()) {
            XmlParser.Node includeNode = nodeIter.next();
            path = this.trim(includeNode.getAttribute("path"));
            if (type == FileType.STATIC) {
                String expiration = this.trim(includeNode.getAttribute("expiration"));
                AppEngineWebXml.StaticFileInclude staticFileInclude = appEngineWebXml.includeStaticPattern(path, expiration);
                Map<String, String> httpHeaders = staticFileInclude.getHttpHeaders();
                Iterator<XmlParser.Node> httpHeaderIter = this.getNodeIterator(includeNode, "http-header");
                while (httpHeaderIter.hasNext()) {
                    XmlParser.Node httpHeaderNode = httpHeaderIter.next();
                    String name = httpHeaderNode.getAttribute("name");
                    String value = httpHeaderNode.getAttribute("value");
                    if (httpHeaders.containsKey(name)) {
                        throw new AppEngineConfigException("Two http-header elements have the same name.");
                    }
                    httpHeaders.put(name, value);
                }
                continue;
            }
            appEngineWebXml.includeResourcePattern(path);
        }
        nodeIter = this.getNodeIterator(node, "exclude");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            path = this.trim(subNode.getAttribute("path"));
            if (type == FileType.STATIC) {
                appEngineWebXml.excludeStaticPattern(path);
                continue;
            }
            appEngineWebXml.excludeResourcePattern(path);
        }
    }

    private Iterator<XmlParser.Node> getNodeIterator(XmlParser.Node node, String filter) {
        Iterator iterator = node.iterator(filter);
        return iterator;
    }

    private void processSystemPropertiesNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "property");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addSystemProperty(propertyName, propertyValue);
        }
    }

    private void processBetaSettingsNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "setting");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String name = this.trim(subNode.getAttribute("name"));
            String value = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addBetaSetting(name, value);
        }
    }

    private void processHealthCheckNode(XmlParser.Node settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.HealthCheck healthCheck = appEngineWebXml.getHealthCheck();
        String enableHealthCheck = this.trim(this.getChildNodeText(settingsNode, "enable-health-check"));
        if (enableHealthCheck != null && !enableHealthCheck.isEmpty()) {
            healthCheck.setEnableHealthCheck(this.toBoolean(enableHealthCheck));
        }
        healthCheck.setCheckIntervalSec(this.getChildNodePositiveInteger(settingsNode, "check-interval-sec"));
        healthCheck.setTimeoutSec(this.getChildNodePositiveInteger(settingsNode, "timeout-sec"));
        healthCheck.setUnhealthyThreshold(this.getChildNodePositiveInteger(settingsNode, "unhealthy-threshold"));
        healthCheck.setHealthyThreshold(this.getChildNodePositiveInteger(settingsNode, "healthy-threshold"));
        healthCheck.setRestartThreshold(this.getChildNodePositiveInteger(settingsNode, "restart-threshold"));
        healthCheck.setHost(this.getChildNodeText(settingsNode, "host"));
    }

    private void processResourcesNode(XmlParser.Node settingsNode, AppEngineWebXml appEngineWebXml) {
        Integer disk_size_gb;
        Double memory_gb;
        AppEngineWebXml.Resources resources = appEngineWebXml.getResources();
        Double cpu = this.getChildNodeDouble(settingsNode, "cpu");
        if (cpu != null) {
            resources.setCpu(cpu);
        }
        if ((memory_gb = this.getChildNodeDouble(settingsNode, "memory-gb")) != null) {
            resources.setMemoryGb(memory_gb);
        }
        if ((disk_size_gb = this.getChildNodePositiveInteger(settingsNode, "disk-size-gb")) != null) {
            resources.setDiskSizeGb(disk_size_gb);
        }
    }

    private void processNetworkNode(XmlParser.Node settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.Network network = appEngineWebXml.getNetwork();
        String instance_tag = this.trim(this.getChildNodeText(settingsNode, "instance-tag"));
        if (instance_tag != null && !instance_tag.isEmpty()) {
            network.setInstanceTag(instance_tag);
        }
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(settingsNode, "forwarded-port");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String forwardedPort = this.getTextNode(subNode);
            network.addForwardedPort(forwardedPort);
        }
        String name = this.trim(this.getChildNodeText(settingsNode, "name"));
        if (name != null && !name.isEmpty()) {
            network.setName(name);
        }
    }

    private void processEnvironmentVariablesNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "env-var");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addEnvironmentVariable(propertyName, propertyValue);
        }
    }

    private void processPermissionsNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "permission");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String className = this.trim(subNode.getAttribute("class"));
            String name = this.trim(subNode.getAttribute("name"));
            String actions = this.trim(subNode.getAttribute("actions"));
            appEngineWebXml.addUserPermission(className, name, actions);
        }
    }

    private void processInboundServicesNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "service");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String service = this.getTextNode(subNode);
            appEngineWebXml.addInboundService(service);
        }
    }

    private void processAdminConsoleNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "page");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String name = this.trim(subNode.getAttribute("name"));
            String url = this.trim(subNode.getAttribute("url"));
            appEngineWebXml.addAdminConsolePage(new AppEngineWebXml.AdminConsolePage(name, url));
        }
    }

    private void processErrorHandlerNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "handler");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = nodeIter.next();
            String file = this.trim(subNode.getAttribute("file"));
            String errorCode = this.trim(subNode.getAttribute("error-code"));
            appEngineWebXml.addErrorHandler(new AppEngineWebXml.ErrorHandler(file, errorCode));
        }
    }

    private void processApiConfigNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        String servlet = this.trim(node.getAttribute("servlet-class"));
        String url = this.trim(node.getAttribute("url-pattern"));
        appEngineWebXml.setApiConfig(new AppEngineWebXml.ApiConfig(servlet, url));
        String id = null;
        Iterator<XmlParser.Node> subNodeIter = this.getNodeIterator(node, "endpoint-servlet-mapping-id");
        while (subNodeIter.hasNext()) {
            XmlParser.Node subNode = subNodeIter.next();
            id = this.trim(this.getTextNode(subNode));
            if (id == null || id.length() <= 0) continue;
            appEngineWebXml.addApiEndpoint(id);
        }
    }

    private void processPagespeedNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        String rewriter;
        XmlParser.Node subNode;
        AppEngineWebXml.Pagespeed pagespeed = new AppEngineWebXml.Pagespeed();
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "url-blacklist");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            String urlMatcher = this.getTextNode(subNode);
            pagespeed.addUrlBlacklist(urlMatcher);
        }
        nodeIter = this.getNodeIterator(node, "domain-to-rewrite");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            String domain = this.getTextNode(subNode);
            pagespeed.addDomainToRewrite(domain);
        }
        nodeIter = this.getNodeIterator(node, "enabled-rewriter");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            rewriter = this.getTextNode(subNode);
            pagespeed.addEnabledRewriter(rewriter);
        }
        nodeIter = this.getNodeIterator(node, "disabled-rewriter");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            rewriter = this.getTextNode(subNode);
            pagespeed.addDisabledRewriter(rewriter);
        }
        appEngineWebXml.setPagespeed(pagespeed);
    }

    private void processClassLoaderConfig(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.ClassLoaderConfig config = new AppEngineWebXml.ClassLoaderConfig();
        appEngineWebXml.setClassLoaderConfig(config);
        Iterator<XmlParser.Node> nodeIter = this.getNodeIterator(node, "priority-specifier");
        while (nodeIter.hasNext()) {
            this.processClassPathPrioritySpecifier(nodeIter.next(), config);
        }
    }

    private void processClassPathPrioritySpecifier(XmlParser.Node node, AppEngineWebXml.ClassLoaderConfig config) {
        AppEngineWebXml.PrioritySpecifierEntry entry = new AppEngineWebXml.PrioritySpecifierEntry();
        entry.setFilename(node.getAttribute("filename"));
        entry.setPriority(node.getAttribute("priority"));
        entry.checkClassLoaderConfig();
        config.add(entry);
    }

    private void processUrlStreamHandler(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUrlStreamHandlerType(this.getTextNode(node));
    }

    private boolean getBooleanValue(XmlParser.Node node) {
        return this.toBoolean(this.getTextNode(node));
    }

    private boolean getBooleanAttributeValue(XmlParser.Node node, String attribute) {
        return this.toBoolean(node.getAttribute(attribute));
    }

    private boolean toBoolean(String value) {
        return (value = value.trim()).equalsIgnoreCase("true") || value.equals("1");
    }

    private String getTextNode(XmlParser.Node node) {
        String value = (String)node.get(0);
        if (value == null) {
            value = "";
        }
        return value.trim();
    }

    private String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }

    private void processUseGoogleConnectorJNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUseGoogleConnectorJ(this.getBooleanValue(node));
    }

    static enum FileType {
        STATIC,
        RESOURCE;

    }
}

