/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.BackendsXml;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Iterator;
import org.mortbay.xml.XmlParser;

public class BackendsXmlReader
extends AbstractConfigXmlReader<BackendsXml> {
    private static final String FILENAME = "WEB-INF/backends.xml";

    public BackendsXmlReader(String appDir) {
        super(appDir, false);
    }

    public BackendsXml readBackendsXml() {
        return (BackendsXml)this.readConfigXml();
    }

    @Override
    protected BackendsXml processXml(InputStream is) {
        BackendsXml backendsXml = new BackendsXml();
        XmlParser.Node rootNode = this.getTopLevelNode(is);
        Iterator backends = rootNode.iterator("backend");
        while (backends.hasNext()) {
            XmlParser.Node node = (XmlParser.Node)backends.next();
            backendsXml.addBackend(this.convertBackendNode(node));
        }
        return backendsXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    private BackendsXml.Entry convertBackendNode(XmlParser.Node node) {
        String name = this.trim(node.getAttribute("name"));
        Integer instances = null;
        String instanceClass = node.getString("class", false, true);
        Integer maxConcurrentRequests = null;
        EnumSet<BackendsXml.Option> options = EnumSet.noneOf(BackendsXml.Option.class);
        XmlParser.Node subNode = node.get("instances");
        if (subNode != null) {
            instances = Integer.valueOf(this.getTextNode(subNode));
        }
        if ((subNode = node.get("max-concurrent-requests")) != null) {
            maxConcurrentRequests = Integer.valueOf(this.getTextNode(subNode));
        }
        if ((subNode = node.get("options")) != null) {
            XmlParser.Node publicNode;
            XmlParser.Node dynamicNode;
            XmlParser.Node failFastNode = subNode.get("fail-fast");
            if (failFastNode != null && this.getBooleanValue(failFastNode)) {
                options.add(BackendsXml.Option.FAIL_FAST);
            }
            if ((dynamicNode = subNode.get("dynamic")) != null && this.getBooleanValue(dynamicNode)) {
                options.add(BackendsXml.Option.DYNAMIC);
            }
            if ((publicNode = subNode.get("public")) != null && this.getBooleanValue(publicNode)) {
                options.add(BackendsXml.Option.PUBLIC);
            }
        }
        return new BackendsXml.Entry(name, instances, instanceClass, maxConcurrentRequests, options, null);
    }

    private boolean getBooleanValue(XmlParser.Node node) {
        String value = this.getTextNode(node);
        return (value = value.trim()).equalsIgnoreCase("true") || value.equals("1");
    }

    private String getTextNode(XmlParser.Node node) {
        String value = (String)node.get(0);
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }
}

