/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DispatchXml;
import java.io.File;
import java.io.InputStream;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

public class DispatchXmlReader
extends AbstractConfigXmlReader<DispatchXml> {
    public static final String DEFAULT_RELATIVE_FILENAME;
    private final String relativeFilename;

    public DispatchXmlReader(String warDirectory, String relativeFilename) {
        super(warDirectory, false);
        this.relativeFilename = relativeFilename;
    }

    public DispatchXml readDispatchXml() {
        return (DispatchXml)this.readConfigXml();
    }

    @Override
    protected DispatchXml processXml(InputStream is) {
        DispatchXmlParserCallback dispatchParserCallback = new DispatchXmlParserCallback();
        this.parse(dispatchParserCallback, is);
        return dispatchParserCallback.getDispatchXml();
    }

    @Override
    protected String getRelativeFilename() {
        return this.relativeFilename;
    }

    static {
        char c = File.separatorChar;
        DEFAULT_RELATIVE_FILENAME = new StringBuilder(20).append("WEB-INF").append(c).append("dispatch.xml").toString();
    }

    private class DispatchXmlParserCallback
    implements AbstractConfigXmlReader.ParserCallback {
        private final DispatchXml.Builder dispatchXmlBuilder = DispatchXml.builder();
        private static final String DISPATCH_ENTRIES_TAG = "dispatch-entries";
        private static final String DISPATCH_TAG = "dispatch";
        private static final String URL_TAG = "url";
        private static final String MODULE_TAG = "module";
        private boolean first = true;
        private boolean dispatchComplete;
        private String url = null;
        private String module = null;

        private DispatchXmlParserCallback() {
        }

        DispatchXml getDispatchXml() {
            if (this.first) {
                throw new IllegalStateException("getDispatchXml() called before parsing a valid dispatch.xml");
            }
            this.checkForIncompleteDispatchElement();
            return this.dispatchXmlBuilder.build();
        }

        @Override
        public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
            switch (ancestors.size()) {
                case 0: {
                    if (!DISPATCH_ENTRIES_TAG.equalsIgnoreCase(node.getTag())) {
                        this.throwExpectingTag(DISPATCH_ENTRIES_TAG, node.getTag());
                    }
                    if (!this.first) {
                        this.throwDuplicateTag(DISPATCH_ENTRIES_TAG, null);
                    }
                    this.first = false;
                    break;
                }
                case 1: {
                    if (DISPATCH_TAG.equalsIgnoreCase(node.getTag())) {
                        this.checkForIncompleteDispatchElement();
                        this.dispatchComplete = false;
                        break;
                    }
                    this.throwExpectingTag(DISPATCH_TAG, node.getTag());
                    break;
                }
                case 2: {
                    if (URL_TAG.equalsIgnoreCase(node.getTag())) {
                        if (this.dispatchComplete || this.url != null) {
                            this.throwDuplicateTag(URL_TAG, DISPATCH_TAG);
                        } else if (node.size() == 1 && node.get(0) instanceof String) {
                            this.url = (String)node.get(0);
                        } else {
                            this.throwBadElementContents(URL_TAG);
                        }
                    } else if (MODULE_TAG.equalsIgnoreCase(node.getTag())) {
                        if (this.dispatchComplete || this.module != null) {
                            this.throwDuplicateTag(MODULE_TAG, DISPATCH_TAG);
                        } else if (node.size() == 1 && node.get(0) instanceof String) {
                            this.module = (String)node.get(0);
                        } else {
                            this.throwBadElementContents(MODULE_TAG);
                        }
                    } else {
                        this.throwUnsupportedTag(node.getTag(), DISPATCH_TAG);
                    }
                    if (this.url == null || this.module == null) break;
                    this.dispatchXmlBuilder.addDispatchEntry(new DispatchXml.DispatchEntry(this.url, this.module));
                    this.url = null;
                    this.module = null;
                    this.dispatchComplete = true;
                    break;
                }
                default: {
                    throw new AppEngineConfigException(String.format("Syntax error; node <%s> is too deeply nested in file %s", node.getTag(), DispatchXmlReader.this.getFilename()));
                }
            }
        }

        private void checkForIncompleteDispatchElement() {
            if (this.module != null) {
                this.throwExpectingTag(URL_TAG, "/dispatch");
            }
            if (this.url != null) {
                this.throwExpectingTag(MODULE_TAG, "/dispatch");
            }
        }

        private void throwExpectingTag(String expecting, String got) {
            throw new AppEngineConfigException(String.format("Expecting <%s> but got <%s> in file %s", expecting, got, DispatchXmlReader.this.getFilename()));
        }

        private void throwUnsupportedTag(String tag, String parent) {
            throw new AppEngineConfigException(String.format("Tag <%s> not supported in element <%s> in file %s", tag, parent, DispatchXmlReader.this.getFilename()));
        }

        private void throwDuplicateTag(String duplicateTag, String parentTag) {
            if (parentTag == null) {
                throw new AppEngineConfigException(String.format("Duplicate <%s> in file %s", duplicateTag, DispatchXmlReader.this.getFilename()));
            }
            throw new AppEngineConfigException(String.format("Duplicate <%s> inside <%s> in file %s", duplicateTag, parentTag, DispatchXmlReader.this.getFilename()));
        }

        private void throwBadElementContents(String badTag) {
            throw new AppEngineConfigException(String.format("Invalid contents in element <%s> in file %s", badTag, DispatchXmlReader.this.getFilename()));
        }
    }
}

