/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DosXml;
import java.io.InputStream;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

public class DosXmlReader
extends AbstractConfigXmlReader<DosXml> {
    private static final String FILENAME = "WEB-INF/dos.xml";
    private static final String BLACKLISTENTRIES_TAG = "blacklistentries";
    private static final String BLACKLIST_TAG = "blacklist";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SUBNET_TAG = "subnet";

    public DosXmlReader(String appDir) {
        super(appDir, false);
    }

    public DosXml readDosXml() {
        return (DosXml)this.readConfigXml();
    }

    @Override
    protected DosXml processXml(InputStream is) {
        final DosXml dosXml = new DosXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean first = true;
            DosXml.BlacklistEntry blacklistEntry;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!DosXmlReader.BLACKLISTENTRIES_TAG.equalsIgnoreCase(node.getTag())) {
                            String string = DosXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string).length()).append(string).append(" does not contain <").append(DosXmlReader.BLACKLISTENTRIES_TAG).append(">").toString());
                        }
                        if (!this.first) {
                            String string = DosXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(37 + String.valueOf(string).length()).append(string).append(" contains multiple <").append(DosXmlReader.BLACKLISTENTRIES_TAG).append(">").toString());
                        }
                        this.first = false;
                        break;
                    }
                    case 1: {
                        if (DosXmlReader.BLACKLIST_TAG.equalsIgnoreCase(node.getTag())) {
                            this.blacklistEntry = dosXml.addNewBlacklistEntry();
                            break;
                        }
                        String string = DosXmlReader.this.getFilename();
                        String string2 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains <").append(string2).append("> instead of <").append(DosXmlReader.BLACKLIST_TAG).append("/>").toString());
                    }
                    case 2: {
                        assert (this.blacklistEntry != null);
                        if (DosXmlReader.DESCRIPTION_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.blacklistEntry.setDescription((String)node.get(0));
                                break;
                            }
                            String string = DosXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(34 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(DosXmlReader.DESCRIPTION_TAG).append(">").toString());
                        }
                        if (DosXmlReader.SUBNET_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.blacklistEntry.setSubnet((String)node.get(0));
                                break;
                            }
                            String string = DosXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(DosXmlReader.SUBNET_TAG).append(">").toString());
                        }
                        String string = DosXmlReader.this.getFilename();
                        String string3 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" contains unknown <").append(string3).append("> inside <").append(DosXmlReader.BLACKLIST_TAG).append("/>").toString());
                    }
                    default: {
                        String string = DosXmlReader.this.getFilename();
                        String string4 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append(" has a syntax error; node <").append(string4).append("> is too deeply nested to be valid.").toString());
                    }
                }
            }
        }, is);
        dosXml.validateLastEntry();
        return dosXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

