/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.utils.config.AppEngineApplicationXml;
import com.google.apphosting.utils.config.AppEngineApplicationXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYamlProcessor;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.ApplicationXmlReader;
import com.google.apphosting.utils.config.EarInfo;
import com.google.apphosting.utils.config.WebModule;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class EarHelper {
    private static final Logger LOGGER = Logger.getLogger(EarHelper.class.getName());
    private static final AppEngineApplicationXmlReader APP_ENGINE_APPLICATION_XML_READER = new AppEngineApplicationXmlReader();
    private static final ApplicationXmlReader APPLICATION_XML_READER = new ApplicationXmlReader();
    private static final String META_INF = "META-INF";
    private static final String APPENGINE_APPLICATION_XML_NAME = "appengine-application.xml";
    private static final String APPLICATION_XML_NAME = "application.xml";

    public static boolean isEar(String dir) {
        return EarHelper.isEar(dir, true);
    }

    public static boolean isEar(String directory, boolean logWhyNot) {
        if (directory == null) {
            if (logWhyNot) {
                LOGGER.fine("Directory 'null' is not an EAR directory. ");
            }
            return false;
        }
        File metaInf = new File(directory, META_INF);
        if (!EarHelper.hasFile(metaInf, APPENGINE_APPLICATION_XML_NAME)) {
            EarHelper.logNotAnEar(directory.toString(), APPENGINE_APPLICATION_XML_NAME, logWhyNot);
            return false;
        }
        if (!EarHelper.hasFile(metaInf, APPLICATION_XML_NAME)) {
            EarHelper.logNotAnEar(directory.toString(), APPLICATION_XML_NAME, logWhyNot);
            return false;
        }
        return true;
    }

    private static void logNotAnEar(String dir, String missingFile, boolean withLogging) {
        if (withLogging) {
            String string = String.valueOf(new File(dir, missingFile));
            LOGGER.fine(new StringBuilder(57 + String.valueOf(dir).length() + String.valueOf(string).length()).append("Directory '").append(dir).append("' is not an EAR directory. File ").append(string).append(" not detected.").toString());
        }
    }

    private static void reportConfigException(String message) {
        LOGGER.info(message);
        throw new AppEngineConfigException(message);
    }

    public static EarInfo readEarInfo(String earDirectoryPath, File schemaFile) throws AppEngineConfigException {
        if (!EarHelper.isEar(earDirectoryPath)) {
            throw new IllegalArgumentException(new StringBuilder(39 + String.valueOf(earDirectoryPath).length()).append("earDir '").append(earDirectoryPath).append("' is not a valid EAR directory.").toString());
        }
        File earDirectory = new File(earDirectoryPath).getAbsoluteFile();
        File metaInf = new File(earDirectory, META_INF);
        EarHelper.validateXml(new File(metaInf, APPENGINE_APPLICATION_XML_NAME), schemaFile);
        AppEngineApplicationXml appEngineApplicationXml = APP_ENGINE_APPLICATION_XML_READER.processXml(EarHelper.getInputStream(metaInf, APPENGINE_APPLICATION_XML_NAME));
        ApplicationXml applicationXml = APPLICATION_XML_READER.processXml(EarHelper.getInputStream(metaInf, APPLICATION_XML_NAME));
        String applicationId = appEngineApplicationXml.getApplicationId();
        ImmutableList.Builder moduleListBuilder = ImmutableList.builder();
        for (ApplicationXml.Modules.Web web : applicationXml.getModules().getWeb()) {
            File applicationDirectory = EarHelper.getApplicationDirectory(earDirectory, web.getWebUri());
            WebModule webModule = EarHelper.readWebModule(web.getContextRoot(), applicationDirectory, null, null, "");
            if (!applicationId.equals(webModule.getAppEngineWebXml().getAppId())) {
                String string = appEngineApplicationXml.getApplicationId();
                String string2 = String.valueOf(new File(metaInf, APPENGINE_APPLICATION_XML_NAME));
                String string3 = webModule.getAppEngineWebXml().getAppId();
                String string4 = String.valueOf(new File(applicationDirectory, "WEB-INF/appengine-web.xml"));
                LOGGER.info(new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Application id '").append(string).append("' from '").append(string2).append("' is overriding ").append(" application id '").append(string3).append("' from '").append(string4).append("'").toString());
                webModule.getAppEngineWebXml().setAppId(applicationId);
            }
            moduleListBuilder.add(webModule);
        }
        ImmutableCollection webModules = moduleListBuilder.build();
        if (webModules.size() == 0) {
            String string = String.valueOf(new File(metaInf, APPLICATION_XML_NAME));
            EarHelper.reportConfigException(new StringBuilder(41 + String.valueOf(string).length()).append("At least one web module is required in '").append(string).append("'").toString());
        }
        return new EarInfo(earDirectory, appEngineApplicationXml, applicationXml, (List<WebModule>)((Object)webModules));
    }

    public static WebModule readWebModule(@Nullable String contextRoot, File applicationDirectory, @Nullable File appengineWebXmlFile, @Nullable File webXmlFile, String appIdPrefix) throws AppEngineConfigException {
        AppEngineWebXml appEngineWebXml;
        Preconditions.checkNotNull(appIdPrefix);
        AppEngineWebXmlReader appEngineWebXmlReader = EarHelper.newAppEngineWebXmlReader(applicationDirectory, appengineWebXmlFile);
        WebXmlReader webXmlReader = EarHelper.newWebXmlReader(applicationDirectory, webXmlFile);
        AppYamlProcessor.convert(new File(applicationDirectory, "WEB-INF"), appEngineWebXmlReader.getFilename(), webXmlReader.getFilename());
        try {
            appEngineWebXml = appEngineWebXmlReader.readAppEngineWebXml();
        }
        catch (AppEngineConfigException aece) {
            throw new AppEngineConfigException(String.format("Invalid appengine-web.xml(%s) - %s", appEngineWebXmlReader.getFilename(), aece.getMessage()));
        }
        String appId = appEngineWebXml.getAppId();
        if (appId != null) {
            String string = String.valueOf(appIdPrefix);
            String string2 = String.valueOf(appEngineWebXml.getAppId());
            appEngineWebXml.setAppId(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        WebXml webXml = webXmlReader.readWebXml();
        WebModule webModule = new WebModule(applicationDirectory, appEngineWebXml, new File(appEngineWebXmlReader.getFilename()), webXml, new File(webXmlReader.getFilename()), contextRoot);
        return webModule;
    }

    private static File getApplicationDirectory(File earDirectory, String contextRoot) {
        File applicationDirectory = new File(earDirectory, contextRoot);
        if (!applicationDirectory.exists() || !applicationDirectory.isDirectory()) {
            String string = String.valueOf(applicationDirectory);
            EarHelper.reportConfigException(new StringBuilder(55 + String.valueOf(string).length()).append("Application directory '").append(string).append("' must exist and be a directory.").toString());
        }
        return applicationDirectory;
    }

    private static AppEngineWebXmlReader newAppEngineWebXmlReader(File applicationDirectory, File appEngineWebXmlFile) {
        return appEngineWebXmlFile == null ? new AppEngineWebXmlReader(applicationDirectory.getAbsolutePath()) : new AppEngineWebXmlReader(appEngineWebXmlFile.getParent(), appEngineWebXmlFile.getName());
    }

    private static WebXmlReader newWebXmlReader(File applicationDirectory, File webXmlFile) {
        return webXmlFile == null ? new WebXmlReader(applicationDirectory.getAbsolutePath()) : new WebXmlReader(webXmlFile.getParent(), webXmlFile.getName());
    }

    private static InputStream getInputStream(File parent, String fileName) {
        File file = new File(parent, fileName);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            String string = String.valueOf(file);
            throw new IllegalStateException(new StringBuilder(22 + String.valueOf(string).length()).append("File should exist - '").append(string).append("'").toString());
        }
    }

    private static boolean hasFile(File parent, String child) {
        File file = new File(parent, child);
        return file.isFile();
    }

    private static void validateXml(File xml, File schema) {
        if (!xml.exists()) {
            return;
        }
        StreamSource ss = null;
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                ss = new StreamSource(new FileInputStream(xml));
                factory.newSchema(schema).newValidator().validate(ss);
            }
            catch (SAXException ex) {
                String string = String.valueOf(xml.getPath());
                String string2 = String.valueOf(schema.getPath());
                throw new AppEngineConfigException(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("XML error validating ").append(string).append(" against ").append(string2).toString(), ex);
            }
        }
        catch (IOException ex) {
            String string = String.valueOf(xml.getPath());
            String string3 = String.valueOf(schema.getPath());
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string3).length()).append("IO error validating ").append(string).append(" against ").append(string3).toString(), ex);
        }
        finally {
            if (ss != null) {
                try {
                    ss.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

