/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexYamlReader;
import com.google.apphosting.utils.config.IndexesXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import java.util.logging.Level;
import org.mortbay.xml.XmlParser;

public class IndexesXmlReader
extends AbstractConfigXmlReader<IndexesXml> {
    public static final String GENERATED_INDEX_FILENAME = "datastore-indexes-auto.xml";
    public static final String INDEX_FILENAME = "datastore-indexes.xml";
    public static final String INDEX_YAML_FILENAME = "WEB-INF/index.yaml";
    public static final String AUTOINDEX_TAG = "autoGenerate";
    private static final String FILENAME = "WEB-INF/datastore-indexes.xml";
    private static final String INDEXES_TAG = "datastore-indexes";
    private static final String INDEX_TAG = "datastore-index";
    private static final String KIND_PROP = "kind";
    private static final String ANCESTORS_PROP = "ancestor";
    private static final String PROPERTY_TAG = "property";
    private static final String NAME_PROP = "name";
    private static final String DIRECTION_PROP = "direction";
    private static final String DIRECTION_VALUE_ASC = "asc";
    private static final String DIRECTION_VALUE_DESC = "desc";
    private static final String MODE_PROP = "mode";
    private IndexesXml indexesXml;

    public IndexesXmlReader(String appDir) {
        super(appDir, false);
    }

    public IndexesXml readIndexesXml() {
        return this.readConfigXml();
    }

    @Override
    protected IndexesXml readConfigXml() {
        InputStream is = null;
        String filename = null;
        this.indexesXml = new IndexesXml();
        try {
            if (this.fileExists()) {
                filename = this.getFilename();
                is = this.getInputStream();
                this.processXml(is);
                String string = String.valueOf(filename);
                this.logger.info(string.length() != 0 ? "Successfully processed ".concat(string) : new String("Successfully processed "));
            }
            if (this.yamlFileExists()) {
                filename = this.getYamlFilename();
                IndexYamlReader.parse(this.getYamlReader(), this.indexesXml);
                String string = String.valueOf(filename);
                this.logger.info(string.length() != 0 ? "Successfully processed ".concat(string) : new String("Successfully processed "));
            }
            if (this.generatedFileExists()) {
                filename = this.getAutoFilename();
                is = this.getGeneratedStream();
                this.processXml(is);
                String string = String.valueOf(filename);
                this.logger.info(string.length() != 0 ? "Successfully processed ".concat(string) : new String("Successfully processed "));
            }
        }
        catch (Exception e) {
            try {
                String string = String.valueOf(filename);
                String msg = string.length() != 0 ? "Received exception processing ".concat(string) : new String("Received exception processing ");
                this.logger.log(Level.SEVERE, msg, e);
                if (e instanceof AppEngineConfigException) {
                    throw (AppEngineConfigException)e;
                }
                throw new AppEngineConfigException(msg, e);
            }
            catch (Throwable throwable) {
                this.close(is);
                throw throwable;
            }
        }
        this.close(is);
        return this.indexesXml;
    }

    @Override
    protected IndexesXml processXml(InputStream is) {
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            IndexesXml.Index index;
            IndexesXml.Type indexType = null;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> unusedContainingElements) {
                if (IndexesXmlReader.INDEX_TAG.equalsIgnoreCase(node.getTag())) {
                    String kind = node.getAttribute(IndexesXmlReader.KIND_PROP);
                    Boolean ancestorProp = null;
                    String anc = node.getAttribute(IndexesXmlReader.ANCESTORS_PROP);
                    if (anc == null) {
                        this.indexType = null;
                    } else {
                        this.indexType = IndexesXml.Type.ORDERED;
                        ancestorProp = anc.equals("true") || anc.equals("1");
                    }
                    this.index = IndexesXmlReader.this.indexesXml.addNewIndex(kind, ancestorProp);
                } else if (IndexesXmlReader.PROPERTY_TAG.equalsIgnoreCase(node.getTag())) {
                    assert (this.index != null);
                    String name = node.getAttribute(IndexesXmlReader.NAME_PROP);
                    String direction = node.getAttribute(IndexesXmlReader.DIRECTION_PROP);
                    String mode = node.getAttribute(IndexesXmlReader.MODE_PROP);
                    if (direction != null) {
                        if (mode != null || this.indexType == IndexesXml.Type.GEO_SPATIAL) {
                            throw new AppEngineConfigException("The 'direction' attribute may not be specified in a 'geospatial' index.");
                        }
                        this.indexType = IndexesXml.Type.ORDERED;
                    } else if (mode != null) {
                        if (this.indexType == IndexesXml.Type.ORDERED) {
                            throw new AppEngineConfigException("The 'mode' attribute may not be specified with 'direction' or 'ancestor'.");
                        }
                        this.indexType = IndexesXml.Type.GEO_SPATIAL;
                    }
                    this.index.addNewProperty(name, direction, mode);
                }
            }
        }, is);
        return this.indexesXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    protected File getGeneratedFile() {
        File genFile = new File(GenerationDirectory.getGenerationDirectory(new File(this.appDir)), GENERATED_INDEX_FILENAME);
        return genFile;
    }

    public String getAutoFilename() {
        return this.getGeneratedFile().getPath();
    }

    protected boolean generatedFileExists() {
        return this.getGeneratedFile().exists();
    }

    protected InputStream getGeneratedStream() throws Exception {
        return new FileInputStream(this.getGeneratedFile());
    }

    protected String getYamlFilename() {
        String string = String.valueOf(this.appDir);
        String string2 = String.valueOf(INDEX_YAML_FILENAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    protected boolean yamlFileExists() {
        return new File(this.getYamlFilename()).exists();
    }

    protected Reader getYamlReader() {
        try {
            return new FileReader(this.getYamlFilename());
        }
        catch (FileNotFoundException ex) {
            String string = String.valueOf(this.getYamlFilename());
            throw new AppEngineConfigException(string.length() != 0 ? "Cannot find file".concat(string) : new String("Cannot find file"));
        }
    }
}

