/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.QueueXml;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

public class QueueXmlReader
extends AbstractConfigXmlReader<QueueXml> {
    private static final String FILENAME = "WEB-INF/queue.xml";
    private static final String TOTAL_STORAGE_LIMIT_TAG = "total-storage-limit";
    private static final String QUEUEENTRIES_TAG = "queue-entries";
    private static final String QUEUE_TAG = "queue";
    private static final String NAME_TAG = "name";
    private static final String RATE_TAG = "rate";
    private static final String BUCKET_SIZE = "bucket-size";
    private static final String MAX_CONCURRENT_REQUESTS = "max-concurrent-requests";
    private static final String MODE_TAG = "mode";
    private static final String RETRY_PARAMETERS_TAG = "retry-parameters";
    private static final String TASK_RETRY_LIMIT_TAG = "task-retry-limit";
    private static final String TASK_AGE_LIMIT_TAG = "task-age-limit";
    private static final String MIN_BACKOFF_SECONDS_TAG = "min-backoff-seconds";
    private static final String MAX_BACKOFF_SECONDS_TAG = "max-backoff-seconds";
    private static final String MAX_DOUBLINGS_TAG = "max-doublings";
    private static final String TARGET_TAG = "target";
    private static final String ACL_TAG = "acl";
    private static final String USER_EMAIL_TAG = "user-email";
    private static final String WRITER_EMAIL_TAG = "writer-email";

    public QueueXmlReader(String appDir) {
        super(appDir, false);
    }

    public QueueXml readQueueXml() {
        return (QueueXml)this.readConfigXml();
    }

    @Override
    protected QueueXml processXml(InputStream is) {
        final QueueXml queueXml = new QueueXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean firstQueueEntriesTag = true;
            boolean firstTotalStorageLimitTag = true;
            boolean insideRetryParametersTag = false;
            boolean insideAclTag = false;
            QueueXml.Entry entry;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!QueueXmlReader.QUEUEENTRIES_TAG.equalsIgnoreCase(node.getTag())) break;
                        if (!this.firstQueueEntriesTag) {
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(34 + String.valueOf(string).length()).append(string).append(" contains multiple <").append(QueueXmlReader.QUEUEENTRIES_TAG).append(">").toString());
                        }
                        this.firstQueueEntriesTag = false;
                        break;
                    }
                    case 1: {
                        if (this.firstQueueEntriesTag) {
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(33 + String.valueOf(string).length()).append(string).append(" does not contain <").append(QueueXmlReader.QUEUEENTRIES_TAG).append(">").toString());
                        }
                        if (QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!this.firstTotalStorageLimitTag) {
                                String string = QueueXmlReader.this.getFilename();
                                throw new AppEngineConfigException(new StringBuilder(40 + String.valueOf(string).length()).append(string).append(" contains multiple <").append(QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG).append(">").toString());
                            }
                            if (node.size() != 1 || !(node.get(0) instanceof String)) {
                                String string = QueueXmlReader.this.getFilename();
                                throw new AppEngineConfigException(new StringBuilder(33 + String.valueOf(string).length()).append(string).append("has invalid <").append(QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG).append(">").toString());
                            }
                            queueXml.setTotalStorageLimit(QueueXmlReader.this.getString(node));
                            this.firstTotalStorageLimitTag = false;
                            break;
                        }
                        if (QueueXmlReader.QUEUE_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry = queueXml.addNewEntry();
                            break;
                        }
                        String string = QueueXmlReader.this.getFilename();
                        String string2 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains <").append(string2).append("> instead of <").append(QueueXmlReader.QUEUE_TAG).append("/> or <").append(QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG).append(">").toString());
                    }
                    case 2: {
                        assert (this.entry != null);
                        if (QueueXmlReader.NAME_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setName(QueueXmlReader.this.getString(node));
                                break;
                            }
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(27 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(QueueXmlReader.NAME_TAG).append(">").toString());
                        }
                        if (QueueXmlReader.BUCKET_SIZE.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setBucketSize(QueueXmlReader.this.getString(node));
                                break;
                            }
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(34 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(QueueXmlReader.BUCKET_SIZE).append(">").toString());
                        }
                        if (QueueXmlReader.RATE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setRate(QueueXmlReader.this.getString(node));
                                break;
                            }
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(27 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(QueueXmlReader.RATE_TAG).append(">").toString());
                        }
                        if (QueueXmlReader.MAX_CONCURRENT_REQUESTS.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setMaxConcurrentRequests(QueueXmlReader.this.getString(node));
                                break;
                            }
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(46 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(QueueXmlReader.MAX_CONCURRENT_REQUESTS).append(">").toString());
                        }
                        if (QueueXmlReader.MODE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setMode(QueueXmlReader.this.getString(node));
                                break;
                            }
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(27 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(QueueXmlReader.MODE_TAG).append(">").toString());
                        }
                        if (QueueXmlReader.TARGET_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setTarget(QueueXmlReader.this.getString(node));
                                break;
                            }
                            String string = QueueXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(QueueXmlReader.TARGET_TAG).append(">").toString());
                        }
                        if (QueueXmlReader.RETRY_PARAMETERS_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry.setRetryParameters(new QueueXml.RetryParameters());
                            this.insideRetryParametersTag = true;
                            this.insideAclTag = false;
                            break;
                        }
                        if (QueueXmlReader.ACL_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry.setAcl(new ArrayList<QueueXml.AclEntry>());
                            this.insideAclTag = true;
                            this.insideRetryParametersTag = false;
                            break;
                        }
                        String string = QueueXmlReader.this.getFilename();
                        String string3 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" contains unknown <").append(string3).append("> inside <").append(QueueXmlReader.QUEUE_TAG).append("/>").toString());
                    }
                    case 3: {
                        String string;
                        boolean brokenTag;
                        assert (this.insideRetryParametersTag ^ this.insideAclTag);
                        assert (this.entry != null);
                        boolean bl = brokenTag = node.size() != 1 || !(node.get(0) instanceof String);
                        if (this.insideRetryParametersTag) {
                            assert (this.entry.getRetryParameters() != null);
                            QueueXml.RetryParameters retryParameters = this.entry.getRetryParameters();
                            if (QueueXmlReader.TASK_RETRY_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    retryParameters.setRetryLimit(QueueXmlReader.this.getString(node));
                                }
                            } else if (QueueXmlReader.TASK_AGE_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    retryParameters.setAgeLimitSec(QueueXmlReader.this.getString(node));
                                }
                            } else if (QueueXmlReader.MIN_BACKOFF_SECONDS_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    retryParameters.setMinBackoffSec(QueueXmlReader.this.getString(node));
                                }
                            } else if (QueueXmlReader.MAX_BACKOFF_SECONDS_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    retryParameters.setMaxBackoffSec(QueueXmlReader.this.getString(node));
                                }
                            } else if (QueueXmlReader.MAX_DOUBLINGS_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    retryParameters.setMaxDoublings(QueueXmlReader.this.getString(node));
                                }
                            } else {
                                String string4 = QueueXmlReader.this.getFilename();
                                String string5 = String.valueOf(node.getTag());
                                throw new AppEngineConfigException(new StringBuilder(47 + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string4).append(" contains unknown <").append(string5).append("> inside <").append(QueueXmlReader.RETRY_PARAMETERS_TAG).append("/>").toString());
                            }
                        }
                        if (this.insideAclTag) {
                            QueueXml.AclEntry acl;
                            assert (this.entry.getAcl() != null);
                            if (QueueXmlReader.USER_EMAIL_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    acl = new QueueXml.AclEntry();
                                    acl.setUserEmail(QueueXmlReader.this.getString(node));
                                    this.entry.getAcl().add(acl);
                                }
                            } else if (QueueXmlReader.WRITER_EMAIL_TAG.equalsIgnoreCase(node.getTag())) {
                                if (!brokenTag) {
                                    acl = new QueueXml.AclEntry();
                                    acl.setWriterEmail(QueueXmlReader.this.getString(node));
                                    this.entry.getAcl().add(acl);
                                }
                            } else {
                                string = QueueXmlReader.this.getFilename();
                                String string6 = String.valueOf(node.getTag());
                                throw new AppEngineConfigException(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string6).length()).append(string).append(" contains unknown <").append(string6).append("> inside <").append(QueueXmlReader.ACL_TAG).append("/>").toString());
                            }
                        }
                        if (!brokenTag) break;
                        string = QueueXmlReader.this.getFilename();
                        String string7 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string7).length()).append(string).append(" has bad contents in <").append(string7).append(">").toString());
                    }
                    default: {
                        String string = QueueXmlReader.this.getFilename();
                        String string8 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string8).length()).append(string).append(" has a syntax error; node <").append(string8).append("> is too deeply nested to be valid.").toString());
                    }
                }
            }
        }, is);
        queueXml.validateLastEntry();
        return queueXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

