/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.basement.dev.LocalBasementService;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.time.Clock;
import com.google.appengine.repackaged.com.google.universalnav.OneGoogleServerProto;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.gaia.mint.GaiaMintScopeCode;
import java.io.OutputStream;
import java.util.LinkedList;

public class LocalBasementServiceTestConfig
implements LocalServiceTestConfig {
    private boolean logToSawmillEnable = true;
    private boolean logToSawmillIgnore = false;
    private boolean logToSawmillLogEveryCall = false;
    private OutputStream logToSawmillFinalProtoStream = null;
    private String gaiaMintEmail = null;
    private String gaiaMintUserId = null;
    private String gaiaMintAuthDomain = null;
    private Boolean gaiaMintIsAdmin = null;
    private Long gaiaMintGaiaId = null;
    private LinkedList<GaiaMintScopeCode.ScopeCode> gaiaMintAllowedScopes = new LinkedList();
    private String oneGoogleServerSpec = null;
    private OneGoogleServerProto.OneGoogleService.Stub oneGoogleStub = null;
    private Clock clock = null;

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("gae.basement.sawmill.enable", Boolean.toString(this.logToSawmillEnable));
        proxy.setProperty("gae.basement.sawmill.ignore", Boolean.toString(this.logToSawmillIgnore));
        proxy.setProperty("gae.basement.sawmill.logeverycall", Boolean.toString(this.logToSawmillLogEveryCall));
        proxy.setProperty("gae.basement.sawmill.writefinalproto", (this.logToSawmillFinalProtoStream != null ? Boolean.TRUE : Boolean.FALSE).toString());
        if (this.gaiaMintEmail != null) {
            proxy.setProperty("gae.basement.gaiamint.email", this.gaiaMintEmail);
        }
        if (this.gaiaMintUserId != null) {
            proxy.setProperty("gae.basement.gaiamint.user_id", this.gaiaMintUserId);
        }
        if (this.gaiaMintAuthDomain != null) {
            proxy.setProperty("gae.basement.gaiamint.auth_domain", this.gaiaMintAuthDomain);
        }
        if (this.gaiaMintIsAdmin != null) {
            proxy.setProperty("gae.basement.gaiamint.is_admin", this.gaiaMintIsAdmin.toString());
        }
        if (this.gaiaMintGaiaId != null) {
            proxy.setProperty("gae.basement.gaiamint.gaia_id", this.gaiaMintGaiaId.toString());
        }
        if (!this.gaiaMintAllowedScopes.isEmpty()) {
            proxy.setProperty("gae.basement.gaiamint.allowed_scopes", Joiner.on(',').join(this.gaiaMintAllowedScopes));
        }
        if (this.oneGoogleServerSpec != null) {
            proxy.setProperty("gae.basement.onegoogle.server_spec", this.oneGoogleServerSpec);
        }
        LocalBasementService localBasementService = LocalBasementServiceTestConfig.getLocalBasementService();
        if (this.logToSawmillFinalProtoStream != null) {
            localBasementService.injectLogToSawmillOutputStream(this.logToSawmillFinalProtoStream);
        }
        if (this.oneGoogleStub != null) {
            localBasementService.injectOneGoogleStub(this.oneGoogleStub);
        }
        if (this.clock != null) {
            localBasementService.injectClock(this.clock);
        }
    }

    @Override
    public void tearDown() {
    }

    public static LocalBasementService getLocalBasementService() {
        return (LocalBasementService)LocalServiceTestHelper.getLocalService("basement");
    }

    public LocalBasementServiceTestConfig setLogToSawmillProtoStream(OutputStream out) {
        this.logToSawmillFinalProtoStream = out;
        return this;
    }

    public LocalBasementServiceTestConfig setLogToSawmillEnable(boolean b) {
        this.logToSawmillEnable = b;
        return this;
    }

    public LocalBasementServiceTestConfig setLogToSawmillIgnore(boolean b) {
        this.logToSawmillIgnore = b;
        return this;
    }

    public LocalBasementServiceTestConfig setLogToSawmillLogEveryCall(boolean b) {
        this.logToSawmillLogEveryCall = b;
        return this;
    }

    public LocalBasementServiceTestConfig setGaiaMintEmail(String email) {
        this.gaiaMintEmail = email;
        return this;
    }

    public LocalBasementServiceTestConfig setGaiaMintUserId(String userId) {
        this.gaiaMintUserId = userId;
        return this;
    }

    public LocalBasementServiceTestConfig setGaiaMintAuthDomain(String authDomain) {
        this.gaiaMintAuthDomain = authDomain;
        return this;
    }

    public LocalBasementServiceTestConfig setGaiaMintIsAdmin(boolean isAdmin) {
        this.gaiaMintIsAdmin = isAdmin;
        return this;
    }

    public LocalBasementServiceTestConfig setGaiaMintGaiaId(long gaiaId) {
        this.gaiaMintGaiaId = gaiaId;
        return this;
    }

    public LocalBasementServiceTestConfig addGaiaMintAllowedScope(GaiaMintScopeCode.ScopeCode allowedScope) {
        this.gaiaMintAllowedScopes.add(allowedScope);
        return this;
    }

    public LocalBasementServiceTestConfig setOneGoogleServerSpec(String serverSpec) {
        this.oneGoogleServerSpec = serverSpec;
        return this;
    }

    public LocalBasementServiceTestConfig setOneGoogleStub(OneGoogleServerProto.OneGoogleService.Stub stub) {
        this.oneGoogleStub = stub;
        return this;
    }

    public LocalBasementServiceTestConfig setClock(Clock clock) {
        this.clock = clock;
        return this;
    }
}

