/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlConfig;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class ClientDeployYamlMaker {
    public static final String UNKNOWN_RUNTIME = "unknown";
    private String runtime = "unknown";
    private final long startTimeUsec;
    private final ArrayList<Request> requests = new ArrayList();
    private final String sdkVersion;

    public ClientDeployYamlMaker(long startTimeUsec, String sdkVersion) {
        this.startTimeUsec = startTimeUsec;
        this.sdkVersion = Preconditions.checkNotNull(sdkVersion, "sdkVersion may not be null");
    }

    public void setRuntime(String runtime) {
        this.runtime = Preconditions.checkNotNull(runtime, "runtime may not be null");
    }

    public void addRequest(String path, int responseCode, long startTimeUsec, long endTimeUsec, long requestSizeBytes) {
        this.requests.add(new Request(Preconditions.checkNotNull(path, "path may not be null"), responseCode, startTimeUsec, endTimeUsec, requestSizeBytes));
    }

    public String getRuntime() {
        return this.runtime;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String make(long endTimeUsec, boolean success) throws YamlException {
        StringWriter stringWriter = new StringWriter();
        YamlConfig yamlConfig = new YamlConfig();
        yamlConfig.writeConfig.setIndentSize(2);
        yamlConfig.writeConfig.setWriteRootTags(false);
        yamlConfig.writeConfig.setWriteRootElementTags(false);
        yamlConfig.writeConfig.setWriteDefaultValues(true);
        yamlConfig.setPropertyElementType(ClientDeploy.class, "requests", Request.class);
        YamlWriter yamlWriter = new YamlWriter((Writer)stringWriter, yamlConfig);
        ClientDeploy clientDeploy = new ClientDeploy(this.runtime, this.startTimeUsec, endTimeUsec, this.requests, success, this.sdkVersion);
        yamlWriter.write((Object)clientDeploy);
        yamlWriter.close();
        return stringWriter.toString();
    }

    public static class ClientDeployBeanInfo
    extends SimpleBeanInfo {
        @Override
        public PropertyDescriptor[] getPropertyDescriptors() {
            try {
                return new PropertyDescriptor[]{new PropertyDescriptor("runtime", ClientDeploy.class), new PropertyDescriptor("start_time_usec", ClientDeploy.class, "getStartTimeUsec", "setStartTimeUsec"), new PropertyDescriptor("end_time_usec", ClientDeploy.class, "getEndTimeUsec", "setEndTimeUsec"), new PropertyDescriptor("requests", ClientDeploy.class), new PropertyDescriptor("success", ClientDeploy.class), new PropertyDescriptor("sdk_version", ClientDeploy.class, "getSdkVersion", "setSdkVersion")};
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class ClientDeploy {
        private String runtime;
        private long startTimeUsec;
        private long endTimeUsec;
        private ArrayList<Request> requests;
        private boolean success;
        private String sdkVersion;

        public ClientDeploy(String runtime, long startTimeUsec, long endTimeUsec, ArrayList<Request> requests, boolean success, String sdkVersion) {
            this.runtime = runtime;
            this.startTimeUsec = startTimeUsec;
            this.endTimeUsec = endTimeUsec;
            this.requests = requests;
            this.success = success;
            this.sdkVersion = sdkVersion;
        }

        public ClientDeploy() {
        }

        public String getRuntime() {
            return this.runtime;
        }

        public void setRuntime(String runtime) {
            throw new UnsupportedOperationException();
        }

        public long getStartTimeUsec() {
            return this.startTimeUsec;
        }

        public void setStartTimeUsec(long startTimeUsec) {
            throw new UnsupportedOperationException();
        }

        public long getEndTimeUsec() {
            return this.endTimeUsec;
        }

        public void setEndTimeUsec(long endTimeUsec) {
            throw new UnsupportedOperationException();
        }

        public ArrayList<Request> getRequests() {
            return this.requests;
        }

        public void setRequests(ArrayList<Request> requests) {
            throw new UnsupportedOperationException();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            throw new UnsupportedOperationException();
        }

        public String getSdkVersion() {
            return this.sdkVersion;
        }

        public void setSdkVersion(String sdkVersion) {
            throw new UnsupportedOperationException();
        }
    }

    public static class RequestBeanInfo
    extends SimpleBeanInfo {
        @Override
        public PropertyDescriptor[] getPropertyDescriptors() {
            try {
                return new PropertyDescriptor[]{new PropertyDescriptor("path", Request.class), new PropertyDescriptor("response_code", Request.class, "getResponseCode", "setResponseCode"), new PropertyDescriptor("start_time_usec", Request.class, "getStartTimeUsec", "setStartTimeUsec"), new PropertyDescriptor("end_time_usec", Request.class, "getEndTimeUsec", "setEndTimeUsec"), new PropertyDescriptor("request_size_bytes", Request.class, "getRequestSizeBytes", "setRequestSizeBytes")};
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class Request {
        private String path;
        private int responseCode;
        private long startTimeUsec;
        private long endTimeUsec;
        private long requestSizeBytes;

        public Request() {
        }

        public Request(String path, int responseCode, long startTimeUsec, long endTimeUsec, long requestSizeBytes) {
            this.path = path;
            this.responseCode = responseCode;
            this.startTimeUsec = startTimeUsec;
            this.endTimeUsec = endTimeUsec;
            this.requestSizeBytes = requestSizeBytes;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            throw new UnsupportedOperationException();
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public void setResponseCode(int responseCode) {
            throw new UnsupportedOperationException();
        }

        public long getStartTimeUsec() {
            return this.startTimeUsec;
        }

        public void setStartTimeUsec(long startTimeUsec) {
            throw new UnsupportedOperationException();
        }

        public long getEndTimeUsec() {
            return this.endTimeUsec;
        }

        public void setEndTimeUsec(long endTimeUsec) {
            throw new UnsupportedOperationException();
        }

        public long getRequestSizeBytes() {
            return this.requestSizeBytes;
        }

        public void setRequestSizeBytes(long requestSizeBytes) {
            throw new UnsupportedOperationException();
        }
    }
}

