/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class IndexYamlReader {
    public static final String INDEX_DEFINITIONS_TAG = "!!python/object:google.appengine.datastore.datastore_index.IndexDefinitions";
    public static final String INDEX_TAG = "!!python/object:google.appengine.datastore.datastore_index.Index";
    public static final String PROPERTY_TAG = "!!python/object:google.appengine.datastore.datastore_index.Property";

    public static IndexesXml parse(Reader yaml, IndexesXml xml) {
        List<IndexesXml> list;
        try {
            list = IndexYamlReader.parseMultiple(yaml, xml);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
        if (0 == list.size()) {
            throw new AppEngineConfigException("Empty index configuration.");
        }
        if (list.size() > 1) {
            int n = list.size();
            throw new AppEngineConfigException(new StringBuilder(63).append("yaml unexepectedly contains more than one document: ").append(n).toString());
        }
        return list.get(0);
    }

    public static IndexesXml parse(String yaml) {
        return IndexYamlReader.parse(new StringReader(IndexYamlReader.clean(yaml)), null);
    }

    public static List<IndexesXml> parseMultiple(String yaml) {
        try {
            return IndexYamlReader.parseMultiple(new StringReader(IndexYamlReader.clean(yaml)), null);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    private static String clean(String yaml) {
        return yaml.replaceAll(INDEX_DEFINITIONS_TAG, "").replaceAll(INDEX_TAG, "").replaceAll(PROPERTY_TAG, "").trim();
    }

    private static List<IndexesXml> parseMultiple(Reader yaml, IndexesXml xml) throws YamlException {
        IndexYaml indexYaml;
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(IndexYaml.class, "indexes", IndexYaml.Index.class);
        reader.getConfig().setPropertyElementType(IndexYaml.Index.class, "properties", IndexYaml.Property.class);
        LinkedList<IndexesXml> list = new LinkedList<IndexesXml>();
        while (null != (indexYaml = (IndexYaml)reader.read(IndexYaml.class))) {
            list.add(indexYaml.toXml(xml));
        }
        return list;
    }

    public static class IndexYaml {
        public String application;
        private List<Index> indexes;

        public List<Index> getIndexes() {
            return this.indexes;
        }

        public void setIndexes(List<Index> indexes) {
            this.indexes = indexes;
        }

        public IndexesXml toXml(IndexesXml xml) {
            if (xml == null) {
                xml = new IndexesXml();
            }
            if (this.indexes != null) {
                for (Index yamlIndex : this.indexes) {
                    if (yamlIndex.kind == null) {
                        throw new AppEngineConfigException("Index missing required element 'kind'");
                    }
                    IndexesXml.Index xmlIndex = xml.addNewIndex(yamlIndex.kind, yamlIndex.ancestor);
                    if (yamlIndex.properties == null) continue;
                    for (Property property : yamlIndex.properties) {
                        if (property.getName() == null) {
                            throw new AppEngineConfigException("Property is missing required element 'name'.");
                        }
                        xmlIndex.addNewProperty(property.getName(), property.getDirection(), property.getMode());
                    }
                }
            }
            return xml;
        }

        public static class Property {
            private String name = null;
            private String direction = null;
            private String mode = null;

            public void setDirection(String direction) {
                if (!"desc".equals(direction) && !"asc".equals(direction)) {
                    throw new AppEngineConfigException(new StringBuilder(47 + String.valueOf(direction).length()).append("Invalid direction '").append(direction).append("': expected '").append("asc").append("' or '").append("desc").append("'.").toString());
                }
                this.direction = direction;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getDirection() {
                return this.direction;
            }

            public void setMode(String mode) {
                if ("null".equals(mode)) {
                    mode = null;
                }
                if (mode != null && !mode.equals("geospatial")) {
                    String string = String.valueOf(mode);
                    throw new AppEngineConfigException(string.length() != 0 ? "Invalid mode: '".concat(string) : new String("Invalid mode: '"));
                }
                this.mode = mode;
            }

            public String getMode() {
                return this.mode;
            }
        }

        public static class Index {
            public String kind;
            protected boolean ancestor;
            public List<Property> properties;

            public void setAncestor(String ancestor) {
                this.ancestor = YamlUtils.parseBoolean(ancestor);
            }

            public String getAncestor() {
                boolean bl = this.ancestor;
                return new StringBuilder(5).append(bl).toString();
            }
        }
    }
}

