/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.appengine.repackaged.org.joda.time.Duration;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class JodaDurationFlag
extends Flag<Duration> {
    private static final Converter<String, Duration> CONVERTER = new Converter<String, Duration>(){

        @Override
        protected Duration doForward(String text) {
            return JodaDurationFlag.parseDuration(text);
        }

        @Override
        protected String doBackward(Duration duration) {
            return JodaDurationFlag.formatDuration(duration);
        }
    };
    private final Duration minValue;
    private final Duration maxValue;
    public static final String FORMAT_DESCRIPTION = "Days (d), hours (h), minutes (m), seconds (s), and milliseconds (ms) can be specified using the appropriate suffix (e.g. 1h5m500ms = 1 hour 5 minutes 500 millis).";
    private static final Duration MAX_DURATION = Duration.millis((long)Long.MAX_VALUE);
    private static final String UNIT_PATTERN_STRING = "(?x) (?<whole>[0-9]+)? (?<frac>\\.[0-9]*)? (?<unit>d|h|ms?|s)";
    private static final Pattern UNIT_PATTERN = Pattern.compile("(?x) (?<whole>[0-9]+)? (?<frac>\\.[0-9]*)? (?<unit>d|h|ms?|s)");
    private static final CharMatcher ASCII_DIGIT = CharMatcher.inRange('0', '9');

    public static Converter<String, Duration> converter() {
        return CONVERTER;
    }

    public static JodaDurationFlag value(@Nullable Duration defaultValue) {
        return new JodaDurationFlag(defaultValue);
    }

    public static JodaDurationFlag nullValue() {
        return new JodaDurationFlag(null);
    }

    public static JodaDurationFlag zero() {
        return JodaDurationFlag.value(Duration.ZERO);
    }

    public static JodaDurationFlag days(long defaultValue) {
        return JodaDurationFlag.value(Duration.standardDays((long)defaultValue));
    }

    public static JodaDurationFlag hours(long defaultValue) {
        return JodaDurationFlag.value(Duration.standardHours((long)defaultValue));
    }

    public static JodaDurationFlag minutes(long defaultValue) {
        return JodaDurationFlag.value(Duration.standardMinutes((long)defaultValue));
    }

    public static JodaDurationFlag seconds(long defaultValue) {
        return JodaDurationFlag.value(Duration.standardSeconds((long)defaultValue));
    }

    public static JodaDurationFlag millis(long defaultValue) {
        return JodaDurationFlag.value(Duration.millis((long)defaultValue));
    }

    public static JodaDurationFlag interval(Duration defaultValue, Duration min, Duration max) {
        return new JodaDurationFlag(defaultValue, min, max);
    }

    @Override
    public String parsableStringValue(Duration value) {
        return JodaDurationFlag.formatDuration(value);
    }

    private JodaDurationFlag(@Nullable Duration defaultValue) {
        this(defaultValue, Duration.ZERO, MAX_DURATION);
    }

    private JodaDurationFlag(@Nullable Duration defaultValue, Duration minValue, Duration maxValue) {
        super(defaultValue);
        this.minValue = Preconditions.checkNotNull(minValue);
        this.maxValue = Preconditions.checkNotNull(maxValue);
        Preconditions.checkArgument(minValue.compareTo((ReadableDuration)maxValue) <= 0, "Min (%s) larger than max (%s)", (Object)minValue, (Object)maxValue);
        Preconditions.checkArgument(defaultValue == null || minValue.compareTo((ReadableDuration)defaultValue) <= 0, "Default (%s) smaller than min (%s)", (Object)defaultValue, (Object)minValue);
        Preconditions.checkArgument(defaultValue == null || defaultValue.compareTo((ReadableDuration)maxValue) <= 0, "Default (%s) larger than max (%s)", (Object)defaultValue, (Object)maxValue);
    }

    @Override
    protected Duration parse(String text) throws InvalidFlagValueException {
        try {
            Duration val = JodaDurationFlag.parseDuration(text);
            if (this.minValue.compareTo((ReadableDuration)val) > 0) {
                throw new InvalidFlagValueException(String.format("Flag value %s is below the minimum value %s", val, this.minValue));
            }
            if (this.maxValue.compareTo((ReadableDuration)val) < 0) {
                throw new InvalidFlagValueException(String.format("Flag value %s exceeds the maximum value %s", val, this.maxValue));
            }
            return val;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagValueException("Invalid syntax for Duration", e);
        }
    }

    private static Duration parseDuration(String value) {
        value = CharMatcher.whitespace().trimFrom(value);
        if ("0".equals(value)) {
            return Duration.ZERO;
        }
        Preconditions.checkArgument(!value.isEmpty(), "The empty string is not a valid Duration!");
        long millis = 0L;
        boolean negative = value.startsWith("-");
        int index = negative ? 1 : 0;
        Matcher matcher = UNIT_PATTERN.matcher(value);
        while (matcher.find(index) && matcher.start() == index) {
            Preconditions.checkArgument(ASCII_DIGIT.matchesAnyOf(matcher.group(0)));
            try {
                long whole = Long.parseLong(MoreObjects.firstNonNull(matcher.group("whole"), "0"));
                String string = String.valueOf(MoreObjects.firstNonNull(matcher.group("frac"), ""));
                double frac = Double.parseDouble(string.length() != 0 ? "0".concat(string) : new String("0"));
                int millisPerUnit = JodaDurationFlag.millisPerUnit(matcher.group("unit"));
                millis = LongMath.checkedAdd(millis, LongMath.checkedMultiply(millisPerUnit, whole));
                millis = LongMath.checkedAdd(millis, (long)((double)millisPerUnit * frac));
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(e);
            }
            index = matcher.end();
        }
        if (index < value.length()) {
            String string = String.valueOf(value);
            throw new IllegalArgumentException(string.length() != 0 ? "Could not parse entire duration: ".concat(string) : new String("Could not parse entire duration: "));
        }
        if (negative) {
            millis = -millis;
        }
        return Duration.millis((long)millis);
    }

    private static int millisPerUnit(String unit) {
        switch (Ascii.toLowerCase(unit)) {
            case "d": {
                return 86400000;
            }
            case "h": {
                return 3600000;
            }
            case "m": {
                return 60000;
            }
            case "s": {
                return 1000;
            }
            case "ms": {
                return 1;
            }
        }
        String string = String.valueOf(unit);
        throw new IllegalArgumentException(string.length() != 0 ? "Unknown duration unit ".concat(string) : new String("Unknown duration unit "));
    }

    private static String formatDuration(Duration duration) {
        long millis = Math.abs(duration.getMillis());
        long days = millis / 86400000L;
        long hours = (millis %= 86400000L) / 3600000L;
        long minutes = (millis %= 3600000L) / 60000L;
        long seconds = (millis %= 60000L) / 1000L;
        millis %= 1000L;
        StringBuilder sb = new StringBuilder();
        if (duration.getMillis() < 0L) {
            sb.append('-');
        }
        if (days > 0L) {
            sb.append(days).append("d");
        }
        if (hours > 0L) {
            sb.append(hours).append("h");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s");
        }
        if (millis > 0L) {
            sb.append(millis).append("ms");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "0";
    }

    public static final class JodaDurationFactory {
        public static Duration valueOf(String text) {
            return JodaDurationFlag.parseDuration(text);
        }

        private JodaDurationFactory() {
        }
    }
}

