/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MutableGeneratedMetadataProto;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class InternalProtobufMeta {
    private static final String PROTOBUF_META_FILE = "protobuf.meta";
    private static final InternalProtobufMeta INSTANCE = new InternalProtobufMeta(InternalProtobufMeta.loadMetadata());
    private final List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> extensions = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry>();
    private final List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> messages = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry>();
    private final List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> enums = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry>();

    private InternalProtobufMeta(List<MutableGeneratedMetadataProto.GeneratedMetadata> metadatas) {
        HashSet<String> foundImmutable = new HashSet<String>();
        HashSet foundMutable = new HashSet();
        for (MutableGeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry generatedExtensionEntry : metadata.getExtensionList()) {
                if (!(generatedExtensionEntry.getImmutable() ? foundImmutable : foundMutable).add(generatedExtensionEntry.getName())) continue;
                this.extensions.add(generatedExtensionEntry);
            }
        }
        foundImmutable.clear();
        foundMutable.clear();
        for (MutableGeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry generatedMessageEntry : metadata.getGeneratedMessageList()) {
                if (!(generatedMessageEntry.getImmutable() ? foundImmutable : foundMutable).add(generatedMessageEntry.getName())) continue;
                this.messages.add(generatedMessageEntry);
            }
        }
        foundImmutable.clear();
        foundMutable.clear();
        for (MutableGeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry generatedEnumEntry : metadata.getGeneratedEnumList()) {
                if (!(generatedEnumEntry.getImmutable() ? foundImmutable : foundMutable).add(generatedEnumEntry.getName())) continue;
                this.enums.add(generatedEnumEntry);
            }
        }
        ((ArrayList)this.extensions).trimToSize();
        ((ArrayList)this.messages).trimToSize();
        ((ArrayList)this.enums).trimToSize();
    }

    public static InternalProtobufMeta getInstance() {
        return INSTANCE;
    }

    public List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> getExtensions() {
        return this.extensions;
    }

    public List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> getMessages() {
        return this.messages;
    }

    public List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> getEnums() {
        return this.enums;
    }

    private static List<MutableGeneratedMetadataProto.GeneratedMetadata> loadMetadata() {
        ClassLoader loader = InternalProtobufMeta.class.getClassLoader();
        ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata> metadatas = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata>();
        try {
            Enumeration<URL> urls = loader.getResources(PROTOBUF_META_FILE);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                metadatas.add(InternalProtobufMeta.load(url));
            }
            return metadatas;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load generated message meta data.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutableGeneratedMetadataProto.GeneratedMetadata load(URL url) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
            MutableGeneratedMetadataProto.GeneratedMetadata metadata = MutableGeneratedMetadataProto.GeneratedMetadata.newMessage();
            if (!metadata.parseFrom(is)) {
                throw new InvalidProtocolBufferException("Failed to parse metadata proto.");
            }
            MutableGeneratedMetadataProto.GeneratedMetadata generatedMetadata = metadata;
            return generatedMetadata;
        }
    }
}

