/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.taskqueue.TaskQueueStubServicePb;
import com.google.appengine.api.urlfetch.URLFetchStubServicePb;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.net.util.proto2api.Status;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.GetMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.PostMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.RequestEntity;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.DevSocketImplFactory;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.apphosting.utils.runtime.ApiProxyUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.http.HTTPException;

public class ApiServer {
    private static final Logger logger = Logger.getLogger(ApiServer.class.getName());
    private final Process process;
    private final int port;
    private final ServerOutput serverOutput;

    ApiServer(String pathToApiServer, String applicationName, String appDir, String baseUrl) {
        try {
            try (ServerSocket socket = new ServerSocket(0);){
                this.port = socket.getLocalPort();
            }
            String[] stringArray = new String[12];
            stringArray[0] = pathToApiServer;
            stringArray[1] = "--api_port";
            stringArray[2] = String.valueOf(this.port);
            stringArray[3] = "--clear_datastore";
            stringArray[4] = "--datastore_consistency_policy";
            stringArray[5] = "consistent";
            stringArray[6] = "--application";
            stringArray[7] = applicationName;
            stringArray[8] = "--application_prefix";
            stringArray[9] = "";
            stringArray[10] = "--datastore_path";
            int n = this.port;
            stringArray[11] = new StringBuilder(16).append("/tmp/").append(n).toString();
            ArrayList<String> apiServerCommand = new ArrayList<String>(Arrays.asList(stringArray));
            if (System.getProperty("appengine.pythonApiServerFlags") != null) {
                for (String apiServerFlag : Splitter.on('|').split(System.getProperty("appengine.pythonApiServerFlags"))) {
                    apiServerCommand.add(apiServerFlag);
                }
            }
            if (baseUrl != null) {
                apiServerCommand.add("--java_app_base_url");
                apiServerCommand.add(baseUrl);
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(apiServerCommand).redirectErrorStream(true);
            Map<String, String> env = pb.environment();
            String datastoreEmulatorHost = System.getenv("DATASTORE_EMULATOR_HOST");
            if (datastoreEmulatorHost != null) {
                env.put("DATASTORE_EMULATOR_HOST", datastoreEmulatorHost);
            }
            this.process = pb.start();
            this.serverOutput = new ServerOutput(this.process);
            this.serverOutput.start();
            this.serverOutput.await();
            if (appDir != null) {
                this.findAndLoadQueueXmlFileInAppDir(appDir);
            }
            this.setUrlFetchHttpProxy();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public void clear() throws IOException {
        HttpClient httpClient = new HttpClient();
        int n = this.port;
        GetMethod request = new GetMethod(new StringBuilder(34).append("http://localhost:").append(n).append("/clear").toString());
        int returnCode = httpClient.executeMethod((HttpMethod)request);
        if (returnCode != 200) {
            throw new IOException(new StringBuilder(78).append("Sending HTTP request to clear the API server failed with response: ").append(returnCode).toString());
        }
    }

    public void close() {
        try {
            int exitValue = this.process.exitValue();
            if (exitValue != 0) {
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiServer", "close", new StringBuilder(67).append("The API server process exited with a non-zero value of: ").append(exitValue).toString());
            }
        }
        catch (IllegalThreadStateException e) {
            this.serverOutput.stopReadingOutput();
            this.process.destroy();
        }
    }

    public byte[] makeSyncCall(String packageName, String methodName, byte[] requestBytes) throws IOException {
        RemoteApiPb.Request remoteApiRequest = new RemoteApiPb.Request();
        remoteApiRequest.setServiceName(packageName);
        remoteApiRequest.setMethod(methodName);
        remoteApiRequest.setRequestAsBytes(requestBytes);
        remoteApiRequest.setRequestId(UUID.randomUUID().toString().substring(0, 10));
        byte[] remoteApiRequestBytes = ApiUtils.convertPbToBytes(remoteApiRequest);
        int n = this.port;
        PostMethod post = new PostMethod(new StringBuilder(28).append("http://localhost:").append(n).toString());
        post.setFollowRedirects(false);
        post.addRequestHeader("Host", "localhost");
        post.addRequestHeader("Content-Type", "application/octet-stream");
        post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(remoteApiRequestBytes));
        boolean oldNativeSocketMode = DevSocketImplFactory.isNativeSocketMode();
        DevSocketImplFactory.setSocketNativeMode(true);
        try {
            HttpClient httpClient = new HttpClient();
            httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() != 200) {
                throw new HTTPException(post.getStatusCode());
            }
        }
        catch (IOException e) {
            throw new IOException("Error executing POST to HTTP API server.");
        }
        finally {
            DevSocketImplFactory.setSocketNativeMode(oldNativeSocketMode);
        }
        RemoteApiPb.Response response = new RemoteApiPb.Response();
        boolean parsed = response.mergeFrom(post.getResponseBodyAsStream());
        if (!parsed) {
            throw new IOException("Error parsing the response from the HTTP API server.");
        }
        if (response.hasApplicationError()) {
            throw ApiProxyUtils.getRpcError(packageName, methodName, Status.StatusProto.getDefaultInstance(), response.getApplicationError().getCode(), response.getApplicationError().getDetail(), null);
        }
        if (response.hasRpcError()) {
            throw ApiProxyUtils.getApiError(packageName, methodName, response, logger);
        }
        return response.getResponseAsBytes();
    }

    private void setUrlFetchHttpProxy() {
        String proxyHost = System.getProperty("host.proxyHost");
        String proxyPort = System.getProperty("host.proxyPort");
        if (proxyHost == null || proxyPort == null) {
            return;
        }
        Integer parsedProxyPort = Ints.tryParse(proxyPort);
        if (parsedProxyPort == null) {
            String string = String.valueOf(proxyPort);
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiServer", "setUrlFetchHttpProxy", string.length() != 0 ? "host.proxyPort not a valid integer: ".concat(string) : new String("host.proxyPort not a valid integer: "));
            return;
        }
        URLFetchStubServicePb.SetHttpProxyRequest.Builder setProxyRequestBuilder = URLFetchStubServicePb.SetHttpProxyRequest.newBuilder();
        setProxyRequestBuilder.setHttpProxyHost(proxyHost);
        setProxyRequestBuilder.setHttpProxyPort(parsedProxyPort.intValue());
        byte[] requestBytes = ApiUtils.convertPbToBytes(setProxyRequestBuilder.build());
        try {
            this.makeSyncCall("urlfetch", "SetHttProxy", requestBytes);
        }
        catch (IOException e) {
            String string = String.valueOf(parsedProxyPort);
            String string2 = String.valueOf(e);
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiServer", "setUrlFetchHttpProxy", new StringBuilder(24 + String.valueOf(proxyHost).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("SetHttpProxy(").append(proxyHost).append(":").append(string).append(") failed: ").append(string2).toString());
        }
    }

    private void findAndLoadQueueXmlFileInAppDir(String appDir) {
        Path queueXmlPath = Paths.get(appDir, "WEB-INF", "queue.xml");
        if (!Files.exists(queueXmlPath, new LinkOption[0])) {
            String string = String.valueOf(queueXmlPath);
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiServer", "findAndLoadQueueXmlFileInAppDir", new StringBuilder(84 + String.valueOf(string).length()).append("No queue.xml found at ").append(string).append(". Python task queue stub will use default queue configuration.").toString());
            return;
        }
        TaskQueueStubServicePb.LoadQueueXmlRequest lqxr = TaskQueueStubServicePb.LoadQueueXmlRequest.newBuilder().setQueueXmlPath(queueXmlPath.toString()).build();
        byte[] requestBytes = ApiUtils.convertPbToBytes(lqxr);
        try {
            this.makeSyncCall("taskqueue", "LoadQueueXml", requestBytes);
        }
        catch (IOException e) {
            String string = queueXmlPath.toString();
            String string2 = String.valueOf(e);
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiServer", "findAndLoadQueueXmlFileInAppDir", new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append("LoadQueueXml(queueXmlPath=").append(string).append(") failed: ").append(string2).toString());
        }
    }

    private static class ServerOutput
    extends Thread {
        private final Process process;
        private final CountDownLatch readyLatch = new CountDownLatch(1);
        private final String readyMessage = "Starting API server at:";
        private final AtomicBoolean stopped = new AtomicBoolean();

        private ServerOutput(Process process) {
            this.process = process;
        }

        public void await() {
            try {
                this.readyLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void stopReadingOutput() {
            this.stopped.set(true);
        }

        @Override
        public void run() {
            block3: {
                try {
                    String stdInputLine;
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
                    while ((stdInputLine = stdInput.readLine()) != null) {
                        System.out.println(stdInputLine);
                        if (!stdInputLine.contains("Starting API server at:")) continue;
                        this.readyLatch.countDown();
                    }
                }
                catch (IOException e) {
                    if (this.stopped.get()) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

