/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class YamlUtils {
    static final Pattern TRUE_PATTERN = Pattern.compile("y|Y|yes|Yes|YES|true|True|TRUE|on|On|ON");
    static final Pattern FALSE_PATTERN = Pattern.compile("n|N|no|No|NO|false|False|FALSE|off|Off|OFF");
    private static final String RESERVED_URL = "The URL '%s' is reserved and cannot be used.";

    private YamlUtils() {
    }

    static boolean parseBoolean(String value) {
        if (TRUE_PATTERN.matcher(value).matches()) {
            return true;
        }
        if (FALSE_PATTERN.matcher(value).matches()) {
            return false;
        }
        throw new AppEngineConfigException(new StringBuilder(25 + String.valueOf(value).length()).append("Invalid boolean value '").append(value).append("'.").toString());
    }

    static void validateUrl(String url) {
        if (url.equals("/form")) {
            throw new AppEngineConfigException(String.format(RESERVED_URL, url));
        }
    }

    public static Map<String, Object> genericParse(String data) throws AppEngineConfigException {
        try {
            YamlReader reader = new YamlReader(data);
            return (Map)reader.read(Map.class);
        }
        catch (YamlException exc) {
            String string = String.valueOf(data);
            throw new AppEngineConfigException(string.length() != 0 ? "Invalid YAML data: ".concat(string) : new String("Invalid YAML data: "), exc);
        }
    }

    public static <T> Map<String, T> genericParse(String data, ObjectConverter<T> converter) throws AppEngineConfigException {
        try {
            HashMap<String, T> yaml = new HashMap<String, T>();
            for (Map.Entry<String, Object> entry : YamlUtils.genericParse(data).entrySet()) {
                yaml.put(entry.getKey(), converter.convert(entry.getValue()));
            }
            return yaml;
        }
        catch (Exception exc) {
            throw new AppEngineConfigException(exc);
        }
    }

    public static interface ObjectConverter<T> {
        public T convert(Object var1) throws Exception;
    }
}

