/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.inject;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.inject.Provider;

@CheckReturnValue
public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(@Nullable T instance) {
        return new ConstantProvider(instance);
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        @Nullable
        private final T instance;

        private ConstantProvider(@Nullable T instance) {
            this.instance = instance;
        }

        @Nullable
        public T get() {
            return this.instance;
        }

        public String toString() {
            String string = String.valueOf(this.instance);
            return new StringBuilder(14 + String.valueOf(string).length()).append("Providers.of(").append(string).append(")").toString();
        }

        public boolean equals(Object other) {
            if (other instanceof ConstantProvider) {
                ConstantProvider that = (ConstantProvider)other;
                return this.instance == null ? that.instance == null : this.instance.equals(that.instance);
            }
            return false;
        }

        public int hashCode() {
            return this.instance == null ? 37 : this.instance.hashCode();
        }
    }
}

