/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ApiServer;

public class ApiServerFactory {
    private static ApiServer instance;
    private static String pathToApiServer;
    private static String applicationName;

    public static synchronized ApiServer getApiServer(String pathToApiServer, String applicationName, String appDir, String baseUrl) {
        if (instance == null) {
            ApiServerFactory.pathToApiServer = pathToApiServer;
            ApiServerFactory.applicationName = applicationName;
            instance = new ApiServer(pathToApiServer, applicationName, appDir, baseUrl);
            ApiServerFactory.addShutdownHook(instance);
        } else if (!ApiServerFactory.pathToApiServer.equals(pathToApiServer) || !ApiServerFactory.applicationName.equals(applicationName)) {
            String string = ApiServerFactory.pathToApiServer;
            String string2 = ApiServerFactory.applicationName;
            throw new RuntimeException(new StringBuilder(148 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(pathToApiServer).length() + String.valueOf(applicationName).length()).append("An ApiServer has already been provided with path \"").append(string).append("\" and \"application name \"").append(string2).append("\". Cannot provide another ApiServer with path \"").append(pathToApiServer).append("\" and application name \"").append(applicationName).append("\".").toString());
        }
        return instance;
    }

    public static synchronized ApiServer getExistingApiServer() {
        if (instance == null) {
            throw new RuntimeException("There is no current instance of the ApiServer.");
        }
        return instance;
    }

    public static synchronized boolean hasExistingApiServer() {
        return instance != null;
    }

    private static void addShutdownHook(final ApiServer apiServer) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                apiServer.close();
            }
        });
    }
}

