/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AutoValue_AppEngineWebXml_AdminConsolePage;
import com.google.apphosting.utils.config.AutoValue_AppEngineWebXml_ApiConfig;
import com.google.apphosting.utils.config.AutoValue_AppEngineWebXml_ErrorHandler;
import com.google.apphosting.utils.config.AutoValue_AppEngineWebXml_UserPermission;
import com.google.apphosting.utils.config.AutoValue_AppEngineWebXml_VpcAccessConnector;
import com.google.apphosting.utils.config.StagingOptions;
import com.google.auto.value.AutoValue;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class AppEngineWebXml
implements Cloneable {
    private final Map<String, String> systemProperties = Maps.newHashMap();
    private final Map<String, String> betaSettings = Maps.newLinkedHashMap();
    private final Resources resources;
    private final Network network;
    private StagingOptions staging;
    private HealthCheck healthCheck;
    private LivenessCheck livenessCheck;
    private ReadinessCheck readinessCheck;
    private final Map<String, String> envVariables = Maps.newHashMap();
    private final List<UserPermission> userPermissions = new ArrayList<UserPermission>();
    public static final String WARMUP_SERVICE = "warmup";
    public static final String URL_HANDLER_URLFETCH = "urlfetch";
    public static final String URL_HANDLER_NATIVE = "native";
    private static final String JAVA_7_RUNTIME_ID = "java7";
    private static final String JAVA_8_RUNTIME_ID = "java8";
    private static final String JAVA_RUNTIME_ID = "java";
    private String entrypoint;
    private String runtimeChannel;
    private String appId;
    private String majorVersionId;
    private String module;
    private String service;
    private String instanceClass;
    private final AutomaticScaling automaticScaling;
    private final ManualScaling manualScaling;
    private final BasicScaling basicScaling;
    private String runtime;
    private boolean sslEnabled = true;
    private boolean useSessions = false;
    private boolean asyncSessionPersistence = false;
    private String asyncSessionPersistenceQueueName;
    private final List<StaticFileInclude> staticFileIncludes;
    private final List<String> staticFileExcludes;
    private final List<String> resourceFileIncludes;
    private final List<String> resourceFileExcludes;
    private Pattern staticIncludePattern;
    private Pattern staticExcludePattern;
    private Pattern resourceIncludePattern;
    private Pattern resourceExcludePattern;
    private String publicRoot = "";
    private String appRoot;
    private final Set<String> inboundServices;
    private boolean precompilationEnabled = true;
    private final List<AdminConsolePage> adminConsolePages = new ArrayList<AdminConsolePage>();
    private final List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();
    private ClassLoaderConfig classLoaderConfig;
    private VpcAccessConnector vpcAccessConnector;
    private String urlStreamHandlerType = null;
    private boolean threadsafe = false;
    private boolean threadsafeValueProvided = false;
    private String autoIdPolicy;
    private boolean codeLock = false;
    private boolean useVm = false;
    private String env = "standard";
    private ApiConfig apiConfig;
    private final List<String> apiEndpointIds;
    private UseGoogleConnectorJ useGoogleConnectorJ = UseGoogleConnectorJ.NOT_STATED_BY_USER;

    public AppEngineWebXml() {
        this.automaticScaling = new AutomaticScaling();
        this.manualScaling = new ManualScaling();
        this.basicScaling = new BasicScaling();
        this.resources = new Resources();
        this.network = new Network();
        this.staging = StagingOptions.EMPTY;
        this.staticFileIncludes = new ArrayList<StaticFileInclude>();
        this.staticFileExcludes = new ArrayList<String>();
        this.staticFileExcludes.add("WEB-INF/**");
        this.staticFileExcludes.add("**.jsp");
        this.resourceFileIncludes = new ArrayList<String>();
        this.resourceFileExcludes = new ArrayList<String>();
        this.inboundServices = new LinkedHashSet<String>();
        this.apiEndpointIds = new ArrayList<String>();
    }

    public AppEngineWebXml clone() {
        try {
            return (AppEngineWebXml)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Could not clone AppEngineWebXml", ce);
        }
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public void addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    public Map<String, String> getBetaSettings() {
        return Collections.unmodifiableMap(this.betaSettings);
    }

    public void addBetaSetting(String key, String value) {
        this.betaSettings.put(key, value);
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setLivenessCheck(LivenessCheck livenessCheck) {
        this.livenessCheck = livenessCheck;
    }

    public LivenessCheck getLivenessCheck() {
        return this.livenessCheck;
    }

    public void setReadinessCheck(ReadinessCheck readinessCheck) {
        this.readinessCheck = readinessCheck;
    }

    public ReadinessCheck getReadinessCheck() {
        return this.readinessCheck;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Network getNetwork() {
        return this.network;
    }

    public StagingOptions getStagingOptions() {
        return this.staging;
    }

    public void setStagingOptions(StagingOptions opts) {
        this.staging = opts;
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.envVariables);
    }

    public void addEnvironmentVariable(String key, String value) {
        this.envVariables.put(key, value);
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
    }

    public String getRuntimeChannel() {
        return this.runtimeChannel;
    }

    public void setRuntimeChannel(String runtimeChannel) {
        this.runtimeChannel = runtimeChannel;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMajorVersionId() {
        return this.majorVersionId;
    }

    public void setMajorVersionId(String majorVersionId) {
        this.majorVersionId = majorVersionId;
    }

    public String getRuntime() {
        if (this.runtime != null) {
            return this.runtime;
        }
        this.runtime = this.isFlexible() ? JAVA_RUNTIME_ID : JAVA_7_RUNTIME_ID;
        return this.runtime;
    }

    public boolean isWebXmlRequired() {
        return !this.getRuntime().startsWith(JAVA_8_RUNTIME_ID);
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getModule() {
        return this.module;
    }

    public String getService() {
        return this.service;
    }

    public void setInstanceClass(String instanceClass) {
        this.instanceClass = AppEngineWebXml.toNullIfEmptyOrWhitespace(instanceClass);
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public AutomaticScaling getAutomaticScaling() {
        return this.automaticScaling;
    }

    public ManualScaling getManualScaling() {
        return this.manualScaling;
    }

    public BasicScaling getBasicScaling() {
        return this.basicScaling;
    }

    public ScalingType getScalingType() {
        if (!this.getBasicScaling().isEmpty()) {
            return ScalingType.BASIC;
        }
        if (!this.getManualScaling().isEmpty()) {
            return ScalingType.MANUAL;
        }
        return ScalingType.AUTOMATIC;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setSslEnabled(boolean ssl) {
        this.sslEnabled = ssl;
    }

    public boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSessionsEnabled(boolean sessions) {
        this.useSessions = sessions;
    }

    public boolean getSessionsEnabled() {
        return this.useSessions;
    }

    public void setAsyncSessionPersistence(boolean asyncSessionPersistence) {
        this.asyncSessionPersistence = asyncSessionPersistence;
    }

    public boolean getAsyncSessionPersistence() {
        return this.asyncSessionPersistence;
    }

    public void setAsyncSessionPersistenceQueueName(String asyncSessionPersistenceQueueName) {
        this.asyncSessionPersistenceQueueName = asyncSessionPersistenceQueueName;
    }

    public String getAsyncSessionPersistenceQueueName() {
        return this.asyncSessionPersistenceQueueName;
    }

    public List<StaticFileInclude> getStaticFileIncludes() {
        return this.staticFileIncludes;
    }

    public List<String> getStaticFileExcludes() {
        return this.staticFileExcludes;
    }

    public StaticFileInclude includeStaticPattern(String pattern, String expiration) {
        this.staticIncludePattern = null;
        StaticFileInclude staticFileInclude = new StaticFileInclude(pattern, expiration);
        this.staticFileIncludes.add(staticFileInclude);
        return staticFileInclude;
    }

    public void excludeStaticPattern(String url) {
        this.staticExcludePattern = null;
        this.staticFileExcludes.add(url);
    }

    public List<String> getResourcePatterns() {
        return this.resourceFileIncludes;
    }

    public List<String> getResourceFileExcludes() {
        return this.resourceFileExcludes;
    }

    public void includeResourcePattern(String url) {
        this.resourceExcludePattern = null;
        this.resourceFileIncludes.add(url);
    }

    public void excludeResourcePattern(String url) {
        this.resourceIncludePattern = null;
        this.resourceFileExcludes.add(url);
    }

    public void addUserPermission(String className, String name, String actions) {
        if (className.startsWith("java.")) {
            throw new AppEngineConfigException("Cannot specify user-permissions for classes in java.* packages.");
        }
        this.userPermissions.add(UserPermission.of(className, name, actions));
    }

    public Permissions getUserPermissions() {
        Permissions permissions = new Permissions();
        for (UserPermission permission : this.userPermissions) {
            permissions.add(new UnresolvedPermission(permission.getClassName(), permission.getName(), permission.getActions(), null));
        }
        permissions.setReadOnly();
        return permissions;
    }

    public void setPublicRoot(String root) {
        if (root.indexOf(42) != -1) {
            throw new AppEngineConfigException("public-root cannot contain wildcards");
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        if (root.length() > 0 && !root.startsWith("/")) {
            String string = String.valueOf(root);
            root = string.length() != 0 ? "/".concat(string) : new String("/");
        }
        this.staticIncludePattern = null;
        this.publicRoot = root;
    }

    public String getPublicRoot() {
        return this.publicRoot;
    }

    public void addInboundService(String service) {
        this.inboundServices.add(service);
    }

    public Set<String> getInboundServices() {
        return this.inboundServices;
    }

    public boolean getPrecompilationEnabled() {
        return this.precompilationEnabled;
    }

    public void setPrecompilationEnabled(boolean precompilationEnabled) {
        this.precompilationEnabled = precompilationEnabled;
    }

    public boolean getWarmupRequestsEnabled() {
        return this.inboundServices.contains(WARMUP_SERVICE);
    }

    public void setWarmupRequestsEnabled(boolean warmupRequestsEnabled) {
        if (warmupRequestsEnabled) {
            this.inboundServices.add(WARMUP_SERVICE);
        } else {
            this.inboundServices.remove(WARMUP_SERVICE);
        }
    }

    public List<AdminConsolePage> getAdminConsolePages() {
        return Collections.unmodifiableList(this.adminConsolePages);
    }

    public void addAdminConsolePage(AdminConsolePage page) {
        this.adminConsolePages.add(page);
    }

    public List<ErrorHandler> getErrorHandlers() {
        return Collections.unmodifiableList(this.errorHandlers);
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    public boolean getThreadsafe() {
        return this.threadsafe;
    }

    public boolean getThreadsafeValueProvided() {
        return this.threadsafeValueProvided;
    }

    public void setThreadsafe(boolean threadsafe) {
        this.threadsafe = threadsafe;
        this.threadsafeValueProvided = true;
    }

    public void setAutoIdPolicy(String policy) {
        this.autoIdPolicy = policy;
    }

    public String getAutoIdPolicy() {
        return this.autoIdPolicy;
    }

    public boolean getCodeLock() {
        return this.codeLock;
    }

    public void setCodeLock(boolean codeLock) {
        this.codeLock = codeLock;
    }

    public void setUseVm(boolean useVm) {
        this.useVm = useVm;
    }

    public boolean getUseVm() {
        return this.useVm;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnv() {
        return this.env;
    }

    public boolean isFlexible() {
        return "flex".equalsIgnoreCase(this.env) || "2".equals(this.env) || "flexible".equalsIgnoreCase(this.env);
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public void setApiConfig(ApiConfig config) {
        this.apiConfig = config;
    }

    public ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClassLoaderConfig classLoaderConfig) {
        if (this.classLoaderConfig != null) {
            throw new AppEngineConfigException("class-loader-config may only be specified once.");
        }
        this.classLoaderConfig = classLoaderConfig;
    }

    public VpcAccessConnector getVpcAccessConnector() {
        return this.vpcAccessConnector;
    }

    public void setVpcAccessConnector(VpcAccessConnector vpcAccessConnector) {
        if (this.vpcAccessConnector != null) {
            throw new AppEngineConfigException("vpc-access-connector may only be specified once.");
        }
        this.vpcAccessConnector = vpcAccessConnector;
    }

    public String getUrlStreamHandlerType() {
        return this.urlStreamHandlerType;
    }

    public void setUrlStreamHandlerType(String urlStreamHandlerType) {
        if (this.classLoaderConfig != null) {
            throw new AppEngineConfigException("url-stream-handler may only be specified once.");
        }
        if (!URL_HANDLER_URLFETCH.equals(urlStreamHandlerType) && !URL_HANDLER_NATIVE.equals(urlStreamHandlerType)) {
            String string = String.valueOf("url-stream-handler must be urlfetch or native given ");
            String string2 = String.valueOf(urlStreamHandlerType);
            throw new AppEngineConfigException(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        this.urlStreamHandlerType = urlStreamHandlerType;
    }

    public boolean isApiEndpoint(String id) {
        return this.apiEndpointIds.contains(id);
    }

    public void addApiEndpoint(String id) {
        this.apiEndpointIds.add(id);
    }

    public void setUseGoogleConnectorJ(boolean useGoogleConnectorJ) {
        this.useGoogleConnectorJ = useGoogleConnectorJ ? UseGoogleConnectorJ.TRUE : UseGoogleConnectorJ.FALSE;
    }

    public UseGoogleConnectorJ getUseGoogleConnectorJ() {
        return this.useGoogleConnectorJ;
    }

    public String toString() {
        String string = String.valueOf(this.systemProperties);
        String string2 = String.valueOf(this.envVariables);
        String string3 = String.valueOf(this.userPermissions);
        String string4 = this.appId;
        String string5 = this.majorVersionId;
        String string6 = this.runtime;
        String string7 = this.service;
        String string8 = this.instanceClass;
        String string9 = String.valueOf(this.automaticScaling);
        String string10 = String.valueOf(this.manualScaling);
        String string11 = String.valueOf(this.basicScaling);
        String string12 = String.valueOf(this.healthCheck);
        String string13 = String.valueOf(this.livenessCheck);
        String string14 = String.valueOf(this.readinessCheck);
        String string15 = String.valueOf(this.resources);
        String string16 = String.valueOf(this.network);
        boolean bl = this.sslEnabled;
        boolean bl2 = this.useSessions;
        boolean bl3 = this.asyncSessionPersistence;
        String string17 = this.asyncSessionPersistenceQueueName;
        String string18 = String.valueOf(this.staticFileIncludes);
        String string19 = String.valueOf(this.staticFileExcludes);
        String string20 = String.valueOf(this.resourceFileIncludes);
        String string21 = String.valueOf(this.resourceFileExcludes);
        String string22 = String.valueOf(this.staticIncludePattern);
        String string23 = String.valueOf(this.staticExcludePattern);
        String string24 = String.valueOf(this.resourceIncludePattern);
        String string25 = String.valueOf(this.resourceExcludePattern);
        String string26 = this.publicRoot;
        String string27 = this.appRoot;
        String string28 = String.valueOf(this.inboundServices);
        boolean bl4 = this.precompilationEnabled;
        String string29 = String.valueOf(this.adminConsolePages);
        String string30 = String.valueOf(this.errorHandlers);
        boolean bl5 = this.threadsafe;
        boolean bl6 = this.threadsafeValueProvided;
        String string31 = this.autoIdPolicy;
        boolean bl7 = this.codeLock;
        String string32 = String.valueOf(this.apiConfig);
        String string33 = String.valueOf(this.apiEndpointIds);
        String string34 = String.valueOf(this.classLoaderConfig);
        String string35 = this.urlStreamHandlerType == null ? URL_HANDLER_URLFETCH : this.urlStreamHandlerType;
        String string36 = String.valueOf((Object)this.useGoogleConnectorJ);
        String string37 = String.valueOf(this.vpcAccessConnector);
        String string38 = this.entrypoint;
        String string39 = this.runtimeChannel;
        return new StringBuilder(880 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string9).length() + String.valueOf(string10).length() + String.valueOf(string11).length() + String.valueOf(string12).length() + String.valueOf(string13).length() + String.valueOf(string14).length() + String.valueOf(string15).length() + String.valueOf(string16).length() + String.valueOf(string17).length() + String.valueOf(string18).length() + String.valueOf(string19).length() + String.valueOf(string20).length() + String.valueOf(string21).length() + String.valueOf(string22).length() + String.valueOf(string23).length() + String.valueOf(string24).length() + String.valueOf(string25).length() + String.valueOf(string26).length() + String.valueOf(string27).length() + String.valueOf(string28).length() + String.valueOf(string29).length() + String.valueOf(string30).length() + String.valueOf(string31).length() + String.valueOf(string32).length() + String.valueOf(string33).length() + String.valueOf(string34).length() + String.valueOf(string35).length() + String.valueOf(string36).length() + String.valueOf(string37).length() + String.valueOf(string38).length() + String.valueOf(string39).length()).append("AppEngineWebXml{systemProperties=").append(string).append(", envVariables=").append(string2).append(", userPermissions=").append(string3).append(", appId='").append(string4).append('\'').append(", majorVersionId='").append(string5).append('\'').append(", runtime='").append(string6).append('\'').append(", service='").append(string7).append('\'').append(", instanceClass='").append(string8).append('\'').append(", automaticScaling=").append(string9).append(", manualScaling=").append(string10).append(", basicScaling=").append(string11).append(", healthCheck=").append(string12).append(", livenesCheck=").append(string13).append(", readinessCheck=").append(string14).append(", resources=").append(string15).append(", network=").append(string16).append(", sslEnabled=").append(bl).append(", useSessions=").append(bl2).append(", asyncSessionPersistence=").append(bl3).append(", asyncSessionPersistenceQueueName='").append(string17).append('\'').append(", staticFileIncludes=").append(string18).append(", staticFileExcludes=").append(string19).append(", resourceFileIncludes=").append(string20).append(", resourceFileExcludes=").append(string21).append(", staticIncludePattern=").append(string22).append(", staticExcludePattern=").append(string23).append(", resourceIncludePattern=").append(string24).append(", resourceExcludePattern=").append(string25).append(", publicRoot='").append(string26).append('\'').append(", appRoot='").append(string27).append('\'').append(", inboundServices=").append(string28).append(", precompilationEnabled=").append(bl4).append(", adminConsolePages=").append(string29).append(", errorHandlers=").append(string30).append(", threadsafe=").append(bl5).append(", threadsafeValueProvided=").append(bl6).append(", autoIdPolicy=").append(string31).append(", codeLock=").append(bl7).append(", apiConfig=").append(string32).append(", apiEndpointIds=").append(string33).append(", classLoaderConfig=").append(string34).append(", urlStreamHandlerType=").append(string35).append(", useGoogleConnectorJ=").append(string36).append(", vpcAccessConnector=").append(string37).append(", entrypoint=").append(string38).append(", runtimeChannel=").append(string39).append('}').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEngineWebXml that = (AppEngineWebXml)o;
        return this.asyncSessionPersistence == that.asyncSessionPersistence && this.precompilationEnabled == that.precompilationEnabled && this.sslEnabled == that.sslEnabled && this.threadsafe == that.threadsafe && this.threadsafeValueProvided == that.threadsafeValueProvided && Objects.equals(this.autoIdPolicy, that.autoIdPolicy) && this.codeLock == that.codeLock && this.useSessions == that.useSessions && Objects.equals(this.adminConsolePages, that.adminConsolePages) && Objects.equals(this.appId, that.appId) && Objects.equals(this.entrypoint, that.entrypoint) && Objects.equals(this.runtimeChannel, that.runtimeChannel) && Objects.equals(this.majorVersionId, that.majorVersionId) && Objects.equals(this.service, that.service) && Objects.equals(this.instanceClass, that.instanceClass) && this.automaticScaling.equals(that.automaticScaling) && this.manualScaling.equals(that.manualScaling) && this.basicScaling.equals(that.basicScaling) && Objects.equals(this.appRoot, that.appRoot) && Objects.equals(this.asyncSessionPersistenceQueueName, that.asyncSessionPersistenceQueueName) && Objects.equals(this.envVariables, that.envVariables) && Objects.equals(this.errorHandlers, that.errorHandlers) && Objects.equals(this.inboundServices, that.inboundServices) && Objects.equals(this.majorVersionId, that.majorVersionId) && Objects.equals(this.runtime, that.runtime) && Objects.equals(this.publicRoot, that.publicRoot) && Objects.equals(this.resourceExcludePattern, that.resourceExcludePattern) && Objects.equals(this.resourceFileExcludes, that.resourceFileExcludes) && Objects.equals(this.resourceFileIncludes, that.resourceFileIncludes) && Objects.equals(this.resourceIncludePattern, that.resourceIncludePattern) && Objects.equals(this.staticExcludePattern, that.staticExcludePattern) && Objects.equals(this.staticFileExcludes, that.staticFileExcludes) && Objects.equals(this.staticFileIncludes, that.staticFileIncludes) && Objects.equals(this.staticIncludePattern, that.staticIncludePattern) && Objects.equals(this.systemProperties, that.systemProperties) && Objects.equals(this.betaSettings, that.betaSettings) && Objects.equals(this.healthCheck, that.healthCheck) && Objects.equals(this.livenessCheck, that.livenessCheck) && Objects.equals(this.readinessCheck, that.readinessCheck) && Objects.equals(this.resources, that.resources) && Objects.equals(this.network, that.network) && Objects.equals(this.userPermissions, that.userPermissions) && Objects.equals(this.apiConfig, that.apiConfig) && Objects.equals(this.apiEndpointIds, that.apiEndpointIds) && Objects.equals(this.classLoaderConfig, that.classLoaderConfig) && Objects.equals(this.vpcAccessConnector, that.vpcAccessConnector) && Objects.equals(this.urlStreamHandlerType, that.urlStreamHandlerType) && this.useGoogleConnectorJ == that.useGoogleConnectorJ;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.systemProperties, this.envVariables, this.userPermissions, this.appId, this.majorVersionId, this.runtime, this.service, this.instanceClass, this.automaticScaling, this.manualScaling, this.basicScaling, this.sslEnabled, this.useSessions, this.asyncSessionPersistence, this.asyncSessionPersistenceQueueName, this.staticFileIncludes, this.staticFileExcludes, this.resourceFileIncludes, this.resourceFileExcludes, this.staticIncludePattern, this.staticExcludePattern, this.resourceIncludePattern, this.resourceExcludePattern, this.publicRoot, this.appRoot, this.inboundServices, this.precompilationEnabled, this.adminConsolePages, this.errorHandlers, this.threadsafe, this.autoIdPolicy, this.threadsafeValueProvided, this.codeLock, this.apiConfig, this.apiEndpointIds, this.classLoaderConfig, this.vpcAccessConnector, this.urlStreamHandlerType, this.useGoogleConnectorJ, this.betaSettings, this.healthCheck, this.livenessCheck, this.readinessCheck, this.resources, this.network, this.entrypoint, this.runtimeChannel});
    }

    public boolean includesResource(String path) {
        if (this.resourceIncludePattern == null) {
            this.resourceIncludePattern = this.resourceFileIncludes.size() == 0 ? Pattern.compile(".*") : Pattern.compile(this.makeRegexp(this.resourceFileIncludes));
        }
        if (this.resourceExcludePattern == null && this.resourceFileExcludes.size() > 0) {
            this.resourceExcludePattern = Pattern.compile(this.makeRegexp(this.resourceFileExcludes));
        }
        return this.includes(path, this.resourceIncludePattern, this.resourceExcludePattern);
    }

    public boolean includesStatic(String path) {
        if (this.staticIncludePattern == null) {
            if (this.staticFileIncludes.size() == 0) {
                String staticRoot = this.publicRoot.length() > 0 ? String.valueOf(this.publicRoot).concat("/**") : "**";
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(Collections.singletonList(staticRoot)));
            } else {
                ArrayList<String> patterns = new ArrayList<String>();
                for (StaticFileInclude include : this.staticFileIncludes) {
                    patterns.add(include.getPattern());
                }
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(patterns));
            }
        }
        if (this.staticExcludePattern == null && this.staticFileExcludes.size() > 0) {
            this.staticExcludePattern = Pattern.compile(this.makeRegexp(this.staticFileExcludes));
        }
        return this.includes(path, this.staticIncludePattern, this.staticExcludePattern);
    }

    public boolean includes(String path, Pattern includes, Pattern excludes) {
        assert (includes != null);
        if (!includes.matcher(path).matches()) {
            return false;
        }
        return excludes == null || !excludes.matcher(path).matches();
    }

    public String makeRegexp(List<String> patterns) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : patterns) {
            if (first) {
                first = false;
            } else {
                builder.append('|');
            }
            while (item.charAt(0) == '/') {
                item = item.substring(1);
            }
            builder.append('(');
            if (this.appRoot != null) {
                builder.append(AppEngineWebXml.makeFileRegex(this.appRoot));
            }
            builder.append("/");
            builder.append(AppEngineWebXml.makeFileRegex(item));
            builder.append(')');
        }
        return builder.toString();
    }

    static String makeFileRegex(String fileGlob) {
        fileGlob = fileGlob.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        fileGlob = fileGlob.replaceAll("\\\\\\*\\\\\\*", ".*");
        fileGlob = fileGlob.replaceAll("\\\\\\*", "[^/]*");
        return fileGlob;
    }

    public void setSourcePrefix(String appRoot) {
        this.appRoot = appRoot;
        this.resourceIncludePattern = null;
        this.resourceExcludePattern = null;
        this.staticIncludePattern = null;
        this.staticExcludePattern = null;
    }

    public String getSourcePrefix() {
        return this.appRoot;
    }

    private static String toNullIfEmptyOrWhitespace(String string) {
        if (string == null || CharMatcher.whitespace().matchesAllOf(string)) {
            return null;
        }
        return string;
    }

    public static class PrioritySpecifierEntry {
        private String filename;
        private Double priority;

        private void checkNotAlreadySet() {
            if (this.filename != null) {
                throw new AppEngineConfigException("Found more that one file name matching tag. Only one of 'filename' attribute allowed.");
            }
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.checkNotAlreadySet();
            this.filename = filename;
        }

        public Double getPriority() {
            return this.priority;
        }

        public double getPriorityValue() {
            if (this.priority == null) {
                return 1.0;
            }
            return this.priority;
        }

        public void setPriority(String priority) {
            if (this.priority != null) {
                throw new AppEngineConfigException("The 'priority' tag may only be specified once.");
            }
            if (priority == null) {
                this.priority = null;
                return;
            }
            this.priority = Double.parseDouble(priority);
        }

        public void checkClassLoaderConfig() {
            if (this.filename == null) {
                throw new AppEngineConfigException("Must have a filename attribute.");
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrioritySpecifierEntry other = (PrioritySpecifierEntry)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return !(this.priority == null ? other.priority != null : !this.priority.equals(other.priority));
        }

        public String toString() {
            String string = this.filename;
            String string2 = String.valueOf(this.priority);
            return new StringBuilder(48 + String.valueOf(string).length() + String.valueOf(string2).length()).append("PrioritySpecifierEntry{filename=\"").append(string).append("\", priority=\"").append(string2).append("\"}").toString();
        }
    }

    public static class ClassLoaderConfig {
        private final List<PrioritySpecifierEntry> entries = Lists.newArrayList();

        public void add(PrioritySpecifierEntry entry) {
            this.entries.add(entry);
        }

        public List<PrioritySpecifierEntry> getEntries() {
            return this.entries;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLoaderConfig other = (ClassLoaderConfig)obj;
            return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
        }

        public String toString() {
            String string = String.valueOf(this.entries);
            return new StringBuilder(29 + String.valueOf(string).length()).append("ClassLoaderConfig{entries=\"").append(string).append("\"}").toString();
        }
    }

    public static class BasicScaling {
        private static final BasicScaling EMPTY_SETTINGS = new BasicScaling();
        private String maxInstances;
        private String idleTimeout;

        public String getMaxInstances() {
            return this.maxInstances;
        }

        public String getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setMaxInstances(String maxInstances) {
            this.maxInstances = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxInstances);
        }

        public void setIdleTimeout(String idleTimeout) {
            this.idleTimeout = AppEngineWebXml.toNullIfEmptyOrWhitespace(idleTimeout);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.maxInstances, this.idleTimeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasicScaling other = (BasicScaling)obj;
            return Objects.equals(this.maxInstances, other.maxInstances) && Objects.equals(this.idleTimeout, other.idleTimeout);
        }

        public String toString() {
            String string = this.maxInstances;
            String string2 = this.idleTimeout;
            return new StringBuilder(42 + String.valueOf(string).length() + String.valueOf(string2).length()).append("BasicScaling [maxInstances=").append(string).append(", idleTimeout=").append(string2).append("]").toString();
        }
    }

    public static class ManualScaling {
        private static final ManualScaling EMPTY_SETTINGS = new ManualScaling();
        private String instances;

        public String getInstances() {
            return this.instances;
        }

        public void setInstances(String instances) {
            this.instances = AppEngineWebXml.toNullIfEmptyOrWhitespace(instances);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.instances);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ManualScaling other = (ManualScaling)obj;
            return Objects.equals(this.instances, other.instances);
        }

        public String toString() {
            String string = this.instances;
            return new StringBuilder(26 + String.valueOf(string).length()).append("ManualScaling [instances=").append(string).append("]").toString();
        }
    }

    public static class Network {
        private static final Network EMPTY_SETTINGS = new Network();
        private String name;
        private String instanceTag;
        private boolean sessionAffinity;
        private String subnetworkName;
        private final List<String> forwardedPorts = Lists.newArrayList();

        public String getInstanceTag() {
            return this.instanceTag;
        }

        public void setInstanceTag(String instanceTag) {
            this.instanceTag = instanceTag;
        }

        public List<String> getForwardedPorts() {
            return Collections.unmodifiableList(this.forwardedPorts);
        }

        public void addForwardedPort(String forwardedPort) {
            this.forwardedPorts.add(forwardedPort);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSubnetworkName() {
            return this.subnetworkName;
        }

        public void setSubnetworkName(String subnetworkName) {
            this.subnetworkName = subnetworkName;
        }

        public boolean getSessionAffinity() {
            return this.sessionAffinity;
        }

        public void setSessionAffinity(boolean sessionAffinity) {
            this.sessionAffinity = sessionAffinity;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.forwardedPorts, this.instanceTag, this.name, this.subnetworkName, this.sessionAffinity);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Network other = (Network)obj;
            return Objects.equals(this.forwardedPorts, other.forwardedPorts) && Objects.equals(this.instanceTag, other.instanceTag) && Objects.equals(this.name, other.name) && Objects.equals(this.subnetworkName, other.subnetworkName) && Objects.equals(this.sessionAffinity, other.sessionAffinity);
        }

        public String toString() {
            String string = String.valueOf(this.forwardedPorts);
            String string2 = this.instanceTag;
            String string3 = this.name;
            String string4 = this.subnetworkName;
            boolean bl = this.sessionAffinity;
            return new StringBuilder(86 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Network [forwardedPorts=").append(string).append(", instanceTag=").append(string2).append(", name=").append(string3).append(", subnetworkName=").append(string4).append(", sessionAffinity=").append(bl).append("]").toString();
        }
    }

    public static class Resources {
        private static final Resources EMPTY_SETTINGS = new Resources();
        private double cpu;
        private double memory_gb;
        private int disk_size_gb;

        public double getCpu() {
            return this.cpu;
        }

        public void setCpu(double cpu) {
            this.cpu = cpu;
        }

        public double getMemoryGb() {
            return this.memory_gb;
        }

        public void setMemoryGb(double memory_gb) {
            this.memory_gb = memory_gb;
        }

        public int getDiskSizeGb() {
            return this.disk_size_gb;
        }

        public void setDiskSizeGb(int disk_size_gb) {
            this.disk_size_gb = disk_size_gb;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.cpu, this.memory_gb, this.disk_size_gb);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resources other = (Resources)obj;
            return Objects.equals(this.cpu, other.cpu) && Objects.equals(this.memory_gb, other.memory_gb) && Objects.equals(this.disk_size_gb, other.disk_size_gb);
        }

        public String toString() {
            double d = this.cpu;
            double d2 = this.memory_gb;
            int n = this.disk_size_gb;
            return new StringBuilder(102).append("Resources [cpu=").append(d).append(", memory_gb=").append(d2).append(", disk_size_gb=").append(n).append("]").toString();
        }
    }

    public static class ReadinessCheck {
        private static final ReadinessCheck EMPTY_SETTINGS = new ReadinessCheck();
        private String path;
        private Integer checkIntervalSec;
        private Integer timeoutSec;
        private Integer failureThreshold;
        private Integer successThreshold;
        private Integer appStartTimeoutSec;
        private String host;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = AppEngineWebXml.toNullIfEmptyOrWhitespace(path);
        }

        public Integer getCheckIntervalSec() {
            return this.checkIntervalSec;
        }

        public void setCheckIntervalSec(Integer checkIntervalSec) {
            this.checkIntervalSec = checkIntervalSec;
        }

        public Integer getTimeoutSec() {
            return this.timeoutSec;
        }

        public void setTimeoutSec(Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
        }

        public Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        public void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        public Integer getSuccessThreshold() {
            return this.successThreshold;
        }

        public void setSuccessThreshold(Integer successThreshold) {
            this.successThreshold = successThreshold;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = AppEngineWebXml.toNullIfEmptyOrWhitespace(host);
        }

        public Integer getAppStartTimeoutSec() {
            return this.appStartTimeoutSec;
        }

        public void setAppStartTimeoutSec(Integer appStartTimeoutSec) {
            this.appStartTimeoutSec = appStartTimeoutSec;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.checkIntervalSec, this.timeoutSec, this.failureThreshold, this.successThreshold, this.appStartTimeoutSec, this.host);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReadinessCheck other = (ReadinessCheck)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.checkIntervalSec, other.checkIntervalSec) && Objects.equals(this.timeoutSec, other.timeoutSec) && Objects.equals(this.failureThreshold, other.failureThreshold) && Objects.equals(this.successThreshold, other.successThreshold) && Objects.equals(this.appStartTimeoutSec, other.appStartTimeoutSec) && Objects.equals(this.host, other.host);
        }

        public String toString() {
            String string = this.path;
            String string2 = String.valueOf(this.checkIntervalSec);
            String string3 = String.valueOf(this.timeoutSec);
            String string4 = String.valueOf(this.failureThreshold);
            String string5 = String.valueOf(this.successThreshold);
            String string6 = String.valueOf(this.appStartTimeoutSec);
            String string7 = this.host;
            return new StringBuilder(120 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append("ReadinessCheck [path=").append(string).append(", checkIntervalSec=").append(string2).append(", timeoutSec=").append(string3).append(", failureThreshold=").append(string4).append(", successThreshold=").append(string5).append(", appStartTimeoutSec=").append(string6).append(", host=").append(string7).append("]").toString();
        }
    }

    public static class LivenessCheck {
        private static final LivenessCheck EMPTY_SETTINGS = new LivenessCheck();
        private String path;
        private Integer checkIntervalSec;
        private Integer timeoutSec;
        private Integer failureThreshold;
        private Integer successThreshold;
        private Integer initialDelaySec;
        private String host;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = AppEngineWebXml.toNullIfEmptyOrWhitespace(path);
        }

        public Integer getCheckIntervalSec() {
            return this.checkIntervalSec;
        }

        public void setCheckIntervalSec(Integer checkIntervalSec) {
            this.checkIntervalSec = checkIntervalSec;
        }

        public Integer getTimeoutSec() {
            return this.timeoutSec;
        }

        public void setTimeoutSec(Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
        }

        public Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        public void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        public Integer getSuccessThreshold() {
            return this.successThreshold;
        }

        public void setSuccessThreshold(Integer successThreshold) {
            this.successThreshold = successThreshold;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = AppEngineWebXml.toNullIfEmptyOrWhitespace(host);
        }

        public Integer getInitialDelaySec() {
            return this.initialDelaySec;
        }

        public void setInitialDelaySec(Integer initialDelaySec) {
            this.initialDelaySec = initialDelaySec;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.checkIntervalSec, this.timeoutSec, this.failureThreshold, this.successThreshold, this.initialDelaySec, this.host);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LivenessCheck other = (LivenessCheck)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.checkIntervalSec, other.checkIntervalSec) && Objects.equals(this.timeoutSec, other.timeoutSec) && Objects.equals(this.failureThreshold, other.failureThreshold) && Objects.equals(this.successThreshold, other.successThreshold) && Objects.equals(this.initialDelaySec, other.initialDelaySec) && Objects.equals(this.host, other.host);
        }

        public String toString() {
            String string = this.path;
            String string2 = String.valueOf(this.checkIntervalSec);
            String string3 = String.valueOf(this.timeoutSec);
            String string4 = String.valueOf(this.failureThreshold);
            String string5 = String.valueOf(this.successThreshold);
            String string6 = String.valueOf(this.initialDelaySec);
            String string7 = this.host;
            return new StringBuilder(116 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append("LivenessCheck [path=").append(string).append(", checkIntervalSec=").append(string2).append(", timeoutSec=").append(string3).append(", failureThreshold=").append(string4).append(", successThreshold=").append(string5).append(", initialDelaySec=").append(string6).append(", host=").append(string7).append("]").toString();
        }
    }

    public static class HealthCheck {
        private static final HealthCheck EMPTY_SETTINGS = new HealthCheck();
        private boolean enableHealthCheck = true;
        private Integer checkIntervalSec;
        private Integer timeoutSec;
        private Integer unhealthyThreshold;
        private Integer healthyThreshold;
        private Integer restartThreshold;
        private String host;

        public boolean getEnableHealthCheck() {
            return this.enableHealthCheck;
        }

        public void setEnableHealthCheck(boolean enableHealthCheck) {
            this.enableHealthCheck = enableHealthCheck;
        }

        public Integer getCheckIntervalSec() {
            return this.checkIntervalSec;
        }

        public void setCheckIntervalSec(Integer checkIntervalSec) {
            this.checkIntervalSec = checkIntervalSec;
        }

        public Integer getTimeoutSec() {
            return this.timeoutSec;
        }

        public void setTimeoutSec(Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
        }

        public Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public Integer getRestartThreshold() {
            return this.restartThreshold;
        }

        public void setRestartThreshold(Integer restartThreshold) {
            this.restartThreshold = restartThreshold;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = AppEngineWebXml.toNullIfEmptyOrWhitespace(host);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.enableHealthCheck, this.checkIntervalSec, this.timeoutSec, this.unhealthyThreshold, this.healthyThreshold, this.restartThreshold, this.host);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HealthCheck other = (HealthCheck)obj;
            return Objects.equals(this.enableHealthCheck, other.enableHealthCheck) && Objects.equals(this.checkIntervalSec, other.checkIntervalSec) && Objects.equals(this.timeoutSec, other.timeoutSec) && Objects.equals(this.unhealthyThreshold, other.unhealthyThreshold) && Objects.equals(this.healthyThreshold, other.healthyThreshold) && Objects.equals(this.restartThreshold, other.restartThreshold) && Objects.equals(this.host, other.host);
        }

        public String toString() {
            boolean bl = this.enableHealthCheck;
            String string = String.valueOf(this.checkIntervalSec);
            String string2 = String.valueOf(this.timeoutSec);
            String string3 = String.valueOf(this.unhealthyThreshold);
            String string4 = String.valueOf(this.healthyThreshold);
            String string5 = String.valueOf(this.restartThreshold);
            String string6 = this.host;
            return new StringBuilder(135 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("HealthCheck [enableHealthCheck=").append(bl).append(", checkIntervalSec=").append(string).append(", timeoutSec=").append(string2).append(", unhealthyThreshold=").append(string3).append(", healthyThreshold=").append(string4).append(", restartThreshold=").append(string5).append(", host=").append(string6).append("]").toString();
        }
    }

    public static class CustomMetricUtilization {
        private static final CustomMetricUtilization EMPTY_SETTINGS = new CustomMetricUtilization();
        private String metricName;
        private String targetType;
        private Double targetUtilization;
        private Double singleInstanceAssignment;
        private String filter;

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public void setTargetUtilization(Double targetUtilization) {
            this.targetUtilization = targetUtilization;
        }

        public Double getTargetUtilization() {
            return this.targetUtilization;
        }

        public void setSingleInstanceAssignment(Double singleInstanceAssignment) {
            this.singleInstanceAssignment = singleInstanceAssignment;
        }

        public Double getSingleInstanceAssignment() {
            return this.singleInstanceAssignment;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public int hashCode() {
            return Objects.hash(this.metricName, this.targetType, this.targetUtilization, this.singleInstanceAssignment, this.filter);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomMetricUtilization other = (CustomMetricUtilization)obj;
            return Objects.equals(this.metricName, other.metricName) && Objects.equals(this.targetType, other.targetType) && Objects.equals(this.targetUtilization, other.targetUtilization) && Objects.equals(this.singleInstanceAssignment, other.singleInstanceAssignment) && Objects.equals(this.filter, other.filter);
        }

        public String toString() {
            String string = this.metricName;
            String string2 = this.targetType;
            String string3 = String.valueOf(this.targetUtilization);
            String string4 = String.valueOf(this.singleInstanceAssignment);
            String string5 = this.filter;
            return new StringBuilder(106 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("CustomMetricUtilization [metricName=").append(string).append(", targetType=").append(string2).append(", targetUtilization=").append(string3).append(", singleInstanceAssignment=").append(string4).append(", filter=").append(string5).append("]").toString();
        }
    }

    public static class CpuUtilization {
        private static final CpuUtilization EMPTY_SETTINGS = new CpuUtilization();
        private Double targetUtilization;
        private Integer aggregationWindowLengthSec;

        public Double getTargetUtilization() {
            return this.targetUtilization;
        }

        public void setTargetUtilization(Double targetUtilization) {
            this.targetUtilization = targetUtilization;
        }

        public Integer getAggregationWindowLengthSec() {
            return this.aggregationWindowLengthSec;
        }

        public void setAggregationWindowLengthSec(Integer aggregationWindowLengthSec) {
            this.aggregationWindowLengthSec = aggregationWindowLengthSec;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.targetUtilization, this.aggregationWindowLengthSec);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CpuUtilization other = (CpuUtilization)obj;
            return Objects.equals(this.targetUtilization, other.targetUtilization) && Objects.equals(this.aggregationWindowLengthSec, other.aggregationWindowLengthSec);
        }

        public String toString() {
            String string = String.valueOf(this.targetUtilization);
            String string2 = String.valueOf(this.aggregationWindowLengthSec);
            return new StringBuilder(64 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CpuUtilization [targetUtilization=").append(string).append(", aggregationWindowLengthSec=").append(string2).append("]").toString();
        }
    }

    public static class AutomaticScaling {
        private static final AutomaticScaling EMPTY_SETTINGS = new AutomaticScaling();
        public static final String AUTOMATIC = "automatic";
        private String minPendingLatency;
        private String maxPendingLatency;
        private String minIdleInstances;
        private String maxIdleInstances;
        private String maxConcurrentRequests;
        private Integer minNumInstances;
        private Integer maxNumInstances;
        private Integer coolDownPeriodSec;
        private CpuUtilization cpuUtilization;
        private List<CustomMetricUtilization> customMetrics = new ArrayList<CustomMetricUtilization>();
        private Integer targetNetworkSentBytesPerSec;
        private Integer targetNetworkSentPacketsPerSec;
        private Integer targetNetworkReceivedBytesPerSec;
        private Integer targetNetworkReceivedPacketsPerSec;
        private Integer targetDiskWriteBytesPerSec;
        private Integer targetDiskWriteOpsPerSec;
        private Integer targetDiskReadBytesPerSec;
        private Integer targetDiskReadOpsPerSec;
        private Integer targetRequestCountPerSec;
        private Integer targetConcurrentRequests;
        private Double targetCpuUtilization;
        private Double targetThroughputUtilization;
        private Integer minInstances;
        private Integer maxInstances;

        public String getMinPendingLatency() {
            return this.minPendingLatency;
        }

        public void setMinPendingLatency(String minPendingLatency) {
            this.minPendingLatency = AppEngineWebXml.toNullIfEmptyOrWhitespace(minPendingLatency);
        }

        public String getMaxPendingLatency() {
            return this.maxPendingLatency;
        }

        public void setMaxPendingLatency(String maxPendingLatency) {
            this.maxPendingLatency = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxPendingLatency);
        }

        public String getMinIdleInstances() {
            return this.minIdleInstances;
        }

        public void setMinIdleInstances(String minIdleInstances) {
            this.minIdleInstances = AppEngineWebXml.toNullIfEmptyOrWhitespace(minIdleInstances);
        }

        public String getMaxIdleInstances() {
            return this.maxIdleInstances;
        }

        public void setMaxIdleInstances(String maxIdleInstances) {
            this.maxIdleInstances = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxIdleInstances);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public String getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(String maxConcurrentRequests) {
            this.maxConcurrentRequests = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxConcurrentRequests);
        }

        public Integer getMinNumInstances() {
            return this.minNumInstances;
        }

        public void setMinNumInstances(Integer minNumInstances) {
            this.minNumInstances = minNumInstances;
        }

        public Integer getMaxNumInstances() {
            return this.maxNumInstances;
        }

        public void setMaxNumInstances(Integer maxNumInstances) {
            this.maxNumInstances = maxNumInstances;
        }

        public Double getTargetCpuUtilization() {
            return this.targetCpuUtilization;
        }

        public void setTargetCpuUtilization(Double targetCpuUtilization) {
            this.targetCpuUtilization = targetCpuUtilization;
        }

        public Double getTargetThroughputUtilization() {
            return this.targetThroughputUtilization;
        }

        public void setTargetThroughputUtilization(Double targetThroughputUtilization) {
            this.targetThroughputUtilization = targetThroughputUtilization;
        }

        public Integer getMinInstances() {
            return this.minInstances;
        }

        public void setMinInstances(Integer minInstances) {
            this.minInstances = minInstances;
        }

        public Integer getMaxInstances() {
            return this.maxInstances;
        }

        public void setMaxInstances(Integer maxInstances) {
            this.maxInstances = maxInstances;
        }

        public Integer getCoolDownPeriodSec() {
            return this.coolDownPeriodSec;
        }

        public void setCoolDownPeriodSec(Integer coolDownPeriodSec) {
            this.coolDownPeriodSec = coolDownPeriodSec;
        }

        public CpuUtilization getCpuUtilization() {
            return this.cpuUtilization;
        }

        public void setCpuUtilization(CpuUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
        }

        public Integer getTargetNetworkSentBytesPerSec() {
            return this.targetNetworkSentBytesPerSec;
        }

        public void setTargetNetworkSentBytesPerSec(Integer targetNetworkSentBytesPerSec) {
            this.targetNetworkSentBytesPerSec = targetNetworkSentBytesPerSec;
        }

        public Integer getTargetNetworkSentPacketsPerSec() {
            return this.targetNetworkSentPacketsPerSec;
        }

        public void setTargetNetworkSentPacketsPerSec(Integer targetNetworkSentPacketsPerSec) {
            this.targetNetworkSentPacketsPerSec = targetNetworkSentPacketsPerSec;
        }

        public Integer getTargetNetworkReceivedBytesPerSec() {
            return this.targetNetworkReceivedBytesPerSec;
        }

        public void setTargetNetworkReceivedBytesPerSec(Integer targetNetworkReceivedBytesPerSec) {
            this.targetNetworkReceivedBytesPerSec = targetNetworkReceivedBytesPerSec;
        }

        public Integer getTargetNetworkReceivedPacketsPerSec() {
            return this.targetNetworkReceivedPacketsPerSec;
        }

        public void setTargetNetworkReceivedPacketsPerSec(Integer targetNetworkReceivedPacketsPerSec) {
            this.targetNetworkReceivedPacketsPerSec = targetNetworkReceivedPacketsPerSec;
        }

        public Integer getTargetDiskWriteBytesPerSec() {
            return this.targetDiskWriteBytesPerSec;
        }

        public void setTargetDiskWriteBytesPerSec(Integer targetDiskWriteBytesPerSec) {
            this.targetDiskWriteBytesPerSec = targetDiskWriteBytesPerSec;
        }

        public Integer getTargetDiskWriteOpsPerSec() {
            return this.targetDiskWriteOpsPerSec;
        }

        public void setTargetDiskWriteOpsPerSec(Integer targetDiskWriteOpsPerSec) {
            this.targetDiskWriteOpsPerSec = targetDiskWriteOpsPerSec;
        }

        public Integer getTargetDiskReadBytesPerSec() {
            return this.targetDiskReadBytesPerSec;
        }

        public void setTargetDiskReadBytesPerSec(Integer targetDiskReadBytesPerSec) {
            this.targetDiskReadBytesPerSec = targetDiskReadBytesPerSec;
        }

        public Integer getTargetDiskReadOpsPerSec() {
            return this.targetDiskReadOpsPerSec;
        }

        public void setTargetDiskReadOpsPerSec(Integer targetDiskReadOpsPerSec) {
            this.targetDiskReadOpsPerSec = targetDiskReadOpsPerSec;
        }

        public Integer getTargetRequestCountPerSec() {
            return this.targetRequestCountPerSec;
        }

        public void setTargetRequestCountPerSec(Integer targetRequestCountPerSec) {
            this.targetRequestCountPerSec = targetRequestCountPerSec;
        }

        public Integer getTargetConcurrentRequests() {
            return this.targetConcurrentRequests;
        }

        public void setTargetConcurrentRequests(Integer targetConcurrentRequests) {
            this.targetConcurrentRequests = targetConcurrentRequests;
        }

        public List<CustomMetricUtilization> getCustomMetrics() {
            return this.customMetrics;
        }

        public void setCustomMetrics(List<CustomMetricUtilization> customMetrics) {
            this.customMetrics = customMetrics;
        }

        public int hashCode() {
            return Objects.hash(this.maxPendingLatency, this.minPendingLatency, this.maxIdleInstances, this.minIdleInstances, this.maxConcurrentRequests, this.minNumInstances, this.maxNumInstances, this.coolDownPeriodSec, this.cpuUtilization, this.customMetrics, this.targetNetworkSentBytesPerSec, this.targetNetworkSentPacketsPerSec, this.targetNetworkReceivedBytesPerSec, this.targetNetworkReceivedPacketsPerSec, this.targetDiskWriteBytesPerSec, this.targetDiskWriteOpsPerSec, this.targetDiskReadBytesPerSec, this.targetDiskReadOpsPerSec, this.targetRequestCountPerSec, this.targetConcurrentRequests, this.targetCpuUtilization, this.targetThroughputUtilization, this.minInstances, this.maxInstances);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutomaticScaling other = (AutomaticScaling)obj;
            return Objects.equals(this.maxPendingLatency, other.maxPendingLatency) && Objects.equals(this.minPendingLatency, other.minPendingLatency) && Objects.equals(this.maxIdleInstances, other.maxIdleInstances) && Objects.equals(this.minIdleInstances, other.minIdleInstances) && Objects.equals(this.targetCpuUtilization, other.targetCpuUtilization) && Objects.equals(this.targetThroughputUtilization, other.targetThroughputUtilization) && Objects.equals(this.minInstances, other.minInstances) && Objects.equals(this.maxInstances, other.maxInstances) && Objects.equals(this.maxConcurrentRequests, other.maxConcurrentRequests) && Objects.equals(this.minNumInstances, other.minNumInstances) && Objects.equals(this.maxNumInstances, other.maxNumInstances) && Objects.equals(this.coolDownPeriodSec, other.coolDownPeriodSec) && Objects.equals(this.cpuUtilization, other.cpuUtilization) && Objects.equals(this.customMetrics, other.customMetrics) && Objects.equals(this.targetNetworkSentBytesPerSec, other.targetNetworkSentBytesPerSec) && Objects.equals(this.targetNetworkSentPacketsPerSec, other.targetNetworkSentPacketsPerSec) && Objects.equals(this.targetNetworkReceivedBytesPerSec, other.targetNetworkReceivedBytesPerSec) && Objects.equals(this.targetNetworkReceivedPacketsPerSec, other.targetNetworkReceivedPacketsPerSec) && Objects.equals(this.targetDiskWriteBytesPerSec, other.targetDiskWriteBytesPerSec) && Objects.equals(this.targetDiskWriteOpsPerSec, other.targetDiskWriteOpsPerSec) && Objects.equals(this.targetDiskReadBytesPerSec, other.targetDiskReadBytesPerSec) && Objects.equals(this.targetDiskReadOpsPerSec, other.targetDiskReadOpsPerSec) && Objects.equals(this.targetRequestCountPerSec, other.targetRequestCountPerSec) && Objects.equals(this.targetConcurrentRequests, other.targetConcurrentRequests);
        }

        public String toString() {
            String string = this.minPendingLatency;
            String string2 = this.maxPendingLatency;
            String string3 = this.minIdleInstances;
            String string4 = this.maxIdleInstances;
            String string5 = String.valueOf(this.minInstances);
            String string6 = String.valueOf(this.maxInstances);
            String string7 = this.maxConcurrentRequests;
            String string8 = String.valueOf(this.minNumInstances);
            String string9 = String.valueOf(this.maxNumInstances);
            String string10 = String.valueOf(this.coolDownPeriodSec);
            String string11 = String.valueOf(this.cpuUtilization);
            String string12 = String.valueOf(this.customMetrics);
            String string13 = String.valueOf(this.targetNetworkSentBytesPerSec);
            String string14 = String.valueOf(this.targetNetworkSentPacketsPerSec);
            String string15 = String.valueOf(this.targetNetworkReceivedBytesPerSec);
            String string16 = String.valueOf(this.targetNetworkReceivedPacketsPerSec);
            String string17 = String.valueOf(this.targetDiskWriteBytesPerSec);
            String string18 = String.valueOf(this.targetDiskWriteOpsPerSec);
            String string19 = String.valueOf(this.targetDiskReadBytesPerSec);
            String string20 = String.valueOf(this.targetDiskReadOpsPerSec);
            String string21 = String.valueOf(this.targetRequestCountPerSec);
            String string22 = String.valueOf(this.targetConcurrentRequests);
            String string23 = String.valueOf(this.targetCpuUtilization);
            String string24 = String.valueOf(this.targetThroughputUtilization);
            return new StringBuilder(591 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string9).length() + String.valueOf(string10).length() + String.valueOf(string11).length() + String.valueOf(string12).length() + String.valueOf(string13).length() + String.valueOf(string14).length() + String.valueOf(string15).length() + String.valueOf(string16).length() + String.valueOf(string17).length() + String.valueOf(string18).length() + String.valueOf(string19).length() + String.valueOf(string20).length() + String.valueOf(string21).length() + String.valueOf(string22).length() + String.valueOf(string23).length() + String.valueOf(string24).length()).append("AutomaticScaling [minPendingLatency=").append(string).append(", maxPendingLatency=").append(string2).append(", minIdleInstances=").append(string3).append(", maxIdleInstances=").append(string4).append(", minInstances=").append(string5).append(", maxInstances=").append(string6).append(", maxConcurrentRequests=").append(string7).append(", minNumInstances=").append(string8).append(", maxNumInstances=").append(string9).append(", coolDownPeriodSec=").append(string10).append(", cpuUtilization=").append(string11).append(", customMetrics=").append(string12).append(", targetNetworkSentBytesPerSec=").append(string13).append(", targetNetworkSentPacketsPerSec=").append(string14).append(", targetNetworkReceivedBytesPerSec=").append(string15).append(", targetNetworkReceivedPacketsPerSec=").append(string16).append(", targetDiskWriteBytesPerSec=").append(string17).append(", targetDiskWriteOpsPerSec=").append(string18).append(", targetDiskReadBytesPerSec=").append(string19).append(", targetDiskReadOpsPerSec=").append(string20).append(", targetRequestCountPerSec=").append(string21).append(", targetConcurrentRequests=").append(string22).append(", targetCpuUtilization=").append(string23).append(", targetThroughputUtilization=").append(string24).append("]").toString();
        }
    }

    @AutoValue
    public static abstract class ApiConfig {
        public abstract String getServletClass();

        public abstract String getUrl();

        public static ApiConfig of(String servletClass, String url) {
            return new AutoValue_AppEngineWebXml_ApiConfig(servletClass, url);
        }
    }

    @AutoValue
    public static abstract class ErrorHandler {
        public abstract String getFile();

        @Nullable
        public abstract String getErrorCode();

        public static ErrorHandler of(String file, String errorCode) {
            return new AutoValue_AppEngineWebXml_ErrorHandler(file, errorCode);
        }
    }

    @AutoValue
    public static abstract class VpcAccessConnector {
        public abstract String getName();

        public static VpcAccessConnector of(String name) {
            return new AutoValue_AppEngineWebXml_VpcAccessConnector(name);
        }
    }

    @AutoValue
    public static abstract class AdminConsolePage {
        public abstract String getName();

        public abstract String getUrl();

        public static AdminConsolePage of(String name, String url) {
            return new AutoValue_AppEngineWebXml_AdminConsolePage(name, url);
        }
    }

    public static class StaticFileInclude {
        private final String pattern;
        private final String expiration;
        private final Map<String, String> httpHeaders;

        public StaticFileInclude(String pattern, String expiration) {
            this.pattern = pattern;
            this.expiration = expiration;
            this.httpHeaders = new LinkedHashMap<String, String>();
        }

        public String getPattern() {
            return this.pattern;
        }

        public Pattern getRegularExpression() {
            return Pattern.compile(AppEngineWebXml.makeFileRegex(this.pattern));
        }

        public String getExpiration() {
            return this.expiration;
        }

        public Map<String, String> getHttpHeaders() {
            return this.httpHeaders;
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.expiration, this.httpHeaders);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StaticFileInclude)) {
                return false;
            }
            StaticFileInclude other = (StaticFileInclude)obj;
            return Objects.equals(this.pattern, other.pattern) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.httpHeaders, other.httpHeaders);
        }
    }

    @AutoValue
    static abstract class UserPermission {
        UserPermission() {
        }

        abstract String getClassName();

        abstract String getName();

        @Nullable
        abstract String getActions();

        static UserPermission of(String className, String name, String actions) {
            return new AutoValue_AppEngineWebXml_UserPermission(className, name, actions);
        }
    }

    public static enum UseGoogleConnectorJ {
        NOT_STATED_BY_USER,
        TRUE,
        FALSE;

    }

    public static enum ScalingType {
        AUTOMATIC,
        MANUAL,
        BASIC;

    }
}

