/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.runtime;

import com.google.appengine.repackaged.com.google.apphosting.base.RuntimePb;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Enums;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.net.util.proto2api.Status;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;

public class ApiProxyUtils {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/apphosting/utils/runtime/ApiProxyUtils");

    public static ApiProxy.ApiProxyException convertApiError(RuntimePb.APIResponse apiResponse, String packageName, String methodName, GoogleLogger logger) {
        RuntimePb.APIResponse.ERROR error = RuntimePb.APIResponse.ERROR.valueOf(apiResponse.getError());
        switch (error) {
            case CALL_NOT_FOUND: {
                return new ApiProxy.CallNotFoundException(packageName, methodName);
            }
            case PARSE_ERROR: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case SECURITY_VIOLATION: {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/apphosting/utils/runtime/ApiProxyUtils", "convertApiError", 47, "ApiProxyUtils.java")).log("Security violation: invalid request id used!");
                return new ApiProxy.UnknownException(packageName, methodName);
            }
            case CAPABILITY_DISABLED: {
                return new ApiProxy.CapabilityDisabledException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case OVER_QUOTA: {
                return new ApiProxy.OverQuotaException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case REQUEST_TOO_LARGE: {
                return new ApiProxy.RequestTooLargeException(packageName, methodName);
            }
            case RESPONSE_TOO_LARGE: {
                return new ApiProxy.ResponseTooLargeException(packageName, methodName);
            }
            case BAD_REQUEST: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case CANCELLED: {
                return new ApiProxy.CancelledException(packageName, methodName);
            }
            case BUFFER_ERROR: {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/apphosting/utils/runtime/ApiProxyUtils", "convertApiError", 64, "ApiProxyUtils.java")).log("API returned BUFFER_ERROR, but shared buffers no longer supported.");
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case FEATURE_DISABLED: {
                return new ApiProxy.FeatureNotEnabledException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case RPC_ERROR: {
                return ApiProxyUtils.convertApiResponseRpcErrorToException(RuntimePb.APIResponse.RpcError.valueOf(apiResponse.getRpcError()), packageName, methodName, apiResponse.getRpcApplicationError(), apiResponse.getErrorMessage(), logger);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    private static ApiProxy.ApiProxyException convertApiResponseRpcErrorToException(RuntimePb.APIResponse.RpcError rpcError, String packageName, String methodName, int applicationError, String errorDetail, GoogleLogger logger) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/apphosting/utils/runtime/ApiProxyUtils", "convertApiResponseRpcErrorToException", 98, "ApiProxyUtils.java")).log("RPC failed : %s : %s", (Object)rpcError, (Object)errorDetail);
        if (rpcError == null) {
            return new ApiProxy.UnknownException(packageName, methodName);
        }
        switch (rpcError) {
            case DEADLINE_EXCEEDED: {
                return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
            }
            case APPLICATION_ERROR: {
                return new ApiProxy.ApplicationException(applicationError, errorDetail);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    public static ApiProxy.ApiProxyException getRpcError(String packageName, String methodName, Status.StatusProto status, int applicationError, String errorDetail, Throwable cause) {
        Optional<ApiProxy.ApiProxyException> statusException = ApiProxyUtils.statusException(status, packageName, methodName, cause);
        if (statusException.isPresent()) {
            return statusException.get();
        }
        if (applicationError == 9 && "memcache".equals(packageName)) {
            return new ApiProxy.CapabilityDisabledException(errorDetail, packageName, methodName);
        }
        return new ApiProxy.ApplicationException(applicationError, errorDetail);
    }

    public static ApiProxy.ApiProxyException getApiError(String packageName, String methodName, RemoteApiPb.Response response, GoogleLogger logger) {
        RuntimePb.APIResponse apiResponse = new RuntimePb.APIResponse();
        apiResponse.setError(ApiProxyUtils.remoteApiErrorToApiResponseError(response).getValue());
        apiResponse.setPbAsBytes(response.getResponseAsBytes());
        return ApiProxyUtils.getApiError(packageName, methodName, apiResponse, logger);
    }

    public static ApiProxy.ApiProxyException getApiError(String packageName, String methodName, RuntimePb.APIResponse apiResponse, GoogleLogger logger) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/apphosting/utils/runtime/ApiProxyUtils", "getApiError", 179, "ApiProxyUtils.java")).log("Received error from APIHost : %s : %s", apiResponse.getError(), (Object)apiResponse.getErrorMessage());
        return ApiProxyUtils.convertApiError(apiResponse, packageName, methodName, logger);
    }

    @VisibleForTesting
    public static Optional<ApiProxy.ApiProxyException> statusException(Status.StatusProto status, String packageName, String methodName, Throwable cause) {
        switch (status.getSpace()) {
            case "generic": {
                if (status.getCode() == 1) {
                    return Optional.of(new ApiProxy.CancelledException(packageName, methodName));
                }
                return Optional.absent();
            }
            case "RPC": {
                if (status.getCode() == 4) {
                    return Optional.of(new ApiProxy.ApiDeadlineExceededException(packageName, methodName));
                }
                return Optional.of(new ApiProxy.UnknownException(packageName, methodName, cause));
            }
        }
        return Optional.absent();
    }

    public static RuntimePb.APIResponse.ERROR remoteApiErrorToApiResponseError(RemoteApiPb.Response responsePb) {
        RemoteApiPb.RpcError.ErrorCode errorCode;
        Optional<RuntimePb.APIResponse.ERROR> maybeError;
        if (!responsePb.hasRpcError()) {
            return RuntimePb.APIResponse.ERROR.OK;
        }
        int code = responsePb.getRpcError().getCode();
        RemoteApiPb.RpcError.ErrorCode[] errorCodes = RemoteApiPb.RpcError.ErrorCode.values();
        if (code >= 0 && code < errorCodes.length && (maybeError = Enums.getIfPresent(RuntimePb.APIResponse.ERROR.class, (errorCode = errorCodes[code]).name())).isPresent()) {
            return maybeError.get();
        }
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/apphosting/utils/runtime/ApiProxyUtils", "remoteApiErrorToApiResponseError", 239, "ApiProxyUtils.java")).log("Unknown error code %s", code);
        return RuntimePb.APIResponse.ERROR.RPC_ERROR;
    }
}

