/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.tools.development.BackgroundThreadFactory;
import com.google.appengine.tools.development.RequestEndListener;
import com.google.appengine.tools.development.RequestThreadFactory;
import com.google.apphosting.api.ApiProxy;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LocalEnvironment
implements ApiProxy.Environment {
    private static final Logger logger = Logger.getLogger(LocalEnvironment.class.getName());
    static final Pattern APP_ID_PATTERN = Pattern.compile("([^:.]*)(:([^:.]*))?(.*)?");
    private static final String APPS_NAMESPACE_KEY = String.valueOf(NamespaceManager.class.getName()).concat(".appsNamespace");
    public static final Integer TESTING_DEFAULT_PORT = new Integer(8080);
    public static final String INSTANCE_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.id";
    public static final String PORT_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.port";
    public static final String API_CALL_SEMAPHORE = "com.google.appengine.tools.development.api_call_semaphore";
    public static final String REQUEST_ID = "com.google.appengine.runtime.request_log_id";
    public static final String START_TIME_ATTR = "com.google.appengine.tools.development.start_time";
    public static final String REQUEST_END_LISTENERS = "com.google.appengine.tools.development.request_end_listeners";
    public static final String HTTP_SERVLET_REQUEST = "com.google.appengine.http_servlet_request";
    private static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
    private static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";
    private static final String MINOR_VERSION_SUFFIX = ".1";
    public static final String DEFAULT_VERSION_HOSTNAME = "com.google.appengine.runtime.default_version_hostname";
    public static final String FILESAPI_WAS_USED = "com.google.appengine.api.files.filesapi_was_used";
    private final String appId;
    private final String moduleId;
    private final String versionId;
    private final Collection<RequestEndListener> requestEndListeners;
    protected final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Long endTime;
    public static final int MAIN_INSTANCE = -1;
    private static AtomicInteger requestID = new AtomicInteger();

    @Deprecated
    protected LocalEnvironment(String appId, String majorVersionId) {
        this(appId, "default", majorVersionId, -1, TESTING_DEFAULT_PORT, null);
    }

    @Deprecated
    protected LocalEnvironment(String appId, String majorVersionId, Long deadlineMillis) {
        this(appId, "default", majorVersionId, -1, TESTING_DEFAULT_PORT, deadlineMillis);
    }

    protected LocalEnvironment(String appId, String moduleName, String majorVersionId, int instance, Integer port, Long deadlineMillis) {
        this.appId = appId;
        this.moduleId = moduleName;
        String string = String.valueOf(majorVersionId != null ? majorVersionId : "no_version");
        String string2 = String.valueOf(MINOR_VERSION_SUFFIX);
        String string3 = this.versionId = string2.length() != 0 ? string.concat(string2) : new String(string);
        if (deadlineMillis == null) {
            this.endTime = null;
        } else {
            if (deadlineMillis < 0L) {
                throw new IllegalArgumentException("deadlineMillis must be a non-negative integer.");
            }
            this.endTime = System.currentTimeMillis() + deadlineMillis;
        }
        LocalEnvironment.setInstance(this.attributes, instance);
        LocalEnvironment.setPort(this.attributes, port);
        this.requestEndListeners = Collections.newSetFromMap(new ConcurrentHashMap(10));
        this.attributes.put(REQUEST_ID, this.generateRequestId());
        this.attributes.put(REQUEST_END_LISTENERS, this.requestEndListeners);
        this.attributes.put(START_TIME_ATTR, new Date());
        this.attributes.put(REQUEST_THREAD_FACTORY_ATTR, new RequestThreadFactory());
        this.attributes.put(BACKGROUND_THREAD_FACTORY_ATTR, new BackgroundThreadFactory(appId, moduleName, majorVersionId));
    }

    static void setInstance(Map<String, Object> attributes, int instance) {
        attributes.remove(INSTANCE_ID_ENV_ATTRIBUTE);
        if (instance != -1) {
            attributes.put(INSTANCE_ID_ENV_ATTRIBUTE, Integer.toString(instance));
        }
    }

    static void setPort(Map<String, Object> attributes, Integer port) {
        if (port == null) {
            attributes.remove(PORT_ID_ENV_ATTRIBUTE);
        } else {
            attributes.put(PORT_ID_ENV_ATTRIBUTE, port);
        }
    }

    static int getCurrentInstance() {
        int result = -1;
        String instance = (String)ApiProxy.getCurrentEnvironment().getAttributes().get(INSTANCE_ID_ENV_ATTRIBUTE);
        if (instance != null) {
            result = Integer.parseInt(instance);
        }
        return result;
    }

    static Integer getCurrentPort() {
        return (Integer)ApiProxy.getCurrentEnvironment().getAttributes().get(PORT_ID_ENV_ATTRIBUTE);
    }

    private String generateRequestId() {
        try {
            ByteBuffer buf = ByteBuffer.allocate(12);
            long now = System.currentTimeMillis();
            buf.putInt((int)(now / 1000L));
            buf.putInt((int)(now * 1000L % 1000000L));
            String nextID = Integer.toString(requestID.getAndIncrement());
            byte[] hashBytes = MessageDigest.getInstance("SHA-1").digest(nextID.getBytes(StandardCharsets.US_ASCII));
            buf.put(hashBytes, 0, 4);
            return String.format("%x", new BigInteger(buf.array()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public String getAuthDomain() {
        return "gmail.com";
    }

    @Override
    @Deprecated
    public final String getRequestNamespace() {
        String appsNamespace = (String)this.getAttributes().get(APPS_NAMESPACE_KEY);
        return appsNamespace == null ? "" : appsNamespace;
    }

    public ConcurrentMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public void callRequestEndListeners() {
        for (RequestEndListener listener : this.requestEndListeners) {
            try {
                listener.onRequestEnd(this);
            }
            catch (Exception ex) {
                String string = String.valueOf(listener.getClass());
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.LocalEnvironment", "callRequestEndListeners", new StringBuilder(58 + String.valueOf(string).length()).append("Exception while attempting to invoke RequestEndListener ").append(string).append(": ").toString(), ex);
            }
        }
        this.requestEndListeners.clear();
    }

    @Override
    public long getRemainingMillis() {
        if (this.endTime != null) {
            return this.endTime - System.currentTimeMillis();
        }
        return Long.MAX_VALUE;
    }

    public static String getMajorVersion(String versionId) {
        Matcher matcher = APP_ID_PATTERN.matcher(versionId);
        matcher.find();
        return matcher.group(3) == null ? matcher.group(1) : matcher.group(3);
    }
}

