/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.appidentity.AppIdentityStubServicePb;
import com.google.appengine.api.appidentity.dev.LocalAppIdentityService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiServerFactory;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import java.io.IOException;

public class LocalAppIdentityServiceTestConfig
implements LocalServiceTestConfig {
    private String defaultGcsBucketName = null;

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        if (this.defaultGcsBucketName != null) {
            if (ApiUtils.isUsingPythonStub("app_identity_service")) {
                this.setDefaultGcsBucketNameOnPythonStub(this.defaultGcsBucketName);
            } else {
                proxy.setProperty("appengine.default.gcs.bucket.name", this.defaultGcsBucketName);
            }
        }
    }

    @Override
    public void tearDown() {
    }

    public static LocalAppIdentityService getLocalSecretsService() {
        return (LocalAppIdentityService)LocalServiceTestHelper.getLocalService("app_identity_service");
    }

    public LocalAppIdentityServiceTestConfig setDefaultGcsBucketName(String defaultGcsBucketName) {
        this.defaultGcsBucketName = defaultGcsBucketName;
        return this;
    }

    private void setDefaultGcsBucketNameOnPythonStub(String defaultGcsBucketName) {
        try {
            AppIdentityStubServicePb.SetDefaultGcsBucketNameRequest.Builder request = AppIdentityStubServicePb.SetDefaultGcsBucketNameRequest.newBuilder();
            request.setDefaultGcsBucketName(defaultGcsBucketName);
            ApiServerFactory.getExistingApiServer().makeSyncCall("app_identity_service", "SetDefaultGcsBucketName", ApiUtils.convertPbToBytes(request.build()));
        }
        catch (IOException e) {
            throw new RuntimeException("Setting the default GCS bucket name has failed", e);
        }
    }
}

