/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.collect.Cache;
import com.google.appengine.repackaged.com.google.common.collect.CacheStats;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    @Nullable
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    @Nullable
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(@Nullable Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<Map.Entry<K, V>> activeEntries(int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    @GoogleInternal
    public static CacheStats aggregate(StatsCounter ... stats) {
        SimpleStatsCounter aggregator = new SimpleStatsCounter();
        for (StatsCounter other : stats) {
            aggregator.incrementBy(other);
        }
        return aggregator.snapshot();
    }

    @Beta
    public static class SimpleStatsCounter
    implements StatsCounter {
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private final AtomicLong createSuccessCount = new AtomicLong();
        private final AtomicLong createExceptionCount = new AtomicLong();
        private final AtomicLong totalCreateTime = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        public void recordHit() {
            this.hitCount.incrementAndGet();
        }

        public void recordCreateSuccess(long createTime) {
            this.missCount.incrementAndGet();
            this.createSuccessCount.incrementAndGet();
            this.totalCreateTime.addAndGet(createTime);
        }

        public void recordCreateException(long createTime) {
            this.missCount.incrementAndGet();
            this.createExceptionCount.incrementAndGet();
            this.totalCreateTime.addAndGet(createTime);
        }

        public void recordConcurrentMiss() {
            this.missCount.incrementAndGet();
        }

        public void recordEviction() {
            this.evictionCount.incrementAndGet();
        }

        public CacheStats snapshot() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.createSuccessCount.get(), this.createExceptionCount.get(), this.totalCreateTime.get(), this.evictionCount.get());
        }

        public void incrementBy(StatsCounter other) {
            CacheStats otherStats = other.snapshot();
            this.hitCount.addAndGet(otherStats.hitCount());
            this.missCount.addAndGet(otherStats.missCount());
            this.createSuccessCount.addAndGet(otherStats.createSuccessCount());
            this.createExceptionCount.addAndGet(otherStats.createExceptionCount());
            this.totalCreateTime.addAndGet(otherStats.totalCreateTime());
            this.evictionCount.addAndGet(otherStats.evictionCount());
        }
    }

    @Beta
    public static interface StatsCounter {
        public void recordHit();

        public void recordCreateSuccess(long var1);

        public void recordCreateException(long var1);

        public void recordConcurrentMiss();

        public void recordEviction();

        public CacheStats snapshot();
    }
}

