/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueType;
import com.google.datastore.v1.Value;

public final class BlobValue
extends Value<Blob> {
    private static final long serialVersionUID = -5096238337676649540L;
    static final Value.BaseMarshaller<Blob, BlobValue, Builder> MARSHALLER = new Value.BaseMarshaller<Blob, BlobValue, Builder>(){
        private static final long serialVersionUID = -823515687083612387L;

        @Override
        public int getProtoFieldId() {
            return 18;
        }

        @Override
        public Builder newBuilder(Blob value) {
            return BlobValue.builder(value);
        }

        @Override
        protected Blob getValue(com.google.datastore.v1.Value from) {
            return new Blob(from.getBlobValue());
        }

        @Override
        protected void setValue(BlobValue from, Value.Builder to) {
            to.setBlobValue(((Blob)from.get()).byteString());
        }
    };

    public BlobValue(Blob blob) {
        this(BlobValue.builder(blob));
    }

    private BlobValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static BlobValue of(Blob blob) {
        return new BlobValue(blob);
    }

    public static Builder builder(Blob blob) {
        return (Builder)new Builder().set(blob);
    }

    public static final class Builder
    extends Value.BaseBuilder<Blob, BlobValue, Builder> {
        private Builder() {
            super(ValueType.BLOB);
        }

        @Override
        public BlobValue build() {
            return new BlobValue(this);
        }
    }
}

