/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Serializable;
import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;

public final class LatLng
extends Serializable<com.google.type.LatLng> {
    private static final long serialVersionUID = 9077060962655752073L;
    private final transient double latitude;
    private final transient double longitude;

    LatLng(double latitude, double longitude) {
        Preconditions.checkArgument((latitude >= -90.0 && latitude <= 90.0 ? 1 : 0) != 0, (Object)"latitude must be in the range [-90, 90] degrees");
        Preconditions.checkArgument((longitude >= -180.0 && longitude <= 180.0 ? 1 : 0) != 0, (Object)"latitude must be in the range [-180, 180] degrees");
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double latitude() {
        return this.latitude;
    }

    public double longitude() {
        return this.longitude;
    }

    @Override
    public String toString() {
        return Double.toString(this.latitude) + ", " + Double.toString(this.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LatLng && this.latitude == ((LatLng)obj).latitude && this.longitude == ((LatLng)obj).longitude;
    }

    public static LatLng of(double latitude, double longitude) {
        return new LatLng(latitude, longitude);
    }

    @Override
    protected com.google.type.LatLng toPb() {
        return com.google.type.LatLng.newBuilder().setLatitude(this.latitude).setLongitude(this.longitude).build();
    }

    @Override
    protected Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        com.google.type.LatLng parsedLatLng = com.google.type.LatLng.parseFrom((byte[])bytesPb);
        return new LatLng(parsedLatLng.getLatitude(), parsedLatLng.getLongitude());
    }
}

