/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueType;
import com.google.datastore.v1.Value;

public final class LatLngValue
extends Value<LatLng> {
    private static final long serialVersionUID = -5810614280642405898L;
    static final Value.BaseMarshaller<LatLng, LatLngValue, Builder> MARSHALLER = new Value.BaseMarshaller<LatLng, LatLngValue, Builder>(){
        private static final long serialVersionUID = -3550567536035178649L;

        @Override
        public int getProtoFieldId() {
            return 8;
        }

        @Override
        public Builder newBuilder(LatLng value) {
            return LatLngValue.builder(value);
        }

        @Override
        protected LatLng getValue(com.google.datastore.v1.Value from) {
            return new LatLng(from.getGeoPointValue().getLatitude(), from.getGeoPointValue().getLongitude());
        }

        @Override
        protected void setValue(LatLngValue from, Value.Builder to) {
            to.setGeoPointValue(((LatLng)from.get()).toPb());
        }
    };

    public LatLngValue(LatLng value) {
        this(LatLngValue.builder(value));
    }

    private LatLngValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static LatLngValue of(LatLng value) {
        return new LatLngValue(value);
    }

    public static Builder builder(LatLng value) {
        return (Builder)new Builder().set(value);
    }

    public static final class Builder
    extends Value.BaseBuilder<LatLng, LatLngValue, Builder> {
        private Builder() {
            super(ValueType.LAT_LNG);
        }

        @Override
        public LatLngValue build() {
            return new LatLngValue(this);
        }
    }
}

