/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.cloud.AuthCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LocalDatastoreHelper {
    private static final Logger log = Logger.getLogger(LocalDatastoreHelper.class.getName());
    private static final String GCD_VERSION = "1.2.0";
    private static final double DEFAULT_CONSISTENCY = 0.9;
    private static final String GCD_BASENAME = "cloud-datastore-emulator-1.2.0";
    private static final String GCD_FILENAME = "cloud-datastore-emulator-1.2.0.zip";
    private static final String MD5_CHECKSUM = "e68695ff005421ccb7144689d9633df1";
    private static final URL GCD_URL;
    private static final String GCLOUD = "gcloud";
    private static final Path INSTALLED_GCD_PATH;
    private static final String GCD_VERSION_PREFIX = "cloud-datastore-emulator ";
    private static final String PROJECT_ID_PREFIX = "test-project-";
    private final String projectId;
    private Path gcdPath;
    private Process startProcess;
    private ProcessStreamReader processReader;
    private ProcessErrorStreamReader processErrorReader;
    private final int port;
    private final double consistency;

    private static Path installedGcdPath() {
        Path installedGcdPath;
        String gcloudExecutableName = LocalDatastoreHelper.isWindows() ? "gcloud.cmd" : GCLOUD;
        Path gcloudPath = LocalDatastoreHelper.executablePath(gcloudExecutableName);
        Path path = gcloudPath = gcloudPath == null ? null : gcloudPath.getParent();
        if (gcloudPath == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("SDK not found");
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("SDK found, looking for datastore emulator");
        }
        if (Files.exists(installedGcdPath = gcloudPath.resolve("platform").resolve("cloud-datastore-emulator"), new LinkOption[0])) {
            try {
                String installedVersion = LocalDatastoreHelper.installedGcdVersion();
                if (installedVersion != null && installedVersion.startsWith(GCD_VERSION)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("SDK datastore emulator found");
                    }
                    return installedGcdPath;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("SDK datastore emulator found but version mismatch");
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String installedGcdVersion() throws IOException, InterruptedException {
        Process process = CommandWrapper.create().command(GCLOUD, "version").redirectErrorStream().start();
        process.waitFor();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                String[] lineComponents;
                if (line.startsWith(GCD_VERSION_PREFIX) && (lineComponents = line.split(" ")).length > 1) {
                    String string = lineComponents[1];
                    return string;
                }
                line = reader.readLine();
            }
            String string = null;
            return string;
        }
    }

    private static Path executablePath(String cmd) {
        String[] paths;
        for (String pathString : paths = System.getenv("PATH").split(Pattern.quote(File.pathSeparator))) {
            try {
                Path path = Paths.get(pathString, new String[0]);
                if (!Files.exists(path.resolve(cmd), new LinkOption[0])) continue;
                return path;
            }
            catch (InvalidPathException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    private void downloadGcd() throws IOException {
        File gcdZipFile = new File(System.getProperty("java.io.tmpdir"), GCD_FILENAME);
        if (!gcdZipFile.exists() || !MD5_CHECKSUM.equals(LocalDatastoreHelper.md5(gcdZipFile))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Fetching datastore emulator");
            }
            ReadableByteChannel rbc = Channels.newChannel(GCD_URL.openStream());
            try (FileOutputStream fos = new FileOutputStream(gcdZipFile);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Using cached datastore emulator");
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(gcdZipFile));){
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unzipping datastore emulator");
            }
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                File filePath = new File(this.gcdPath.toFile(), entry.getName());
                if (!entry.isDirectory()) {
                    LocalDatastoreHelper.extractFile(zipIn, filePath);
                } else {
                    filePath.mkdir();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private void startGcd(Path executablePath, double consistency) throws IOException, InterruptedException {
        File datasetFolder = new File(this.gcdPath.toFile(), this.projectId);
        LocalDatastoreHelper.deleteRecurse(datasetFolder.toPath());
        Path gcdAbsolutePath = LocalDatastoreHelper.isWindows() ? executablePath.toAbsolutePath().resolve("cloud_datastore_emulator.cmd") : executablePath.toAbsolutePath().resolve("cloud_datastore_emulator");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating datastore for the project: {0}", this.projectId);
        }
        Process createProcess = CommandWrapper.create().command(gcdAbsolutePath.toString(), "create", this.projectId).redirectErrorInherit().directory(this.gcdPath).redirectOutputToNull().start();
        createProcess.waitFor();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting datastore emulator for the project: {0}", this.projectId);
        }
        this.startProcess = CommandWrapper.create().command(gcdAbsolutePath.toString(), "start", "--testing", "--port=" + Integer.toString(this.port), "--consistency=" + Double.toString(consistency), this.projectId).directory(this.gcdPath).start();
        this.processReader = ProcessStreamReader.start(this.startProcess.getInputStream(), "Dev App Server is now running");
        this.processErrorReader = ProcessErrorStreamReader.start(this.startProcess.getErrorStream());
    }

    private static String md5(File gcdZipFile) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(gcdZipFile));){
                int len;
                byte[] bytes = new byte[0x400000];
                while ((len = ((InputStream)is).read(bytes)) >= 0) {
                    md5.update(bytes, 0, len);
                }
            }
            return String.format("%032x", new BigInteger(1, md5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private static void extractFile(ZipInputStream zipIn, File filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            int read;
            byte[] bytesIn = new byte[1024];
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    public static boolean sendQuitRequest(int port) {
        StringBuilder result = new StringBuilder();
        String shutdownMsg = "Shutting down local server";
        try {
            URL url = new URL("http", "localhost", port, "/_ah/admin/quit");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            OutputStream out = con.getOutputStream();
            out.write("".getBytes());
            out.flush();
            InputStream in = con.getInputStream();
            int currByte = 0;
            while ((currByte = in.read()) != -1 && result.length() < shutdownMsg.length()) {
                result.append((char)currByte);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString().startsWith(shutdownMsg);
    }

    public void stop() throws IOException, InterruptedException {
        LocalDatastoreHelper.sendQuitRequest(this.port);
        if (this.processReader != null) {
            this.processReader.terminate();
            this.processErrorReader.terminate();
            this.startProcess.destroy();
            this.startProcess.waitFor();
        }
        if (this.gcdPath != null) {
            LocalDatastoreHelper.deleteRecurse(this.gcdPath);
        }
    }

    private static void deleteRecurse(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private LocalDatastoreHelper(double consistency) {
        Preconditions.checkArgument((consistency >= 0.0 && consistency <= 1.0 ? 1 : 0) != 0, (Object)"Consistency must be between 0 and 1");
        this.projectId = PROJECT_ID_PREFIX + UUID.randomUUID().toString();
        this.consistency = consistency;
        this.port = LocalDatastoreHelper.findAvailablePort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findAvailablePort() {
        try (ServerSocket tempSocket = new ServerSocket(0);){
            int n = tempSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private DatastoreOptions.Builder optionsBuilder() {
        return (DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.builder().projectId(this.projectId)).host("localhost:" + Integer.toString(this.port))).authCredentials(AuthCredentials.noAuth())).retryParams(RetryParams.noRetries());
    }

    public DatastoreOptions options() {
        return this.optionsBuilder().build();
    }

    public DatastoreOptions options(String namespace) {
        return this.optionsBuilder().namespace(namespace).build();
    }

    public String projectId() {
        return this.projectId;
    }

    public double consistency() {
        return this.consistency;
    }

    public static LocalDatastoreHelper create(double consistency) {
        LocalDatastoreHelper helper = new LocalDatastoreHelper(consistency);
        return helper;
    }

    public static LocalDatastoreHelper create() {
        return LocalDatastoreHelper.create(0.9);
    }

    public void start() throws IOException, InterruptedException {
        Path gcdExecutablePath;
        LocalDatastoreHelper.sendQuitRequest(this.port);
        this.gcdPath = Files.createTempDirectory("gcd", new FileAttribute[0]);
        File gcdFolder = this.gcdPath.toFile();
        gcdFolder.deleteOnExit();
        if (INSTALLED_GCD_PATH == null) {
            this.downloadGcd();
            gcdExecutablePath = this.gcdPath.resolve("cloud-datastore-emulator");
        } else {
            gcdExecutablePath = INSTALLED_GCD_PATH;
        }
        this.startGcd(gcdExecutablePath, this.consistency);
    }

    static {
        INSTALLED_GCD_PATH = LocalDatastoreHelper.installedGcdPath();
        if (INSTALLED_GCD_PATH != null) {
            GCD_URL = null;
        } else {
            try {
                GCD_URL = new URL("https://storage.googleapis.com/gcd/tools/cloud-datastore-emulator-1.2.0.zip");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CommandWrapper {
        private final List<String> prefix = new ArrayList<String>();
        private List<String> command;
        private String nullFilename;
        private boolean redirectOutputToNull;
        private boolean redirectErrorStream;
        private boolean redirectErrorInherit;
        private Path directory;

        private CommandWrapper() {
            if (LocalDatastoreHelper.isWindows()) {
                this.prefix.add("cmd");
                this.prefix.add("/C");
                this.nullFilename = "NUL:";
            } else {
                this.prefix.add("bash");
                this.nullFilename = "/dev/null";
            }
        }

        public CommandWrapper command(String ... command) {
            this.command = new ArrayList<String>(command.length + this.prefix.size());
            this.command.addAll(this.prefix);
            this.command.addAll(Arrays.asList(command));
            return this;
        }

        public CommandWrapper redirectOutputToNull() {
            this.redirectOutputToNull = true;
            return this;
        }

        public CommandWrapper redirectErrorStream() {
            this.redirectErrorStream = true;
            return this;
        }

        public CommandWrapper redirectErrorInherit() {
            this.redirectErrorInherit = true;
            return this;
        }

        public CommandWrapper directory(Path directory) {
            this.directory = directory;
            return this;
        }

        public ProcessBuilder builder() {
            ProcessBuilder builder = new ProcessBuilder(this.command);
            if (this.redirectOutputToNull) {
                builder.redirectOutput(new File(this.nullFilename));
            }
            if (this.directory != null) {
                builder.directory(this.directory.toFile());
            }
            if (this.redirectErrorStream) {
                builder.redirectErrorStream(true);
            }
            if (this.redirectErrorInherit) {
                builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            }
            return builder;
        }

        public Process start() throws IOException {
            return this.builder().start();
        }

        public static CommandWrapper create() {
            return new CommandWrapper();
        }
    }

    private static class ProcessErrorStreamReader
    extends Thread {
        private static final int LOG_LENGTH_LIMIT = 50000;
        private static final String GCD_LOGGING_CLASS = "com.google.apphosting.client.serviceapp.BaseApiServlet";
        private final BufferedReader errorReader;
        private StringBuilder currentLog;
        private Level currentLogLevel;
        private boolean collectionMode;
        private volatile boolean terminated;

        ProcessErrorStreamReader(InputStream errorStream) {
            super("Local GCD ErrorStream reader");
            this.setDaemon(true);
            this.errorReader = new BufferedReader(new InputStreamReader(errorStream));
        }

        void terminate() throws IOException {
            this.terminated = true;
            this.errorReader.close();
        }

        @Override
        public void run() {
            String previousLine = "";
            String nextLine = "";
            while (!this.terminated) {
                try {
                    previousLine = nextLine;
                    nextLine = this.errorReader.readLine();
                    if (nextLine == null) {
                        this.terminated = true;
                        continue;
                    }
                    this.processLogLine(previousLine, nextLine);
                }
                catch (IOException iOException) {}
            }
            this.processLogLine(previousLine, (String)MoreObjects.firstNonNull((Object)nextLine, (Object)""));
            ProcessErrorStreamReader.writeLog(this.currentLogLevel, this.currentLog);
        }

        private void processLogLine(String previousLine, String nextLine) {
            Level nextLogLevel = ProcessErrorStreamReader.getLevel(nextLine);
            if (nextLogLevel != null) {
                ProcessErrorStreamReader.writeLog(this.currentLogLevel, this.currentLog);
                this.currentLog = new StringBuilder();
                this.currentLogLevel = nextLogLevel;
                this.collectionMode = previousLine.contains(GCD_LOGGING_CLASS);
            } else if (this.collectionMode) {
                if (this.currentLog.length() > 50000) {
                    this.collectionMode = false;
                } else if (this.currentLog.length() == 0) {
                    this.currentLog.append("GCD");
                    this.currentLog.append(previousLine.split(":", 2)[1]);
                    this.currentLog.append(System.getProperty("line.separator"));
                } else {
                    this.currentLog.append(previousLine);
                    this.currentLog.append(System.getProperty("line.separator"));
                }
            }
        }

        private static void writeLog(Level level, StringBuilder msg) {
            if (level != null && msg != null && msg.length() != 0) {
                log.log(level, msg.toString().trim());
            }
        }

        private static Level getLevel(String line) {
            try {
                return Level.parse(line.split(":")[0]);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static ProcessErrorStreamReader start(InputStream errorStream) {
            ProcessErrorStreamReader thread = new ProcessErrorStreamReader(errorStream);
            thread.start();
            return thread;
        }
    }

    private static class ProcessStreamReader
    extends Thread {
        private final BufferedReader reader;
        private volatile boolean terminated;

        ProcessStreamReader(InputStream inputStream, String blockUntil) throws IOException {
            super("Local GCD InputStream reader");
            this.setDaemon(true);
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            if (!Strings.isNullOrEmpty((String)blockUntil)) {
                String line;
                while ((line = this.reader.readLine()) != null && !line.contains(blockUntil)) {
                }
            }
        }

        void terminate() throws IOException {
            this.terminated = true;
            this.reader.close();
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    String line = this.reader.readLine();
                    if (line != null) continue;
                    this.terminated = true;
                }
                catch (IOException iOException) {}
            }
        }

        public static ProcessStreamReader start(InputStream inputStream, String blockUntil) throws IOException {
            ProcessStreamReader thread = new ProcessStreamReader(inputStream, blockUntil);
            thread.start();
            return thread;
        }
    }
}

