/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.data.v2.models.Value;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class RowMutation
implements MutationApi<RowMutation>,
Serializable {
    private static final long serialVersionUID = 6529002234913236318L;
    private final TargetId targetId;
    private final ByteString key;
    private final Mutation mutation;

    private RowMutation(TargetId targetId, ByteString key, Mutation mutation) {
        Preconditions.checkNotNull((Object)targetId, (Object)"target id can't be null.");
        this.targetId = targetId;
        this.key = key;
        this.mutation = mutation;
    }

    @Deprecated
    public static RowMutation create(String tableId, String key) {
        return RowMutation.create(tableId, ByteString.copyFromUtf8((String)key));
    }

    public static RowMutation create(TargetId targetId, String key) {
        Preconditions.checkNotNull((Object)targetId, (Object)"target id can't be null.");
        return RowMutation.create(targetId, ByteString.copyFromUtf8((String)key));
    }

    @Deprecated
    public static RowMutation create(String tableId, ByteString key) {
        return new RowMutation(TableId.of(tableId), key, Mutation.create());
    }

    public static RowMutation create(TargetId targetId, ByteString key) {
        Preconditions.checkNotNull((Object)targetId, (Object)"target id can't be null.");
        return new RowMutation(targetId, key, Mutation.create());
    }

    @Deprecated
    public static RowMutation create(String tableId, String key, Mutation mutation) {
        return RowMutation.create(tableId, ByteString.copyFromUtf8((String)key), mutation);
    }

    public static RowMutation create(TargetId targetId, String key, Mutation mutation) {
        return RowMutation.create(targetId, ByteString.copyFromUtf8((String)key), mutation);
    }

    @Deprecated
    public static RowMutation create(String tableId, ByteString key, Mutation mutation) {
        return new RowMutation(TableId.of(tableId), key, mutation);
    }

    public static RowMutation create(TargetId targetId, ByteString key, Mutation mutation) {
        return new RowMutation(targetId, key, mutation);
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull String qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
        this.mutation.deleteCells(familyName, qualifier, timestampRange);
        return this;
    }

    @Override
    public RowMutation deleteFamily(@Nonnull String familyName) {
        this.mutation.deleteFamily(familyName);
        return this;
    }

    @Override
    public RowMutation deleteRow() {
        this.mutation.deleteRow();
        return this;
    }

    @Override
    public RowMutation addToCell(@Nonnull String familyName, @Nonnull Value qualifier, @Nonnull Value timestamp, @Nonnull Value input) {
        this.mutation.addToCell(familyName, qualifier, timestamp, input);
        return this;
    }

    @InternalApi
    public MutateRowRequest toProto(RequestContext requestContext) {
        MutateRowRequest.Builder builder = MutateRowRequest.newBuilder();
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForAuthorizedView()) {
            builder.setAuthorizedViewName(resourceName);
        } else {
            builder.setTableName(resourceName);
        }
        return builder.setAppProfileId(requestContext.getAppProfileId()).setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build();
    }

    @InternalApi
    public MutateRowsRequest toBulkProto(RequestContext requestContext) {
        MutateRowsRequest.Builder builder = MutateRowsRequest.newBuilder();
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForAuthorizedView()) {
            builder.setAuthorizedViewName(resourceName);
        } else {
            builder.setTableName(resourceName);
        }
        return builder.setAppProfileId(requestContext.getAppProfileId()).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build()).build();
    }

    @BetaApi
    public static RowMutation fromProto(@Nonnull MutateRowRequest request) {
        String tableName = request.getTableName();
        String authorizedViewName = request.getAuthorizedViewName();
        return RowMutation.create(NameUtil.extractTargetId(tableName, authorizedViewName), request.getRowKey(), Mutation.fromProto(request.getMutationsList()));
    }
}

