/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.DeleteWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.GetWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.InstantiateInlineWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.InstantiateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.ListWorkflowTemplatesRequest;
import com.google.cloud.dataproc.v1.ListWorkflowTemplatesResponse;
import com.google.cloud.dataproc.v1.UpdateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.WorkflowMetadata;
import com.google.cloud.dataproc.v1.WorkflowTemplate;
import com.google.cloud.dataproc.v1.WorkflowTemplateServiceClient;
import com.google.cloud.dataproc.v1.stub.GrpcWorkflowTemplateServiceCallableFactory;
import com.google.cloud.dataproc.v1.stub.WorkflowTemplateServiceStub;
import com.google.cloud.dataproc.v1.stub.WorkflowTemplateServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcWorkflowTemplateServiceStub
extends WorkflowTemplateServiceStub {
    private static final MethodDescriptor<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/CreateWorkflowTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWorkflowTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WorkflowTemplate.getDefaultInstance())).build();
    private static final MethodDescriptor<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/GetWorkflowTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWorkflowTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WorkflowTemplate.getDefaultInstance())).build();
    private static final MethodDescriptor<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateWorkflowTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)InstantiateWorkflowTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateInlineWorkflowTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)InstantiateInlineWorkflowTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/UpdateWorkflowTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWorkflowTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WorkflowTemplate.getDefaultInstance())).build();
    private static final MethodDescriptor<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/ListWorkflowTemplates").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWorkflowTemplatesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWorkflowTemplatesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/DeleteWorkflowTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWorkflowTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateCallable;
    private final UnaryCallable<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateCallable;
    private final UnaryCallable<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateCallable;
    private final OperationCallable<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationCallable;
    private final UnaryCallable<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateCallable;
    private final OperationCallable<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationCallable;
    private final UnaryCallable<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateCallable;
    private final UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesCallable;
    private final UnaryCallable<ListWorkflowTemplatesRequest, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesPagedCallable;
    private final UnaryCallable<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcWorkflowTemplateServiceStub create(WorkflowTemplateServiceStubSettings settings) throws IOException {
        return new GrpcWorkflowTemplateServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcWorkflowTemplateServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcWorkflowTemplateServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcWorkflowTemplateServiceCallableFactory());
    }

    protected GrpcWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createWorkflowTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWorkflowTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getWorkflowTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWorkflowTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings instantiateWorkflowTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(instantiateWorkflowTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings instantiateInlineWorkflowTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(instantiateInlineWorkflowTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateWorkflowTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWorkflowTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("template.name", String.valueOf(request.getTemplate().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listWorkflowTemplatesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWorkflowTemplatesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteWorkflowTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWorkflowTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createWorkflowTemplateCallable = callableFactory.createUnaryCallable(createWorkflowTemplateTransportSettings, settings.createWorkflowTemplateSettings(), clientContext);
        this.getWorkflowTemplateCallable = callableFactory.createUnaryCallable(getWorkflowTemplateTransportSettings, settings.getWorkflowTemplateSettings(), clientContext);
        this.instantiateWorkflowTemplateCallable = callableFactory.createUnaryCallable(instantiateWorkflowTemplateTransportSettings, settings.instantiateWorkflowTemplateSettings(), clientContext);
        this.instantiateWorkflowTemplateOperationCallable = callableFactory.createOperationCallable(instantiateWorkflowTemplateTransportSettings, settings.instantiateWorkflowTemplateOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.instantiateInlineWorkflowTemplateCallable = callableFactory.createUnaryCallable(instantiateInlineWorkflowTemplateTransportSettings, settings.instantiateInlineWorkflowTemplateSettings(), clientContext);
        this.instantiateInlineWorkflowTemplateOperationCallable = callableFactory.createOperationCallable(instantiateInlineWorkflowTemplateTransportSettings, settings.instantiateInlineWorkflowTemplateOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateWorkflowTemplateCallable = callableFactory.createUnaryCallable(updateWorkflowTemplateTransportSettings, settings.updateWorkflowTemplateSettings(), clientContext);
        this.listWorkflowTemplatesCallable = callableFactory.createUnaryCallable(listWorkflowTemplatesTransportSettings, settings.listWorkflowTemplatesSettings(), clientContext);
        this.listWorkflowTemplatesPagedCallable = callableFactory.createPagedCallable(listWorkflowTemplatesTransportSettings, settings.listWorkflowTemplatesSettings(), clientContext);
        this.deleteWorkflowTemplateCallable = callableFactory.createUnaryCallable(deleteWorkflowTemplateTransportSettings, settings.deleteWorkflowTemplateSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateCallable() {
        return this.createWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateCallable() {
        return this.getWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateCallable() {
        return this.instantiateWorkflowTemplateCallable;
    }

    @Override
    public OperationCallable<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationCallable() {
        return this.instantiateWorkflowTemplateOperationCallable;
    }

    @Override
    public UnaryCallable<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateCallable() {
        return this.instantiateInlineWorkflowTemplateCallable;
    }

    @Override
    public OperationCallable<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationCallable() {
        return this.instantiateInlineWorkflowTemplateOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateCallable() {
        return this.updateWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesCallable() {
        return this.listWorkflowTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListWorkflowTemplatesRequest, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesPagedCallable() {
        return this.listWorkflowTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateCallable() {
        return this.deleteWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

