/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.Context;
import com.google.cloud.logging.LoggingConfig;

public class ContextHandler {
    private static final ThreadLocal<Context> contextHolder = ContextHandler.initContextHolder();

    private static ThreadLocal<Context> initContextHolder() {
        LoggingConfig config = new LoggingConfig(ContextHandler.class.getName());
        if (config.getUseInheritedContext()) {
            return new InheritableThreadLocal<Context>();
        }
        return new ThreadLocal<Context>();
    }

    public Context getCurrentContext() {
        return contextHolder.get();
    }

    public void setCurrentContext(Context context) {
        contextHolder.set(context);
    }

    public void removeCurrentContext() {
        contextHolder.remove();
    }
}

