/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.wire.ApiExceptionCommitter;
import com.google.cloud.pubsublite.internal.wire.AutoValue_CommitterSettings;
import com.google.cloud.pubsublite.internal.wire.BatchingCommitter;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterImpl;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.proto.InitialCommitCursorRequest;
import java.time.Duration;

@AutoValue
public abstract class CommitterSettings {
    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract StreamFactories.CursorStreamFactory streamFactory();

    public static Builder newBuilder() {
        return new AutoValue_CommitterSettings.Builder();
    }

    public Committer instantiate() {
        InitialCommitCursorRequest initialCommitCursorRequest = InitialCommitCursorRequest.newBuilder().setSubscription(this.subscriptionPath().toString()).setPartition(this.partition().value()).build();
        return new ApiExceptionCommitter(new BatchingCommitter(new CommitterImpl(this.streamFactory(), initialCommitCursorRequest), AlarmFactory.create(Duration.ofMillis(50L))));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setStreamFactory(StreamFactories.CursorStreamFactory var1);

        public abstract CommitterSettings build();
    }
}

