/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;

public class DocTreeScanner<R, P>
implements DocTreeVisitor<R, P> {
    public R scan(DocTree node, P p) {
        return node == null ? null : (R)node.accept(this, p);
    }

    private R scanAndReduce(DocTree node, P p, R r) {
        return this.reduce(this.scan(node, p), r);
    }

    public R scan(Iterable<? extends DocTree> nodes, P p) {
        R r = null;
        if (nodes != null) {
            boolean first = true;
            for (DocTree docTree : nodes) {
                r = (R)(first ? this.scan(docTree, p) : this.scanAndReduce(docTree, p, r));
                first = false;
            }
        }
        return r;
    }

    private R scanAndReduce(Iterable<? extends DocTree> nodes, P p, R r) {
        return this.reduce(this.scan(nodes, p), r);
    }

    public R reduce(R r1, R r2) {
        return r1;
    }

    @Override
    public R visitAttribute(AttributeTree node, P p) {
        return null;
    }

    @Override
    public R visitAuthor(AuthorTree node, P p) {
        return this.scan(node.getName(), p);
    }

    @Override
    public R visitComment(CommentTree node, P p) {
        return null;
    }

    @Override
    public R visitDeprecated(DeprecatedTree node, P p) {
        return this.scan(node.getBody(), p);
    }

    @Override
    public R visitDocComment(DocCommentTree node, P p) {
        R r = this.scan(node.getFirstSentence(), p);
        r = this.scanAndReduce(node.getBody(), p, r);
        r = this.scanAndReduce(node.getBlockTags(), p, r);
        return r;
    }

    @Override
    public R visitDocRoot(DocRootTree node, P p) {
        return null;
    }

    @Override
    public R visitEndElement(EndElementTree node, P p) {
        return null;
    }

    @Override
    public R visitEntity(EntityTree node, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree node, P p) {
        return null;
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        return null;
    }

    @Override
    public R visitIndex(IndexTree node, P p) {
        R r = this.scan(node.getSearchTerm(), p);
        r = this.scanAndReduce(node.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitInheritDoc(InheritDocTree node, P p) {
        return null;
    }

    @Override
    public R visitLink(LinkTree node, P p) {
        R r = this.scan(node.getReference(), p);
        r = this.scanAndReduce(node.getLabel(), p, r);
        return r;
    }

    @Override
    public R visitLiteral(LiteralTree node, P p) {
        return null;
    }

    @Override
    public R visitParam(ParamTree node, P p) {
        R r = this.scan(node.getName(), p);
        r = this.scanAndReduce(node.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitReference(ReferenceTree node, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree node, P p) {
        return this.scan(node.getDescription(), p);
    }

    @Override
    public R visitSee(SeeTree node, P p) {
        return this.scan(node.getReference(), p);
    }

    @Override
    public R visitSerial(SerialTree node, P p) {
        return this.scan(node.getDescription(), p);
    }

    @Override
    public R visitSerialData(SerialDataTree node, P p) {
        return this.scan(node.getDescription(), p);
    }

    @Override
    public R visitSerialField(SerialFieldTree node, P p) {
        R r = this.scan(node.getName(), p);
        r = this.scanAndReduce(node.getType(), p, r);
        r = this.scanAndReduce(node.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitSince(SinceTree node, P p) {
        return this.scan(node.getBody(), p);
    }

    @Override
    public R visitStartElement(StartElementTree node, P p) {
        return this.scan(node.getAttributes(), p);
    }

    @Override
    public R visitText(TextTree node, P p) {
        return null;
    }

    @Override
    public R visitThrows(ThrowsTree node, P p) {
        R r = this.scan(node.getExceptionName(), p);
        r = this.scanAndReduce(node.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitUnknownBlockTag(UnknownBlockTagTree node, P p) {
        return this.scan(node.getContent(), p);
    }

    @Override
    public R visitUnknownInlineTag(UnknownInlineTagTree node, P p) {
        return this.scan(node.getContent(), p);
    }

    @Override
    public R visitValue(ValueTree node, P p) {
        return this.scan(node.getReference(), p);
    }

    @Override
    public R visitVersion(VersionTree node, P p) {
        return this.scan(node.getBody(), p);
    }

    @Override
    public R visitOther(DocTree node, P p) {
        return null;
    }
}

