/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class Analyzer {
    protected static final Context.Key<Analyzer> analyzerKey = new Context.Key();
    final Types types;
    final Log log;
    final Attr attr;
    final DeferredAttr deferredAttr;
    final ArgumentAttr argumentAttr;
    final TreeMaker make;
    final Names names;
    private final boolean allowDiamondWithAnonymousClassCreation;
    final EnumSet<AnalyzerMode> analyzerModes;
    StatementAnalyzer<JCTree, JCTree>[] analyzers = new StatementAnalyzer[]{new DiamondInitializer(), new LambdaAnalyzer(), new RedundantTypeArgAnalyzer()};

    public static Analyzer instance(Context context) {
        Analyzer instance = context.get(analyzerKey);
        if (instance == null) {
            instance = new Analyzer(context);
        }
        return instance;
    }

    protected Analyzer(Context context) {
        context.put(analyzerKey, this);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.make = TreeMaker.instance(context);
        this.names = Names.instance(context);
        Options options = Options.instance(context);
        String findOpt = options.get("find");
        Source source = Source.instance(context);
        this.allowDiamondWithAnonymousClassCreation = source.allowDiamondWithAnonymousClassCreation();
        this.analyzerModes = AnalyzerMode.getAnalyzerModes(findOpt, source);
    }

    void analyzeIfNeeded(JCTree tree, Env<AttrContext> env) {
        if (!this.analyzerModes.isEmpty() && !((AttrContext)env.info).isSpeculative && TreeInfo.isStatement(tree)) {
            JCTree.JCStatement stmt = (JCTree.JCStatement)tree;
            this.analyze(stmt, env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(JCTree.JCStatement statement, Env<AttrContext> env) {
        AnalysisContext context = new AnalysisContext();
        StatementScanner statementScanner = new StatementScanner(context);
        statementScanner.scan(statement);
        if (!context.treesToAnalyzer.isEmpty()) {
            JCTree.JCBlock fakeBlock = this.make.Block(4096L, List.of(statement));
            TreeMapper treeMapper = new TreeMapper(context);
            ArgumentAttr.LocalCacheContext localCacheContext = this.argumentAttr.withLocalCacheContext();
            try {
                this.deferredAttr.attribSpeculative(fakeBlock, env, this.attr.statInfo, treeMapper, t -> new AnalyzeDeferredDiagHandler(context));
            }
            finally {
                localCacheContext.leave();
            }
            context.treeMap.entrySet().forEach(e -> context.treesToAnalyzer.get(e.getKey()).process((JCTree)e.getKey(), (JCTree)e.getValue(), context.errors.nonEmpty()));
        }
    }

    class TreeMapper
    extends TreeCopier<Void> {
        AnalysisContext context;

        TreeMapper(AnalysisContext context) {
            super(Analyzer.this.make);
            this.context = context;
        }

        @Override
        public <Z extends JCTree> Z copy(Z tree, Void _unused) {
            Object newTree = super.copy(tree, _unused);
            StatementAnalyzer<JCTree, JCTree> analyzer = this.context.treesToAnalyzer.get(tree);
            if (analyzer != null) {
                newTree = analyzer.map(tree, (JCTree)newTree);
                this.context.treeMap.put(tree, (JCTree)newTree);
            }
            return newTree;
        }

        @Override
        public JCTree visitLambdaExpression(LambdaExpressionTree node, Void _unused) {
            JCTree.JCLambda oldLambda = (JCTree.JCLambda)node;
            JCTree.JCLambda newLambda = (JCTree.JCLambda)super.visitLambdaExpression(node, _unused);
            if (oldLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                newLambda.paramKind = JCTree.JCLambda.ParameterKind.IMPLICIT;
                newLambda.params.forEach(p -> {
                    p.vartype = null;
                });
            }
            return newLambda;
        }
    }

    class StatementScanner
    extends TreeScanner {
        AnalysisContext context;

        StatementScanner(AnalysisContext context) {
            this.context = context;
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null) {
                for (StatementAnalyzer<JCTree, JCTree> analyzer : Analyzer.this.analyzers) {
                    if (!analyzer.isEnabled() || !tree.hasTag(analyzer.tag) || !analyzer.match(tree)) continue;
                    this.context.treesToAnalyzer.put(tree, analyzer);
                    break;
                }
            }
            super.scan(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            this.scan(tree.getExpression());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            this.scan((List<? extends JCTree>)tree.getInitializer());
            this.scan(tree.getCondition());
            this.scan((List<? extends JCTree>)tree.getUpdate());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.scan(tree.getExpression());
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            this.scan(tree.getCondition());
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            this.scan(tree.getCondition());
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scan(tree.getCondition());
        }
    }

    class AnalysisContext {
        Map<JCTree, StatementAnalyzer<JCTree, JCTree>> treesToAnalyzer = new HashMap<JCTree, StatementAnalyzer<JCTree, JCTree>>();
        Map<JCTree, JCTree> treeMap = new HashMap<JCTree, JCTree>();
        ListBuffer<JCDiagnostic> errors = new ListBuffer();

        AnalysisContext() {
        }
    }

    class AnalyzeDeferredDiagHandler
    extends Log.DeferredDiagnosticHandler {
        AnalysisContext context;

        public AnalyzeDeferredDiagHandler(AnalysisContext context) {
            super(Analyzer.this.log, (JCDiagnostic d) -> {
                if (d.getType() == JCDiagnostic.DiagnosticType.ERROR) {
                    context.errors.add((JCDiagnostic)d);
                }
                return true;
            });
            this.context = context;
        }
    }

    class RedundantTypeArgAnalyzer
    extends StatementAnalyzer<JCTree.JCMethodInvocation, JCTree.JCMethodInvocation> {
        RedundantTypeArgAnalyzer() {
            super(AnalyzerMode.METHOD, JCTree.Tag.APPLY);
        }

        @Override
        boolean match(JCTree.JCMethodInvocation tree) {
            return tree.typeargs != null && tree.typeargs.nonEmpty();
        }

        @Override
        JCTree.JCMethodInvocation map(JCTree.JCMethodInvocation oldTree, JCTree.JCMethodInvocation newTree) {
            newTree.typeargs = List.nil();
            return newTree;
        }

        @Override
        void process(JCTree.JCMethodInvocation oldTree, JCTree.JCMethodInvocation newTree, boolean hasErrors) {
            if (!hasErrors) {
                Analyzer.this.log.warning(oldTree, "method.redundant.typeargs", new Object[0]);
            }
        }
    }

    class LambdaAnalyzer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCLambda> {
        LambdaAnalyzer() {
            super(AnalyzerMode.LAMBDA, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass tree) {
            Type clazztype = tree.clazz.type;
            return tree.def != null && clazztype.hasTag(TypeTag.CLASS) && Analyzer.this.types.isFunctionalInterface(clazztype.tsym) && this.decls(tree.def).length() == 1;
        }

        private List<JCTree> decls(JCTree.JCClassDecl decl) {
            ListBuffer<JCTree> decls = new ListBuffer<JCTree>();
            for (JCTree t : decl.defs) {
                if (t.hasTag(JCTree.Tag.METHODDEF)) {
                    JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)t;
                    if ((md.getModifiers().flags & 0x1000000000L) != 0L) continue;
                    decls.add(md);
                    continue;
                }
                decls.add(t);
            }
            return decls.toList();
        }

        @Override
        JCTree.JCLambda map(JCTree.JCNewClass oldTree, JCTree.JCNewClass newTree) {
            JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)this.decls((JCTree.JCClassDecl)newTree.def).head;
            List<JCTree.JCVariableDecl> params = md.params;
            JCTree.JCBlock body = md.body;
            return Analyzer.this.make.Lambda(params, body);
        }

        @Override
        void process(JCTree.JCNewClass oldTree, JCTree.JCLambda newTree, boolean hasErrors) {
            if (!hasErrors) {
                Analyzer.this.log.warning(oldTree.def, "potential.lambda.found", new Object[0]);
            }
        }
    }

    class DiamondInitializer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCNewClass> {
        DiamondInitializer() {
            super(AnalyzerMode.DIAMOND, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass tree) {
            return tree.clazz.hasTag(JCTree.Tag.TYPEAPPLY) && !TreeInfo.isDiamond(tree) && (tree.def == null || Analyzer.this.allowDiamondWithAnonymousClassCreation);
        }

        @Override
        JCTree.JCNewClass map(JCTree.JCNewClass oldTree, JCTree.JCNewClass newTree) {
            if (newTree.clazz.hasTag(JCTree.Tag.TYPEAPPLY)) {
                ((JCTree.JCTypeApply)newTree.clazz).arguments = List.nil();
            }
            return newTree;
        }

        @Override
        void process(JCTree.JCNewClass oldTree, JCTree.JCNewClass newTree, boolean hasErrors) {
            if (!hasErrors) {
                List<Type> explicitArgs;
                List<Type> inferredArgs;
                if (oldTree.def != null) {
                    inferredArgs = newTree.def.implementing.nonEmpty() ? newTree.def.implementing.get((int)0).type.getTypeArguments() : newTree.def.extending.type.getTypeArguments();
                    explicitArgs = oldTree.def.implementing.nonEmpty() ? oldTree.def.implementing.get((int)0).type.getTypeArguments() : oldTree.def.extending.type.getTypeArguments();
                } else {
                    inferredArgs = newTree.type.getTypeArguments();
                    explicitArgs = oldTree.type.getTypeArguments();
                }
                for (Type t : inferredArgs) {
                    if (!Analyzer.this.types.isSameType(t, (Type)explicitArgs.head)) {
                        return;
                    }
                    explicitArgs = explicitArgs.tail;
                }
                Analyzer.this.log.warning(oldTree.clazz, "diamond.redundant.args", new Object[0]);
            }
        }
    }

    abstract class StatementAnalyzer<S extends JCTree, T extends JCTree> {
        AnalyzerMode mode;
        JCTree.Tag tag;

        StatementAnalyzer(AnalyzerMode mode, JCTree.Tag tag) {
            this.mode = mode;
            this.tag = tag;
        }

        boolean isEnabled() {
            return Analyzer.this.analyzerModes.contains((Object)this.mode);
        }

        abstract boolean match(S var1);

        abstract T map(S var1, S var2);

        abstract void process(S var1, T var2, boolean var3);
    }

    static enum AnalyzerMode {
        DIAMOND("diamond", Source::allowDiamond),
        LAMBDA("lambda", Source::allowLambda),
        METHOD("method", Source::allowGraphInference);

        final String opt;
        final Predicate<Source> sourceFilter;

        private AnalyzerMode(String opt, Predicate<Source> sourceFilter) {
            this.opt = opt;
            this.sourceFilter = sourceFilter;
        }

        static EnumSet<AnalyzerMode> getAnalyzerModes(String opt, Source source) {
            if (opt == null) {
                return EnumSet.noneOf(AnalyzerMode.class);
            }
            List<String> modes = List.from(opt.split(","));
            EnumSet<AnalyzerMode> res = EnumSet.noneOf(AnalyzerMode.class);
            if (modes.contains("all")) {
                res = EnumSet.allOf(AnalyzerMode.class);
            }
            for (AnalyzerMode mode : AnalyzerMode.values()) {
                if (modes.contains(mode.opt)) {
                    res.add(mode);
                    continue;
                }
                if (!modes.contains("-" + mode.opt) && mode.sourceFilter.test(source)) continue;
                res.remove((Object)mode);
            }
            return res;
        }
    }
}

