/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.jvm.Items;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public abstract class StringConcat {
    private static final int MAX_INDY_CONCAT_ARG_SLOTS = 200;
    private static final char TAG_ARG = '\u0001';
    private static final char TAG_CONST = '\u0002';
    protected final Gen gen;
    protected final Symtab syms;
    protected final Names names;
    protected final TreeMaker make;
    protected final Types types;
    protected final Map<Type, Symbol> sbAppends;
    protected final Resolve rs;
    protected static final Context.Key<StringConcat> concatKey = new Context.Key();

    public static StringConcat instance(Context context) {
        StringConcat instance = context.get(concatKey);
        if (instance == null) {
            instance = StringConcat.makeConcat(context);
        }
        return instance;
    }

    private static StringConcat makeConcat(Context context) {
        Target target = Target.instance(context);
        String opt = Options.instance(context).get("stringConcat");
        if (opt == null) {
            opt = "inline";
        }
        if (target.hasStringConcatFactory()) {
            if (opt == null) {
                opt = "indyWithConstants";
            }
        } else {
            if (opt != null && !"inline".equals(opt)) {
                Assert.error("StringConcatFactory-based string concat is requested on a platform that does not support it.");
            }
            opt = "inline";
        }
        switch (opt) {
            case "inline": {
                return new Inline(context);
            }
            case "indy": {
                return new IndyPlain(context);
            }
            case "indyWithConstants": {
                return new IndyConstants(context);
            }
        }
        Assert.error("Unknown stringConcat: " + opt);
        throw new IllegalStateException("Unknown stringConcat: " + opt);
    }

    protected StringConcat(Context context) {
        context.put(concatKey, this);
        this.gen = Gen.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.names = Names.instance(context);
        this.make = TreeMaker.instance(context);
        this.rs = Resolve.instance(context);
        this.sbAppends = new HashMap<Type, Symbol>();
    }

    public abstract Items.Item makeConcat(JCTree.JCAssignOp var1);

    public abstract Items.Item makeConcat(JCTree.JCBinary var1);

    protected List<JCTree> collectAll(JCTree tree) {
        return this.collect(tree, List.nil());
    }

    protected List<JCTree> collectAll(JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        return List.nil().appendList(this.collectAll(lhs)).appendList(this.collectAll(rhs));
    }

    private List<JCTree> collect(JCTree tree, List<JCTree> res) {
        if ((tree = TreeInfo.skipParens(tree)).hasTag(JCTree.Tag.PLUS) && tree.type.constValue() == null) {
            JCTree.JCBinary op = (JCTree.JCBinary)tree;
            if (op.operator.kind == Kinds.Kind.MTH && ((Symbol.OperatorSymbol)op.operator).opcode == 256) {
                return res.appendList(this.collect(op.lhs, res)).appendList(this.collect(op.rhs, res));
            }
        }
        return res.append(tree);
    }

    Type sharpestAccessible(Type originalType) {
        if (originalType.hasTag(TypeTag.ARRAY)) {
            return this.types.makeArrayType(this.sharpestAccessible(this.types.elemtype(originalType)));
        }
        Type type = originalType;
        while (!this.rs.isAccessible(this.gen.getAttrEnv(), type.asElement())) {
            type = this.types.supertype(type);
        }
        return type;
    }

    private static final class IndyConstants
    extends Indy {
        public IndyConstants(Context context) {
            super(context);
        }

        @Override
        protected void emit(List<JCTree> args, Type type, JCDiagnostic.DiagnosticPosition pos) {
            List<List<JCTree>> split = this.split(args);
            for (List<JCTree> t : split) {
                Assert.check(!t.isEmpty(), "Arguments list is empty");
                StringBuilder recipe = new StringBuilder(t.size());
                ListBuffer<Type> dynamicArgs = new ListBuffer<Type>();
                ListBuffer<String> staticArgs = new ListBuffer<String>();
                for (JCTree arg : t) {
                    Object constVal = arg.type.constValue();
                    if ("".equals(constVal)) continue;
                    if (arg.type == this.syms.botType) {
                        recipe.append((String)null);
                        continue;
                    }
                    if (constVal != null) {
                        String a = arg.type.stringValue();
                        if (a.indexOf(2) != -1 || a.indexOf(1) != -1) {
                            recipe.append('\u0002');
                            staticArgs.add(a);
                            continue;
                        }
                        recipe.append(a);
                        continue;
                    }
                    recipe.append('\u0001');
                    dynamicArgs.add(this.sharpestAccessible(arg.type));
                    this.gen.genExpr(arg, arg.type).load();
                }
                this.doCall(type, pos, recipe.toString(), staticArgs.toList(), dynamicArgs.toList());
            }
            if (split.size() > 1) {
                ListBuffer<Type> argTypes = new ListBuffer<Type>();
                StringBuilder recipe = new StringBuilder();
                for (int c = 0; c < split.size(); ++c) {
                    argTypes.append(this.syms.stringType);
                    recipe.append('\u0001');
                }
                this.doCall(type, pos, recipe.toString(), List.nil(), argTypes.toList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCall(Type type, JCDiagnostic.DiagnosticPosition pos, String recipe, List<Object> staticArgs, List<Type> dynamicArgTypes) {
            Type.MethodType indyType = new Type.MethodType(dynamicArgTypes, type, List.nil(), this.syms.methodClass);
            int prevPos = this.make.pos;
            try {
                this.make.at(pos);
                ListBuffer<Type> constTypes = new ListBuffer<Type>();
                ListBuffer<Object> constants = new ListBuffer<Object>();
                for (Object t : staticArgs) {
                    constants.add(t);
                    constTypes.add(this.syms.stringType);
                }
                List<Type> bsm_staticArgs = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).append(this.syms.stringType).appendList(constTypes);
                Symbol.MethodSymbol bsm = this.rs.resolveInternalMethod(pos, this.gen.getAttrEnv(), this.syms.stringConcatFactory, this.names.makeConcatWithConstants, bsm_staticArgs, null);
                Symbol.DynamicMethodSymbol dynSym = new Symbol.DynamicMethodSymbol(this.names.makeConcatWithConstants, this.syms.noSymbol, 6, bsm, indyType, List.of(recipe).appendList(constants).toArray());
                Items.Item item = this.gen.getItems().makeDynamicItem(dynSym);
                item.invoke();
            }
            finally {
                this.make.at(prevPos);
            }
        }
    }

    private static class IndyPlain
    extends Indy {
        public IndyPlain(Context context) {
            super(context);
        }

        @Override
        protected void emit(List<JCTree> args, Type type, JCDiagnostic.DiagnosticPosition pos) {
            List<List<JCTree>> split = this.split(args);
            for (List<JCTree> t : split) {
                Assert.check(!t.isEmpty(), "Arguments list is empty");
                ListBuffer<Type> dynamicArgs = new ListBuffer<Type>();
                for (JCTree arg : t) {
                    Object constVal = arg.type.constValue();
                    if ("".equals(constVal)) continue;
                    if (arg.type == this.syms.botType) {
                        dynamicArgs.add(this.types.boxedClass((Type)this.syms.voidType).type);
                    } else {
                        dynamicArgs.add(this.sharpestAccessible(arg.type));
                    }
                    this.gen.genExpr(arg, arg.type).load();
                }
                this.doCall(type, pos, dynamicArgs.toList());
            }
            if (split.size() > 1) {
                ListBuffer<Type> argTypes = new ListBuffer<Type>();
                for (int c = 0; c < split.size(); ++c) {
                    argTypes.append(this.syms.stringType);
                }
                this.doCall(type, pos, argTypes.toList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCall(Type type, JCDiagnostic.DiagnosticPosition pos, List<Type> dynamicArgTypes) {
            Type.MethodType indyType = new Type.MethodType(dynamicArgTypes, type, List.nil(), this.syms.methodClass);
            int prevPos = this.make.pos;
            try {
                this.make.at(pos);
                List<Type> bsm_staticArgs = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType);
                Symbol.MethodSymbol bsm = this.rs.resolveInternalMethod(pos, this.gen.getAttrEnv(), this.syms.stringConcatFactory, this.names.makeConcat, bsm_staticArgs, null);
                Symbol.DynamicMethodSymbol dynSym = new Symbol.DynamicMethodSymbol(this.names.makeConcat, this.syms.noSymbol, 6, bsm, indyType, List.nil().toArray());
                Items.Item item = this.gen.getItems().makeDynamicItem(dynSym);
                item.invoke();
            }
            finally {
                this.make.at(prevPos);
            }
        }
    }

    private static abstract class Indy
    extends StringConcat {
        public Indy(Context context) {
            super(context);
        }

        @Override
        public Items.Item makeConcat(JCTree.JCAssignOp tree) {
            List<JCTree> args = this.collectAll(tree.lhs, tree.rhs);
            Items.Item l = this.gen.genExpr(tree.lhs, tree.lhs.type);
            this.emit(args, tree.type, tree.pos());
            return l;
        }

        @Override
        public Items.Item makeConcat(JCTree.JCBinary tree) {
            List<JCTree> args = this.collectAll(tree.lhs, tree.rhs);
            this.emit(args, tree.type, tree.pos());
            return this.gen.getItems().makeStackItem(this.syms.stringType);
        }

        protected abstract void emit(List<JCTree> var1, Type var2, JCDiagnostic.DiagnosticPosition var3);

        protected List<List<JCTree>> split(List<JCTree> args) {
            ListBuffer splits = new ListBuffer();
            int slots = 0;
            ListBuffer<JCTree> cArgs = new ListBuffer<JCTree>();
            for (JCTree t : args) {
                int needSlots;
                int n = needSlots = t.type.getTag() == TypeTag.LONG || t.type.getTag() == TypeTag.DOUBLE ? 2 : 1;
                if (slots + needSlots >= 200) {
                    splits.add(cArgs.toList());
                    cArgs.clear();
                    slots = 0;
                }
                cArgs.add(t);
                slots += needSlots;
            }
            if (!cArgs.isEmpty()) {
                splits.add(cArgs.toList());
            }
            return splits.toList();
        }
    }

    private static class Inline
    extends StringConcat {
        public Inline(Context context) {
            super(context);
        }

        @Override
        public Items.Item makeConcat(JCTree.JCAssignOp tree) {
            JCDiagnostic.DiagnosticPosition pos = tree.pos();
            this.newStringBuilder(tree);
            Items.Item l = this.gen.genExpr(tree.lhs, tree.lhs.type);
            if (l.width() > 0) {
                this.gen.getCode().emitop0(90 + 3 * (l.width() - 1));
            }
            l.load();
            this.appendString(tree.lhs);
            List<JCTree> args = this.collectAll(tree.rhs);
            for (JCTree t : args) {
                this.gen.genExpr(t, t.type).load();
                this.appendString(t);
            }
            this.builderToString(pos);
            return l;
        }

        @Override
        public Items.Item makeConcat(JCTree.JCBinary tree) {
            JCDiagnostic.DiagnosticPosition pos = tree.pos();
            this.newStringBuilder(tree);
            List<JCTree> args = this.collectAll(tree);
            for (JCTree t : args) {
                this.gen.genExpr(t, t.type).load();
                this.appendString(t);
            }
            this.builderToString(pos);
            return this.gen.getItems().makeStackItem(this.syms.stringType);
        }

        private JCDiagnostic.DiagnosticPosition newStringBuilder(JCTree tree) {
            JCDiagnostic.DiagnosticPosition pos = tree.pos();
            this.gen.getCode().emitop2(187, this.gen.makeRef(pos, this.syms.stringBuilderType));
            this.gen.getCode().emitop0(89);
            this.gen.callMethod(pos, this.syms.stringBuilderType, this.names.init, List.nil(), false);
            return pos;
        }

        private void appendString(JCTree tree) {
            Type t = tree.type.baseType();
            if (!t.isPrimitive() && t.tsym != this.syms.stringType.tsym) {
                t = this.syms.objectType;
            }
            Assert.checkNull(t.constValue());
            Symbol method = (Symbol)this.sbAppends.get(t);
            if (method == null) {
                method = this.rs.resolveInternalMethod(tree.pos(), this.gen.getAttrEnv(), this.syms.stringBuilderType, this.names.append, List.of(t), null);
                this.sbAppends.put(t, method);
            }
            this.gen.getItems().makeMemberItem(method, false).invoke();
        }

        private void builderToString(JCDiagnostic.DiagnosticPosition pos) {
            this.gen.callMethod(pos, this.syms.stringBuilderType, this.names.toString, List.nil(), false);
        }
    }
}

