/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";
    private static ToolProvider instance;
    private final Map<String, Reference<Class<?>>> toolClasses = new HashMap();

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.instance().getSystemTool(JavaCompiler.class, systemJavaCompilerName);
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return ToolProvider.instance().getSystemTool(DocumentationTool.class, systemDocumentationToolName);
    }

    public static ClassLoader getSystemToolClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    private static synchronized ToolProvider instance() {
        if (instance == null) {
            instance = new ToolProvider();
        }
        return instance;
    }

    private ToolProvider() {
    }

    private <T> T getSystemTool(Class<T> clazz, String name) {
        Class<T> c = this.getSystemToolClass(clazz, name);
        try {
            return c.asSubclass(clazz).newInstance();
        }
        catch (Error | IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new Error(e);
        }
    }

    private <T> Class<? extends T> getSystemToolClass(Class<T> clazz, String name) {
        Class<?> c;
        Reference<Class<?>> refClass = this.toolClasses.get(name);
        Class<?> clazz2 = c = refClass == null ? null : refClass.get();
        if (c == null) {
            try {
                c = Class.forName(name, false, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException | Error | RuntimeException e) {
                throw new Error(e);
            }
            this.toolClasses.put(name, new WeakReference(c));
        }
        return c.asSubclass(clazz);
    }
}

