/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html.markup;

import jdk.javadoc.internal.doclets.formats.html.markup.HtmlVersion;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;

public enum HtmlTag {
    A(BlockType.INLINE, EndTag.END),
    BLOCKQUOTE,
    BODY(BlockType.OTHER, EndTag.END),
    BR(BlockType.INLINE, EndTag.NOEND),
    CAPTION,
    CENTER(HtmlVersion.HTML4),
    CODE(BlockType.INLINE, EndTag.END),
    DD,
    DIR(HtmlVersion.HTML4),
    DIV,
    DL,
    DT,
    EM(BlockType.INLINE, EndTag.END),
    FONT(HtmlVersion.HTML4, BlockType.INLINE, EndTag.END),
    FOOTER(HtmlVersion.HTML5),
    H1,
    H2,
    H3,
    H4,
    H5,
    H6,
    HEAD(BlockType.OTHER, EndTag.END),
    HEADER(HtmlVersion.HTML5),
    HR(BlockType.BLOCK, EndTag.NOEND),
    HTML(BlockType.OTHER, EndTag.END),
    I(BlockType.INLINE, EndTag.END),
    IFRAME(BlockType.OTHER, EndTag.END),
    IMG(BlockType.INLINE, EndTag.NOEND),
    INPUT(BlockType.BLOCK, EndTag.NOEND),
    LI,
    LISTING,
    LINK(BlockType.OTHER, EndTag.NOEND),
    MAIN(HtmlVersion.HTML5),
    MENU,
    META(BlockType.OTHER, EndTag.NOEND),
    NAV(HtmlVersion.HTML5),
    NOSCRIPT(BlockType.OTHER, EndTag.END),
    OL,
    P,
    PRE,
    SCRIPT(BlockType.OTHER, EndTag.END),
    SECTION(HtmlVersion.HTML5),
    SMALL(BlockType.INLINE, EndTag.END),
    SPAN(BlockType.INLINE, EndTag.END),
    STRONG(BlockType.INLINE, EndTag.END),
    SUB(BlockType.INLINE, EndTag.END),
    TABLE,
    TBODY,
    TD,
    TH,
    TITLE(BlockType.OTHER, EndTag.END),
    TR,
    TT(HtmlVersion.HTML4, BlockType.INLINE, EndTag.END),
    UL;

    public final BlockType blockType;
    public final EndTag endTag;
    public final String value;
    public final HtmlVersion htmlVersion;

    private HtmlTag() {
        this(HtmlVersion.ALL, BlockType.BLOCK, EndTag.END);
    }

    private HtmlTag(HtmlVersion htmlVersion) {
        this(htmlVersion, BlockType.BLOCK, EndTag.END);
    }

    private HtmlTag(BlockType blockType, EndTag endTag) {
        this(HtmlVersion.ALL, blockType, endTag);
    }

    private HtmlTag(HtmlVersion htmlVersion, BlockType blockType, EndTag endTag) {
        this.htmlVersion = htmlVersion;
        this.blockType = blockType;
        this.endTag = endTag;
        this.value = Utils.toLowerCase(this.name());
    }

    public boolean endTagRequired() {
        return this.endTag == EndTag.END;
    }

    public boolean allowTag(HtmlVersion htmlVer) {
        return this.htmlVersion == HtmlVersion.ALL || this.htmlVersion == htmlVer;
    }

    public String toString() {
        return this.value;
    }

    public static enum EndTag {
        END,
        NOEND;

    }

    public static enum BlockType {
        BLOCK,
        INLINE,
        OTHER;

    }
}

